/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons.logging;

import com.github.nosan.embedded.cassandra.commons.StringUtils;
import com.github.nosan.embedded.cassandra.commons.logging.LoggerFactory;
import java.util.Objects;

public interface Logger {
    public static final String ROOT = "ROOT";

    public static Logger get(Class<?> clazz) {
        Objects.requireNonNull(clazz, "Class must not be null");
        return LoggerFactory.getLogger(clazz.getCanonicalName());
    }

    public static Logger get(String name) {
        Objects.requireNonNull(name, "Name must not be null");
        if (!StringUtils.hasText(name)) {
            name = ROOT;
        }
        return LoggerFactory.getLogger(name.trim());
    }

    public String getName();

    public boolean isErrorEnabled();

    public void error(String var1);

    public void error(String var1, Object ... var2);

    public void error(Throwable var1, String var2);

    public void error(Throwable var1, String var2, Object ... var3);

    public boolean isWarnEnabled();

    public void warn(String var1);

    public void warn(String var1, Object ... var2);

    public void warn(Throwable var1, String var2);

    public void warn(Throwable var1, String var2, Object ... var3);

    public boolean isInfoEnabled();

    public void info(String var1);

    public void info(String var1, Object ... var2);

    public void info(Throwable var1, String var2);

    public void info(Throwable var1, String var2, Object ... var3);

    public boolean isDebugEnabled();

    public void debug(String var1);

    public void debug(String var1, Object ... var2);

    public void debug(Throwable var1, String var2);

    public void debug(Throwable var1, String var2, Object ... var3);

    public boolean isTraceEnabled();

    public void trace(String var1);

    public void trace(String var1, Object ... var2);

    public void trace(Throwable var1, String var2);

    public void trace(Throwable var1, String var2, Object ... var3);
}

