/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons.logging;

import com.github.nosan.embedded.cassandra.commons.logging.ConsoleLogger;
import com.github.nosan.embedded.cassandra.commons.logging.Logger;
import com.github.nosan.embedded.cassandra.commons.logging.Slf4jLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.helpers.NOPLoggerFactory;

final class LoggerFactory {
    private static final Map<String, Logger> LOGGERS = new ConcurrentHashMap<String, Logger>(64);
    private static final LogApi LOG_API;
    private static final String SLF4J_API = "org.slf4j.LoggerFactory";

    private LoggerFactory() {
    }

    static Logger getLogger(String name) {
        return LOGGERS.computeIfAbsent(name, LoggerFactory::createLogger);
    }

    private static Logger createLogger(String name) {
        if (LOG_API == LogApi.SLF4J) {
            return new Slf4jLogger(org.slf4j.LoggerFactory.getLogger((String)name));
        }
        return new ConsoleLogger(name);
    }

    private static boolean isNOPLoggerFactory() {
        return org.slf4j.LoggerFactory.getILoggerFactory() instanceof NOPLoggerFactory;
    }

    private static boolean isPresent(String clazz, ClassLoader classLoader) {
        try {
            Class.forName(clazz, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    static {
        LogApi api = LoggerFactory.isPresent(SLF4J_API, LoggerFactory.class.getClassLoader()) && !LoggerFactory.isNOPLoggerFactory() ? LogApi.SLF4J : LogApi.CONSOLE;
        LOG_API = api;
    }

    private static enum LogApi {
        SLF4J,
        CONSOLE;

    }
}

