/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons.logging;

import com.github.nosan.embedded.cassandra.commons.logging.Logger;
import java.text.MessageFormat;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public class Slf4jLogger
implements Logger {
    private final org.slf4j.Logger logger;

    public Slf4jLogger(String name) {
        this(LoggerFactory.getLogger((String)name));
    }

    public Slf4jLogger(org.slf4j.Logger logger) {
        Objects.requireNonNull(logger, "Logger must not be null");
        this.logger = logger;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message);
        }
    }

    @Override
    public void error(String message, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(Slf4jLogger.format(message, args));
        }
    }

    @Override
    public void error(Throwable throwable, String message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message, throwable);
        }
    }

    @Override
    public void error(Throwable throwable, String message, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(Slf4jLogger.format(message, args), throwable);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message);
        }
    }

    @Override
    public void warn(String message, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(Slf4jLogger.format(message, args));
        }
    }

    @Override
    public void warn(Throwable throwable, String message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(message, throwable);
        }
    }

    @Override
    public void warn(Throwable throwable, String message, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(Slf4jLogger.format(message, args), throwable);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message);
        }
    }

    @Override
    public void info(String message, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(Slf4jLogger.format(message, args));
        }
    }

    @Override
    public void info(Throwable throwable, String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message, throwable);
        }
    }

    @Override
    public void info(Throwable throwable, String message, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(Slf4jLogger.format(message, args), throwable);
        }
    }

    @Override
    public void debug(String message, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Slf4jLogger.format(message, args));
        }
    }

    @Override
    public void debug(Throwable throwable, String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message, throwable);
        }
    }

    @Override
    public void debug(Throwable throwable, String message, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Slf4jLogger.format(message, args), throwable);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message);
        }
    }

    @Override
    public void trace(String message, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(Slf4jLogger.format(message, args));
        }
    }

    @Override
    public void trace(Throwable throwable, String message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(message, throwable);
        }
    }

    @Override
    public void trace(Throwable throwable, String message, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(Slf4jLogger.format(message, args), throwable);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String message) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(message);
        }
    }

    private static String format(String message, Object ... args) {
        if (message == null) {
            return null;
        }
        if (args == null || args.length == 0) {
            return message;
        }
        return MessageFormat.format(message, args);
    }
}

