/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons.web;

import com.github.nosan.embedded.cassandra.commons.web.ReadOnlyHttpHeaders;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;

public class HttpHeaders
implements Map<String, List<String>> {
    protected final HeaderValues headers;

    public HttpHeaders() {
        this(new HeaderValues());
    }

    protected HttpHeaders(HeaderValues headers) {
        this.headers = headers;
    }

    public static HttpHeaders readOnly(Map<String, List<String>> headers) {
        if (headers instanceof ReadOnlyHttpHeaders) {
            return (ReadOnlyHttpHeaders)headers;
        }
        if (headers instanceof HttpHeaders) {
            return new ReadOnlyHttpHeaders((HttpHeaders)headers);
        }
        return new ReadOnlyHttpHeaders(HttpHeaders.copyOf(headers));
    }

    public static HttpHeaders copyOf(Map<String, List<String>> headers) {
        Objects.requireNonNull(headers, "Headers must not be null");
        HttpHeaders httpHeaders = new HttpHeaders();
        headers.forEach((name, values) -> {
            if (name == null) {
                return;
            }
            httpHeaders.put((String)name, (List<String>)Optional.ofNullable(values).map(LinkedList::new).orElse(null));
        });
        return httpHeaders;
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object name) {
        if (!(name instanceof String)) {
            return false;
        }
        return this.headers.containsKey(name);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    @Override
    public List<String> get(Object name) {
        if (!(name instanceof String)) {
            return null;
        }
        return (List)this.headers.get(name);
    }

    public Optional<String> getFirst(String name) {
        return this.getOrDefault(name, Collections.emptyList()).stream().findFirst();
    }

    @Override
    public List<String> put(String name, List<String> values) {
        return this.headers.put(name, values);
    }

    public void add(String name, String value) {
        this.computeIfAbsent(name, k -> new LinkedList()).add(value);
    }

    public void set(String name, String value) {
        LinkedList<String> values = new LinkedList<String>();
        values.add(value);
        this.put(name, (List<String>)values);
    }

    @Override
    public List<String> remove(Object name) {
        if (!(name instanceof String)) {
            return null;
        }
        return (List)this.headers.remove(name);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> headers) {
        headers.forEach(this::put);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    public Collection<List<String>> values() {
        return this.headers.values();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.headers.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.headers.equals(o);
    }

    @Override
    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        return this.headers.toString();
    }

    protected static final class HeaderValues
    extends TreeMap<String, List<String>> {
        private static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = Comparator.comparing(name -> name.toLowerCase(Locale.ENGLISH));

        public HeaderValues() {
            super(CASE_INSENSITIVE_COMPARATOR);
        }
    }
}

