/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.commons.web;

import com.github.nosan.embedded.cassandra.commons.StreamUtils;
import com.github.nosan.embedded.cassandra.commons.StringUtils;
import com.github.nosan.embedded.cassandra.commons.function.IOSupplier;
import com.github.nosan.embedded.cassandra.commons.web.HttpClient;
import com.github.nosan.embedded.cassandra.commons.web.HttpHeaders;
import com.github.nosan.embedded.cassandra.commons.web.HttpRequest;
import com.github.nosan.embedded.cassandra.commons.web.HttpResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.time.Duration;
import java.util.Objects;

public class JdkHttpClient
implements HttpClient {
    private static final String COOKIE = "Cookie";
    private final Duration connectTimeout;
    private final Duration readTimeout;
    private final Proxy proxy;

    public JdkHttpClient() {
        this.readTimeout = null;
        this.connectTimeout = null;
        this.proxy = null;
    }

    public JdkHttpClient(Proxy proxy) {
        this.readTimeout = null;
        this.connectTimeout = null;
        this.proxy = proxy;
    }

    public JdkHttpClient(Duration connectTimeout, Duration readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.proxy = null;
    }

    public JdkHttpClient(Duration connectTimeout, Duration readTimeout, Proxy proxy) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.proxy = proxy;
    }

    @Override
    public final HttpResponse send(HttpRequest httpRequest, IOSupplier<? extends InputStream> bodySupplier) throws IOException {
        HttpURLConnection connection = this.open(httpRequest.getUri().toURL(), this.proxy);
        try {
            this.connect(connection, httpRequest, bodySupplier);
            return new JdkHttpResponse(connection);
        }
        catch (Exception ex) {
            try {
                connection.disconnect();
            }
            catch (Exception suppressed) {
                ex.addSuppressed(suppressed);
            }
            throw ex;
        }
    }

    protected HttpURLConnection open(URL url, Proxy proxy) throws IOException {
        URLConnection urlConnection;
        URLConnection uRLConnection = urlConnection = proxy != null ? url.openConnection(proxy) : url.openConnection();
        if (!(urlConnection instanceof HttpURLConnection)) {
            throw new IllegalStateException("HttpURLConnection required for [" + url + "] but got: " + urlConnection);
        }
        return (HttpURLConnection)urlConnection;
    }

    private void connect(HttpURLConnection connection, HttpRequest httpRequest, IOSupplier<? extends InputStream> bodySupplier) throws IOException {
        String method = httpRequest.getMethod();
        if (this.connectTimeout != null) {
            connection.setConnectTimeout(Math.toIntExact(this.connectTimeout.toMillis()));
        }
        if (this.readTimeout != null) {
            connection.setReadTimeout(Math.toIntExact(this.readTimeout.toMillis()));
        }
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects("GET".equals(method));
        connection.setDoOutput("POST".equals(method) || "PUT".equals(method) || "DELETE".equals(method));
        connection.setRequestMethod(method);
        HttpHeaders headers = httpRequest.getHeaders();
        headers.forEach((name, values) -> {
            if (COOKIE.equalsIgnoreCase((String)name)) {
                connection.setRequestProperty((String)name, values != null ? String.join((CharSequence)"; ", values) : "");
            } else if (values != null) {
                for (String value : values) {
                    connection.addRequestProperty((String)name, Objects.toString(value, ""));
                }
            } else {
                connection.addRequestProperty((String)name, "");
            }
        });
        if (bodySupplier != null && connection.getDoOutput()) {
            try (InputStream is = bodySupplier.get();
                 OutputStream os = connection.getOutputStream();){
                StreamUtils.copy(is, os);
            }
        }
        connection.connect();
    }

    private static final class JdkHttpResponse
    implements HttpResponse {
        private final HttpURLConnection connection;
        private final HttpHeaders headers;

        JdkHttpResponse(HttpURLConnection connection) {
            this.connection = connection;
            this.headers = HttpHeaders.readOnly(connection.getHeaderFields());
        }

        @Override
        public URI getUri() {
            try {
                return this.connection.getURL().toURI();
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException("URL '" + this.connection.getURL() + "' is not formatted strictly according to RFC2396 and cannot be converted to a URI", ex);
            }
        }

        @Override
        public int getStatus() {
            try {
                return this.connection.getResponseCode();
            }
            catch (FileNotFoundException ex) {
                return 404;
            }
            catch (IOException ex) {
                return 500;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            InputStream errorStream;
            if (this.getStatus() >= 400 && (errorStream = this.connection.getErrorStream()) != null) {
                return errorStream;
            }
            return this.connection.getInputStream();
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        @Override
        public void close() {
            this.connection.disconnect();
        }

        public String toString() {
            return "JdkHttpResponse{uri='" + this.getUri() + "', status='" + this.getStatusMessage() + "'}";
        }

        private String getStatusMessage() {
            try {
                String message = this.connection.getResponseMessage();
                if (StringUtils.hasText(message)) {
                    return this.getStatus() + " " + message;
                }
                return Integer.toString(this.getStatus());
            }
            catch (Exception ex) {
                return Integer.toString(this.getStatus());
            }
        }
    }
}

