/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.cql;

import com.github.nosan.embedded.cassandra.commons.ClassPathResource;
import com.github.nosan.embedded.cassandra.commons.Resource;
import com.github.nosan.embedded.cassandra.cql.ResourceCqlScript;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

@FunctionalInterface
public interface CqlScript {
    public static CqlScript ofClassPath(String name) {
        return CqlScript.ofClassPath(name, Charset.defaultCharset());
    }

    public static CqlScript ofClassPath(String name, Charset charset) {
        return CqlScript.ofResource(new ClassPathResource(name), charset);
    }

    public static CqlScript ofResource(Resource resource) {
        return CqlScript.ofResource(resource, Charset.defaultCharset());
    }

    public static CqlScript ofResource(Resource resource, Charset charset) {
        Objects.requireNonNull(charset, "Charset must not be null");
        Objects.requireNonNull(resource, "Resources must not be null");
        return new ResourceCqlScript(resource, charset);
    }

    default public void forEachStatement(Consumer<? super String> callback) {
        Objects.requireNonNull(callback, "Callback must not be null");
        this.getStatements().forEach(callback);
    }

    public List<String> getStatements();
}

