/*
 * Decompiled with CFR 0.152.
 */
package com.github.nosan.embedded.cassandra.cql;

import com.github.nosan.embedded.cassandra.commons.StringUtils;
import java.util.ArrayList;
import java.util.List;

final class Parser {
    private final char[] chars;

    Parser(String script) {
        this.chars = script.toCharArray();
    }

    List<String> getStatements() {
        ArrayList<String> statements = new ArrayList<String>(8);
        StringBuilder statement = new StringBuilder();
        Context context = Context.NONE;
        for (int i = 0; i < this.chars.length; ++i) {
            char c = this.chars[i];
            if (context == Context.NONE) {
                if (c == '/' && this.next(i, '/')) {
                    context = Context.COMMENT;
                    ++i;
                    continue;
                }
                if (c == '-' && this.next(i, '-')) {
                    context = Context.COMMENT;
                    ++i;
                    continue;
                }
                if (c == '/' && this.next(i, '*')) {
                    context = Context.MULTI_COMMENT;
                    ++i;
                    continue;
                }
                if (c == '\n' || c == '\r' || c == '\t' || c == ' ') {
                    while (this.next(i, '\n')) {
                        ++i;
                    }
                    while (this.next(i, '\r')) {
                        ++i;
                    }
                    while (this.next(i, '\t')) {
                        ++i;
                    }
                    while (this.next(i, ' ')) {
                        ++i;
                    }
                    if (statement.length() <= 0 || i == this.chars.length - 1) continue;
                    statement.append(' ');
                    continue;
                }
                if (c == '\"') {
                    statement.append(c);
                    context = Context.DOUBLE_QUOTE;
                    continue;
                }
                if (c == '\'') {
                    statement.append(c);
                    context = Context.QUOTE;
                    continue;
                }
                if (c == '$' && this.next(i, '$')) {
                    statement.append(c).append('$');
                    ++i;
                    context = Context.DOUBLE_DOLLAR;
                    continue;
                }
                if (c == ';') {
                    statements.add(statement.toString());
                    statement.delete(0, statement.length());
                    continue;
                }
                statement.append(c);
                continue;
            }
            if (context == Context.MULTI_COMMENT && c == '*' && this.next(i, '/')) {
                context = Context.NONE;
                ++i;
                continue;
            }
            if (context == Context.COMMENT && c == '\n') {
                context = Context.NONE;
                continue;
            }
            if (context == Context.QUOTE) {
                statement.append(c);
                if (c != '\'') continue;
                context = Context.NONE;
                continue;
            }
            if (context == Context.DOUBLE_QUOTE) {
                statement.append(c);
                if (c != '\"') continue;
                context = Context.NONE;
                continue;
            }
            if (context != Context.DOUBLE_DOLLAR) continue;
            statement.append(c);
            if (c != '$' || !this.next(i, '$')) continue;
            statement.append('$');
            context = Context.NONE;
            ++i;
        }
        if (StringUtils.hasText(statement)) {
            statements.add(statement.toString());
        }
        return statements;
    }

    private boolean next(int index, char expected) {
        return index + 1 < this.chars.length && this.chars[index + 1] == expected;
    }

    private static enum Context {
        NONE,
        COMMENT,
        MULTI_COMMENT,
        QUOTE,
        DOUBLE_QUOTE,
        DOUBLE_DOLLAR;

    }
}

