/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert;

import de.jfachwert.KFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.Text;
import de.jfachwert.bank.BIC;
import de.jfachwert.bank.BLZ;
import de.jfachwert.bank.Bankverbindung;
import de.jfachwert.bank.Geldbetrag;
import de.jfachwert.bank.IBAN;
import de.jfachwert.bank.Kontonummer;
import de.jfachwert.bank.Waehrung;
import de.jfachwert.bank.Zinssatz;
import de.jfachwert.math.Bruch;
import de.jfachwert.math.Nummer;
import de.jfachwert.math.PackedDecimal;
import de.jfachwert.math.Promille;
import de.jfachwert.math.Prozent;
import de.jfachwert.med.BSNR;
import de.jfachwert.med.IK;
import de.jfachwert.med.LANR;
import de.jfachwert.med.PZN;
import de.jfachwert.net.ChatAccount;
import de.jfachwert.net.Domainname;
import de.jfachwert.net.EMailAdresse;
import de.jfachwert.net.Telefonnummer;
import de.jfachwert.post.Adressat;
import de.jfachwert.post.Adresse;
import de.jfachwert.post.Anschrift;
import de.jfachwert.post.Name;
import de.jfachwert.post.Ort;
import de.jfachwert.post.PLZ;
import de.jfachwert.post.Postfach;
import de.jfachwert.pruefung.exception.LocalizedValidationException;
import de.jfachwert.pruefung.exception.ValidationException;
import de.jfachwert.rechnung.Artikelnummer;
import de.jfachwert.rechnung.Bestellnummer;
import de.jfachwert.rechnung.Kundennummer;
import de.jfachwert.rechnung.Rechnungsmonat;
import de.jfachwert.rechnung.Rechnungsnummer;
import de.jfachwert.rechnung.Referenznummer;
import de.jfachwert.steuer.Mehrwertsteuer;
import de.jfachwert.steuer.SteuerIdNr;
import de.jfachwert.steuer.Steuernummer;
import de.jfachwert.steuer.UStIdNr;
import de.jfachwert.util.SmallUUID;
import de.jfachwert.util.TinyUUID;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0002J/\u0010\n\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ'\u0010\n\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00052\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0012J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006J/\u0010\u0017\u001a\u00020\u00152\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00062\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0018J'\u0010\u0017\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u00052\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000e\u00a2\u0006\u0002\u0010\u0019R\"\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/jfachwert/FachwertFactory;", "", "()V", "registeredClasses", "", "", "Ljava/lang/Class;", "Lde/jfachwert/KFachwert;", "getClassFor", "name", "getFachwert", "clazz", "args", "", "Ljava/io/Serializable;", "(Ljava/lang/Class;[Ljava/io/Serializable;)Lde/jfachwert/KFachwert;", "(Ljava/lang/String;[Ljava/io/Serializable;)Lde/jfachwert/KFachwert;", "getRegisteredClasses", "", "getSimilarName", "register", "", "fachwertClass", "validate", "(Ljava/lang/Class;[Ljava/io/Serializable;)V", "(Ljava/lang/String;[Ljava/io/Serializable;)V", "Companion", "jfachwert"})
public final class FachwertFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Class<? extends KFachwert>> registeredClasses = new HashMap();
    private static final Logger LOG = Logger.getLogger(KFachwert.class.getName());
    @NotNull
    private static final FachwertFactory instance = new FachwertFactory();

    private FachwertFactory() {
    }

    public final synchronized void register(@NotNull Class<? extends KFachwert> fachwertClass) {
        Intrinsics.checkNotNullParameter(fachwertClass, "fachwertClass");
        try {
            Map<String, Class<? extends KFachwert>> map = this.registeredClasses;
            String string = fachwertClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue(string, "fachwertClass.simpleName");
            map.put(string, fachwertClass);
        }
        catch (NoClassDefFoundError ex) {
            LOG.log(Level.FINE, "Registration of " + fachwertClass + " is ignored:", ex);
        }
    }

    @NotNull
    public final Map<String, Class<? extends KFachwert>> getRegisteredClasses() {
        return this.registeredClasses;
    }

    @NotNull
    public final KFachwert getFachwert(@NotNull String name, Serializable ... args2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(args2, "args");
        Class<? extends KFachwert> fachwertClass = this.getClassFor(name);
        return this.getFachwert(fachwertClass, Arrays.copyOf(args2, args2.length));
    }

    @NotNull
    public final KFachwert getFachwert(@NotNull Class<? extends KFachwert> clazz, Serializable ... args2) {
        KFachwert kFachwert;
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(args2, "args");
        Class[] argTypes = FachwertFactory.Companion.toTypes(args2);
        try {
            Constructor<? extends KFachwert> ctor = clazz.getConstructor(Arrays.copyOf(argTypes, argTypes.length));
            KFachwert kFachwert2 = ctor.newInstance(Arrays.copyOf(args2, args2.length));
            Intrinsics.checkNotNullExpressionValue(kFachwert2, "{\n            val ctor =\u2026Instance(*args)\n        }");
            kFachwert = kFachwert2;
        }
        catch (ReflectiveOperationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ValidationException) {
                throw (ValidationException)cause;
            }
            if (cause instanceof IllegalArgumentException) {
                throw new LocalizedValidationException(((IllegalArgumentException)cause).getMessage(), cause);
            }
            throw new IllegalArgumentException("cannot create " + clazz + " with " + Arrays.toString(args2), ex);
        }
        return kFachwert;
    }

    public final void validate(@NotNull String name, Serializable ... args2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(args2, "args");
        Class<? extends KFachwert> fachwertClass = this.getClassFor(name);
        this.validate(fachwertClass, Arrays.copyOf(args2, args2.length));
    }

    public final void validate(@NotNull Class<? extends KFachwert> clazz, Serializable ... args2) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(args2, "args");
        Optional validator = FachwertFactory.Companion.getValidator(clazz);
        if (validator.isPresent()) {
            ((KSimpleValidator)validator.get()).validateObject(args2[0]);
        } else {
            FachwertFactory.Companion.callValidate(clazz, args2);
        }
    }

    private final Class<? extends KFachwert> getClassFor(String name) {
        Class<? extends KFachwert> fachwertClass = this.registeredClasses.get(name);
        if (fachwertClass == null) {
            fachwertClass = this.registeredClasses.get(this.getSimilarName(name));
        }
        Class<? extends KFachwert> clazz = fachwertClass;
        Intrinsics.checkNotNull(clazz);
        return clazz;
    }

    private final String getSimilarName(String name) {
        String similarName = "?";
        int minDistance = Integer.MAX_VALUE;
        for (String registeredName : this.registeredClasses.keySet()) {
            int dist = FachwertFactory.Companion.distance(name, registeredName);
            if (dist >= minDistance) continue;
            similarName = registeredName;
            minDistance = dist;
        }
        if (minDistance > 2) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Nearest name for '" + name + "' is '" + similarName + "' and too far away (" + minDistance + ") - will use Text class as fallback.");
            }
            String string = Text.class.getSimpleName();
            Intrinsics.checkNotNullExpressionValue(string, "Text::class.java.simpleName");
            similarName = string;
        }
        return similarName;
    }

    @NotNull
    public static final FachwertFactory getInstance() {
        return Companion.getInstance();
    }

    static {
        instance.register(Text.class);
        instance.register(Nummer.class);
        instance.register(Bankverbindung.class);
        instance.register(BIC.class);
        instance.register(BLZ.class);
        instance.register(IBAN.class);
        instance.register(Kontonummer.class);
        instance.register(ChatAccount.class);
        instance.register(Domainname.class);
        instance.register(EMailAdresse.class);
        instance.register(Telefonnummer.class);
        instance.register(Adressat.class);
        instance.register(Adresse.class);
        instance.register(Anschrift.class);
        instance.register(Ort.class);
        instance.register(PLZ.class);
        instance.register(Postfach.class);
        instance.register(Artikelnummer.class);
        instance.register(Bestellnummer.class);
        instance.register(Kundennummer.class);
        instance.register(Rechnungsmonat.class);
        instance.register(Rechnungsnummer.class);
        instance.register(Referenznummer.class);
        instance.register(SteuerIdNr.class);
        instance.register(Steuernummer.class);
        instance.register(UStIdNr.class);
        instance.register(PackedDecimal.class);
        instance.register(Bruch.class);
        instance.register(TinyUUID.class);
        instance.register(SmallUUID.class);
        instance.register(Geldbetrag.class);
        instance.register(Waehrung.class);
        instance.register(IK.class);
        instance.register(LANR.class);
        instance.register(BSNR.class);
        instance.register(Name.class);
        instance.register(Prozent.class);
        instance.register(Promille.class);
        instance.register(Mehrwertsteuer.class);
        instance.register(Zinssatz.class);
        instance.register(PZN.class);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J5\u0010\u000b\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0018\u0010\u001b\u001a\u00020\u00012\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eH\u0002J$\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001d2\u0010\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000eH\u0002J)\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000e0\u00112\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010 R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lde/jfachwert/FachwertFactory$Companion;", "", "()V", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "instance", "Lde/jfachwert/FachwertFactory;", "getInstance$annotations", "getInstance", "()Lde/jfachwert/FachwertFactory;", "callValidate", "", "clazz", "Ljava/lang/Class;", "Lde/jfachwert/KFachwert;", "args", "", "Ljava/io/Serializable;", "(Ljava/lang/Class;[Ljava/io/Serializable;)V", "obj", "(Ljava/lang/Object;[Ljava/io/Serializable;Ljava/lang/Class;)V", "distance", "", "a", "", "b", "getCompanionOf", "getValidator", "Ljava/util/Optional;", "Lde/jfachwert/KSimpleValidator;", "toTypes", "([Ljava/io/Serializable;)[Ljava/lang/Class;", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FachwertFactory getInstance() {
            return instance;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        private final Optional<KSimpleValidator<?>> getValidator(Class<? extends KFachwert> clazz) {
            try {
                Class<? extends KFachwert> clazz2 = clazz;
                Intrinsics.checkNotNull(clazz2);
                Field validatorField = clazz2.getDeclaredField("VALIDATOR");
                validatorField.setAccessible(true);
                Object obj = validatorField.get(null);
                if (obj instanceof KSimpleValidator) {
                    Optional<Object> optional = Optional.of(obj);
                    Intrinsics.checkNotNullExpressionValue(optional, "of(obj)");
                    return optional;
                }
            }
            catch (NoSuchFieldException ex) {
                LOG.log(Level.FINE, "Cannot find/access validator in " + clazz, ex);
            }
            catch (IllegalAccessException ex) {
                LOG.log(Level.FINE, "Cannot find/access validator in " + clazz, ex);
            }
            Optional<KSimpleValidator<?>> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, "empty()");
            return optional;
        }

        private final void callValidate(Class<? extends KFachwert> clazz, Serializable[] args2) {
            try {
                Object companion = this.getCompanionOf(clazz);
                Class<?> clazz2 = companion.getClass();
                Intrinsics.checkNotNull(clazz2, "null cannot be cast to non-null type java.lang.Class<out de.jfachwert.KFachwert>");
                this.callValidate(companion, args2, clazz2);
            }
            catch (ReflectiveOperationException ex) {
                LOG.log(Level.FINE, "Cannot use companion of " + clazz, ex);
                try {
                    this.callValidate(null, args2, clazz);
                }
                catch (ReflectiveOperationException rex) {
                    LOG.log(Level.FINE, "Cannot call validate method of " + clazz, rex);
                }
            }
        }

        private final void callValidate(Object obj, Serializable[] args2, Class<? extends KFachwert> clazz) throws ReflectiveOperationException {
            block2: {
                try {
                    Class<?>[] argTypes = this.toTypes(args2);
                    Method method = clazz.getMethod("validate", Arrays.copyOf(argTypes, argTypes.length));
                    method.invoke(obj, (Object[])Arrays.copyOf(args2, args2.length));
                }
                catch (InvocationTargetException ex) {
                    LOG.log(Level.FINE, "Call of validate method of " + clazz + "failed:", ex);
                    if (!(ex.getTargetException() instanceof ValidationException)) break block2;
                    Throwable throwable = ex.getTargetException();
                    Intrinsics.checkNotNull(throwable, "null cannot be cast to non-null type de.jfachwert.pruefung.exception.ValidationException");
                    throw (ValidationException)throwable;
                }
            }
        }

        private final Object getCompanionOf(Class<? extends KFachwert> clazz) throws ReflectiveOperationException {
            Field companionField = clazz.getField("Companion");
            Object object = companionField.get(null);
            Intrinsics.checkNotNullExpressionValue(object, "companionField[null]");
            return object;
        }

        private final Class<?>[] toTypes(Serializable[] args2) {
            Class[] argTypes = new Class[args2.length];
            int n = args2.length;
            for (int i = 0; i < n; ++i) {
                argTypes[i] = args2[i].getClass();
            }
            return argTypes;
        }

        private final int distance(String a, String b) {
            return new Text(a, null, 2, null).getDistanz(b);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

