/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert;

import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import de.jfachwert.pruefung.exception.NullValueException;
import de.jfachwert.pruefung.exception.ValidationException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface SimpleValidator<T extends Serializable>
extends Serializable {
    public static final Logger logger = Logger.getLogger(SimpleValidator.class.getName());

    public T validate(T var1);

    default public Object validateObject(Object value) {
        try {
            return this.validate((Serializable)value);
        }
        catch (ClassCastException ex) {
            logger.log(Level.FINE, "cannot cast " + value, ex);
            if (value == null) {
                throw new NullValueException();
            }
            return value;
        }
    }

    default public T verify(T value) {
        try {
            return this.validate(value);
        }
        catch (ValidationException ex) {
            throw new LocalizedIllegalArgumentException(ex);
        }
    }
}

