/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.Text;
import de.jfachwert.pruefung.NullValidator;
import java.io.Serializable;
import java.net.URL;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0016\u0018\u0000 \u001d2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0001\u001dB\u001f\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002J\u0018\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\rJ\u0006\u0010\u0019\u001a\u00020\u0013J\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0000J\u0006\u0010\u001c\u001a\u00020\u0000\u00a8\u0006\u001e"}, d2={"Lde/jfachwert/Text;", "Lde/jfachwert/AbstractFachwert;", "", "", "text", "validator", "Lde/jfachwert/KSimpleValidator;", "(Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "compareTo", "", "other", "convertTo", "toEncoding", "Ljava/nio/charset/Charset;", "fromEncoding", "detectCharset", "detectCharsets", "", "equalsIgnoreCase", "", "equalsIgnoreCaseAndUmlaute", "equalsIgnoreUmlaute", "getDistanz", "isCharset", "cs", "isPrintable", "replaceUmlaute", "toLowerCase", "toUpperCase", "Companion", "jfachwert"})
public class Text
extends AbstractFachwert<String, Text>
implements Comparable<Text> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger LOG = Logger.getLogger(Text.class.getName());
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new NullValidator();
    @NotNull
    private static final WeakHashMap<String, Text> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Text NULL = new Text("", null, 2, null);

    @JvmOverloads
    public Text(@NotNull String text, @NotNull KSimpleValidator<String> validator) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(validator, "validator");
        String string = VALIDATOR.verify((String)((Object)((Serializable)((Object)text)))).intern();
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).intern()");
        super((Serializable)((Object)string), validator);
    }

    public /* synthetic */ Text(String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(string, kSimpleValidator);
    }

    public final int getDistanz(@NotNull Text other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.getDistanz((String)other.getCode());
    }

    public final int getDistanz(@NotNull String other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Text.Companion.distance((String)this.getCode(), other);
    }

    @NotNull
    public final Text replaceUmlaute() {
        return Companion.of(Companion.replaceUmlaute((String)this.getCode()));
    }

    public final boolean isPrintable() {
        if (StringUtils.isAsciiPrintable(Companion.replaceUmlaute((String)this.getCode()))) {
            return true;
        }
        URL uRL = isPrintable.printable.1.INSTANCE.getClass().getResource("printable.txt");
        Intrinsics.checkNotNullExpressionValue(uRL, "{}.javaClass.getResource(\"printable.txt\")");
        Object object = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)object);
        String printable2 = new String(byArray, charset);
        object = (String)this.getCode();
        int n = ((String)object).length();
        for (int i = 0; i < n; ++i) {
            char c = ((String)object).charAt(i);
            if (Character.isLetterOrDigit(c) || CharsKt.isWhitespace(c) || StringsKt.contains$default((CharSequence)printable2, c, false, 2, null)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Charset detectCharset() {
        return Companion.detectCharset((String)this.getCode());
    }

    @NotNull
    public final Collection<Charset> detectCharsets() {
        return Companion.detectCharsets((String)this.getCode());
    }

    public final boolean isCharset(@NotNull Charset cs) {
        Intrinsics.checkNotNullParameter(cs, "cs");
        return Companion.isCharset((String)this.getCode(), cs);
    }

    @NotNull
    public final Text convertTo(@NotNull Charset toEncoding, @NotNull Charset fromEncoding) {
        Intrinsics.checkNotNullParameter(toEncoding, "toEncoding");
        Intrinsics.checkNotNullParameter(fromEncoding, "fromEncoding");
        return Companion.of(Companion.convert((String)this.getCode(), toEncoding, fromEncoding));
    }

    public static /* synthetic */ Text convertTo$default(Text text, Charset charset, Charset charset2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: convertTo");
        }
        if ((n & 2) != 0) {
            charset2 = text.detectCharset();
        }
        return text.convertTo(charset, charset2);
    }

    @NotNull
    public final Text toLowerCase() {
        String string = ((String)this.getCode()).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return Companion.of(string);
    }

    @NotNull
    public final Text toUpperCase() {
        String string = ((String)this.getCode()).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        return Companion.of(string);
    }

    public final boolean equalsIgnoreCase(@NotNull Text other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return StringsKt.equals((String)this.getCode(), (String)other.getCode(), true);
    }

    public final boolean equalsIgnoreUmlaute(@NotNull Text other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.areEqual(this.replaceUmlaute(), other.replaceUmlaute());
    }

    public final boolean equalsIgnoreCaseAndUmlaute(@NotNull Text other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.replaceUmlaute().equalsIgnoreCase(other.replaceUmlaute());
    }

    @Override
    public int compareTo(@NotNull Text other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return ((String)this.getCode()).compareTo((String)other.getCode());
    }

    @JvmOverloads
    public Text(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this(text, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Text of(@NotNull String text) {
        return Companion.of(text);
    }

    @JvmStatic
    @NotNull
    public static final Text of(@NotNull String text, @NotNull Charset encoding) {
        return Companion.of(text, encoding);
    }

    @JvmStatic
    @NotNull
    public static final String replaceUmlaute(@NotNull String text) {
        return Companion.replaceUmlaute(text);
    }

    @JvmStatic
    public static final boolean isPrintable(@NotNull String text) {
        return Companion.isPrintable(text);
    }

    @JvmStatic
    @NotNull
    public static final Charset detectCharset(@NotNull String value) {
        return Companion.detectCharset(value);
    }

    @JvmStatic
    @NotNull
    public static final Collection<Charset> detectCharsets(@NotNull String value) {
        return Companion.detectCharsets(value);
    }

    @JvmStatic
    public static final boolean isCharset(@NotNull String value, @NotNull Charset cs) {
        return Companion.isCharset(value, cs);
    }

    @JvmStatic
    @NotNull
    public static final String convert(@NotNull String value, @NotNull Charset toEncoding) {
        return Companion.convert(value, toEncoding);
    }

    @JvmStatic
    @NotNull
    public static final String convert(@NotNull String value, @NotNull Charset toEncoding, @NotNull Charset fromEncoding) {
        return Companion.convert(value, toEncoding, fromEncoding);
    }

    @JvmStatic
    @NotNull
    public static final String replaceSpecialChars(@NotNull String value, @NotNull Charset encoding) {
        return Companion.replaceSpecialChars(value, encoding);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0010H\u0007J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\nH\u0007J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\nH\u0007J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0010H\u0007J\u0018\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0010\u0010#\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010$\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0010H\u0007J\u0010\u0010%\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010&\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0007J\u0012\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u000e\u0010+\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lde/jfachwert/Text$Companion;", "", "()V", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "NULL", "Lde/jfachwert/Text;", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "convert", "value", "toEncoding", "Ljava/nio/charset/Charset;", "fromEncoding", "detectCharset", "detectCharsets", "", "distance", "", "s1", "s2", "isCharset", "", "cs", "isPrintable", "text", "of", "encoding", "replaceSpecialChar", "c", "", "replaceSpecialCharLatin15", "replaceSpecialChars", "replaceUmlaut", "replaceUmlaute", "rewind", "", "buffer", "Ljava/nio/CharBuffer;", "validate", "jfachwert"})
    @SourceDebugExtension(value={"SMAP\nText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Text.kt\nde/jfachwert/Text$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,522:1\n107#2:523\n79#2,22:524\n107#2:546\n79#2,22:547\n*S KotlinDebug\n*F\n+ 1 Text.kt\nde/jfachwert/Text$Companion\n*L\n315#1:523\n315#1:524,22\n483#1:546\n483#1:547,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Text of(@NotNull String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            Text text2 = WEAK_CACHE.computeIfAbsent(text, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue(text2, "WEAK_CACHE.computeIfAbse\u2026 { s: String -> Text(s) }");
            return text2;
        }

        @JvmStatic
        @NotNull
        public final Text of(@NotNull String text, @NotNull Charset encoding) {
            Intrinsics.checkNotNullParameter(text, "text");
            Intrinsics.checkNotNullParameter(encoding, "encoding");
            String encoded = this.replaceSpecialChars(text, encoding);
            return this.of(encoded);
        }

        @NotNull
        public final String validate(@NotNull String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            return (String)((Object)VALIDATOR.validate((Serializable)((Object)text)));
        }

        private final int distance(String s1, String s2) {
            String string = s1.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            String a = string;
            String string2 = s2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            String b = string2;
            int[] costs = new int[b.length() + 1];
            int n = costs.length;
            for (int j = 0; j < n; ++j) {
                costs[j] = j;
            }
            int i = 1;
            n = a.length();
            if (i <= n) {
                block1: do {
                    costs[0] = ++i;
                    int nw = i - 1;
                    int j = 1;
                    int n2 = b.length();
                    if (j > n2) continue;
                    while (true) {
                        int cj = Math.min(1 + Math.min(costs[j], costs[j - 1]), a.charAt(i - 1) == b.charAt(j - 1) ? nw : nw + 1);
                        nw = costs[j];
                        costs[j] = cj;
                        if (j == n2) continue block1;
                        ++j;
                    }
                } while (i != n);
            }
            return costs[b.length()];
        }

        @JvmStatic
        @NotNull
        public final String replaceUmlaute(@NotNull String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            char[] cArray = text.toCharArray();
            Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
            char[] zeichen = cArray;
            CharBuffer buffer = CharBuffer.allocate(zeichen.length * 2);
            for (char c : zeichen) {
                buffer.put(this.replaceUmlaut(c));
            }
            this.rewind(buffer);
            String string = buffer.toString();
            Intrinsics.checkNotNullExpressionValue(string, "buffer.toString()");
            String $this$trim$iv = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }

        private final String replaceUmlaut(char c) {
            char c2 = c;
            if (c2 == '\u00e4') {
                return "ae";
            }
            if (c2 == '\u00f6') {
                return "oe";
            }
            if (c2 == '\u00fc') {
                return "ue";
            }
            if (c2 == '\u00df') {
                return "ss";
            }
            if (c2 == '\u00c4') {
                return "Ae";
            }
            if (c2 == '\u00d6') {
                return "Oe";
            }
            if (c2 == '\u00dc') {
                return "Ue";
            }
            if ((c2 == '\u00e1' ? true : c2 == '\u00e0') ? true : c2 == '\u00e2') {
                return "a";
            }
            if (((c2 == '\u00e9' ? true : c2 == '\u00e8') ? true : c2 == '\u00ea') ? true : c2 == '\u00eb') {
                return "e";
            }
            if ((c2 == '\u00f3' ? true : c2 == '\u00f2') ? true : c2 == '\u00f4') {
                return "o";
            }
            if ((c2 == '\u00fa' ? true : c2 == '\u00f9') ? true : c2 == '\u00fb') {
                return "u";
            }
            if ((c2 == '\u00c1' ? true : c2 == '\u00c0') ? true : c2 == '\u00c2') {
                return "A";
            }
            if ((c2 == '\u00c9' ? true : c2 == '\u00c8') ? true : c2 == '\u00ca') {
                return "E";
            }
            if ((c2 == '\u00d3' ? true : c2 == '\u00d2') ? true : c2 == '\u00d4') {
                return "O";
            }
            if ((c2 == '\u00da' ? true : c2 == '\u00d9') ? true : c2 == '\u00db') {
                return "U";
            }
            if (c2 == '\u00a1') {
                return "!";
            }
            if (c2 == '\u00a3') {
                return "GBP";
            }
            if (c2 == '\u00a5') {
                return "JPY";
            }
            if (c2 == '\u00bf') {
                return "?";
            }
            Charset charset = StandardCharsets.ISO_8859_1;
            Intrinsics.checkNotNullExpressionValue(charset, "ISO_8859_1");
            return this.replaceSpecialChar(c, charset);
        }

        private final void rewind(CharBuffer buffer) {
            Intrinsics.checkNotNull(buffer, "null cannot be cast to non-null type java.nio.Buffer");
            Buffer b = buffer;
            b.rewind();
        }

        @JvmStatic
        public final boolean isPrintable(@NotNull String text) {
            Intrinsics.checkNotNullParameter(text, "text");
            return new Text(text, null, 2, null).isPrintable();
        }

        @JvmStatic
        @NotNull
        public final Charset detectCharset(@NotNull String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            Charset[] charsetArray = new Charset[2];
            Intrinsics.checkNotNullExpressionValue(StandardCharsets.ISO_8859_1, "ISO_8859_1");
            Intrinsics.checkNotNullExpressionValue(StandardCharsets.UTF_8, "UTF_8");
            List<Charset> charsets = CollectionsKt.mutableListOf(charsetArray);
            Collection<Charset> collection = Charset.availableCharsets().values();
            Intrinsics.checkNotNullExpressionValue(collection, "availableCharsets().values");
            charsets.addAll(collection);
            for (Charset cs : charsets) {
                if (!this.isCharset(value, cs)) continue;
                return cs;
            }
            Charset charset = StandardCharsets.ISO_8859_1;
            Intrinsics.checkNotNullExpressionValue(charset, "ISO_8859_1");
            return charset;
        }

        @JvmStatic
        @NotNull
        public final Collection<Charset> detectCharsets(@NotNull String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            List charsets = new ArrayList();
            for (Charset cs : Charset.availableCharsets().values()) {
                Intrinsics.checkNotNullExpressionValue(cs, "cs");
                if (!this.isCharset(value, cs)) continue;
                charsets.add(cs);
            }
            return charsets;
        }

        @JvmStatic
        public final boolean isCharset(@NotNull String value, @NotNull Charset cs) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(cs, "cs");
            Charset probe = StandardCharsets.UTF_8;
            try {
                byte[] byArray = value.getBytes(cs);
                Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
                Intrinsics.checkNotNullExpressionValue(probe, "probe");
                byte[] byArray2 = new String(byArray, probe).getBytes(probe);
                Intrinsics.checkNotNullExpressionValue(byArray2, "this as java.lang.String).getBytes(charset)");
                return Intrinsics.areEqual(value, new String(byArray2, cs));
            }
            catch (UnsupportedOperationException ex) {
                LOG.fine(cs + " wird nicht unterstuetzt: " + ex);
                return false;
            }
        }

        @JvmStatic
        @NotNull
        public final String convert(@NotNull String value, @NotNull Charset toEncoding) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(toEncoding, "toEncoding");
            Charset fromEncoding = this.detectCharset(value);
            return this.convert(value, toEncoding, fromEncoding);
        }

        @JvmStatic
        @NotNull
        public final String convert(@NotNull String value, @NotNull Charset toEncoding, @NotNull Charset fromEncoding) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(toEncoding, "toEncoding");
            Intrinsics.checkNotNullParameter(fromEncoding, "fromEncoding");
            String x = value;
            if (Intrinsics.areEqual(fromEncoding, StandardCharsets.UTF_8)) {
                x = this.replaceSpecialChars(value, toEncoding);
            }
            byte[] byArray = x.getBytes(fromEncoding);
            Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
            return new String(byArray, toEncoding);
        }

        @JvmStatic
        @NotNull
        public final String replaceSpecialChars(@NotNull String value, @NotNull Charset encoding) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(encoding, "encoding");
            char[] cArray = value.toCharArray();
            Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
            char[] zeichen = cArray;
            CharBuffer buffer = CharBuffer.allocate(zeichen.length * 2);
            for (char c : zeichen) {
                buffer.put(this.replaceSpecialChar(c, encoding));
            }
            this.rewind(buffer);
            String string = buffer.toString();
            Intrinsics.checkNotNullExpressionValue(string, "buffer.toString()");
            String $this$trim$iv = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }

        private final String replaceSpecialChar(char c, Charset encoding) {
            if (CharsKt.isWhitespace(c)) {
                return " ";
            }
            String string = encoding.name();
            if (Intrinsics.areEqual(string, StandardCharsets.US_ASCII.name())) {
                return this.replaceUmlaut(c);
            }
            if (Intrinsics.areEqual(string, "IBM850") ? true : Intrinsics.areEqual(string, StandardCharsets.ISO_8859_1.name())) {
                if (c == '\u20ac') {
                    return "EUR";
                }
                return this.replaceSpecialCharLatin15(c);
            }
            if (Intrinsics.areEqual(string, "ISO-8859-15")) {
                return this.replaceSpecialCharLatin15(c);
            }
            return String.valueOf(c);
        }

        private final String replaceSpecialCharLatin15(char c) {
            char c2 = c;
            if (c2 == '\u011b') {
                return "e";
            }
            if (c2 == '\u015b' ? true : c2 == '\u0161') {
                return "s";
            }
            if (c2 == '\u0107' ? true : c2 == '\u010d') {
                return "c";
            }
            if (c2 == '\u0141' ? true : c2 == '\u0142') {
                return "l";
            }
            if (c2 == '\u0144') {
                return "n";
            }
            if (c2 == '\u017e' ? true : c2 == '\u017a') {
                return "z";
            }
            if (c2 == '\u0e3f') {
                return "THB";
            }
            if (c2 == '\u20a9') {
                return "KRW";
            }
            if (c2 == '\u20aa') {
                return "ILS";
            }
            if (c2 == '\u20ab') {
                return "VND";
            }
            if (c2 == '\u20b9') {
                return "INR";
            }
            return String.valueOf(c);
        }

        private static final Text of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Text)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

