/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.jfachwert.KFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.bank.GeldbetragFactory;
import de.jfachwert.bank.Waehrung;
import de.jfachwert.bank.internal.GeldbetragFormatter;
import de.jfachwert.bank.internal.Zahlenwert;
import de.jfachwert.pruefung.NumberValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.LocalizedArithmeticException;
import de.jfachwert.pruefung.exception.LocalizedMonetaryException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryContext;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import javax.money.NumberValue;
import javax.money.format.MonetaryAmountFormat;
import javax.money.format.MonetaryParseException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToStringSerializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 W2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u00022\u00020\u0003:\u0002WXB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\fB\u001b\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010B!\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0016\u001a\u00020\u0000H\u0016J\u0012\u0010\u0017\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\rH\u0086\u0002J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0012\u0010\u001c\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0016J\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001f2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010 J\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001f2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010!J\u001d\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001f2\b\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0006\u0010$\u001a\u00020\u0007J\u0013\u0010%\u001a\u00020&2\b\u0010\u000b\u001a\u0004\u0018\u00010'H\u0096\u0002J\b\u0010(\u001a\u00020\u0013H\u0016J\b\u0010)\u001a\u00020\u0011H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002J\b\u0010/\u001a\u00020\u001bH\u0016J\u0010\u00100\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\u0001H\u0016J\u0010\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u0001H\u0016J\u0010\u00103\u001a\u00020&2\u0006\u00102\u001a\u00020\u0001H\u0016J\u0010\u00104\u001a\u00020&2\u0006\u00102\u001a\u00020\u0001H\u0016J\u0010\u00105\u001a\u00020&2\u0006\u00102\u001a\u00020\u0001H\u0016J\b\u00106\u001a\u00020&H\u0016J\b\u00107\u001a\u00020&H\u0016J\u0010\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020-H\u0002J\b\u0010:\u001a\u00020&H\u0016J\b\u0010;\u001a\u00020&H\u0016J\b\u0010<\u001a\u00020&H\u0016J\u0010\u0010=\u001a\u00020\u00012\u0006\u0010>\u001a\u00020\u0007H\u0016J\u0010\u0010=\u001a\u00020\u00012\u0006\u0010>\u001a\u00020\u0005H\u0016J\u0012\u0010=\u001a\u00020\u00012\b\u0010>\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010?\u001a\u00020\u0000H\u0016J\b\u0010@\u001a\u00020\u0000H\u0016J#\u0010A\u001a\u0002HB\"\u0004\b\u0000\u0010B2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u0002HB\u0018\u00010CH\u0016\u00a2\u0006\u0002\u0010DJ\u0010\u0010E\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u0010\u0010E\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0012\u0010E\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010F\u001a\u00020\u00002\u0006\u0010G\u001a\u00020\u001bH\u0016J\b\u0010H\u001a\u00020\u001bH\u0016J\b\u0010I\u001a\u00020\u0000H\u0016J\u0012\u0010J\u001a\u00020\u00002\b\u00102\u001a\u0004\u0018\u00010\u0001H\u0016J'\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00000\u001f2\u0012\u0010L\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u001f\"\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010MJ\u0006\u0010N\u001a\u00020\tJ\u0006\u0010O\u001a\u00020\tJ\b\u0010P\u001a\u00020\tH\u0016J\u0012\u0010Q\u001a\u00020\u00002\b\u0010R\u001a\u0004\u0018\u00010SH\u0016J\u0010\u0010T\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010T\u001a\u00020\u00002\u0006\u0010U\u001a\u00020\u0011J\u000e\u0010T\u001a\u00020\u00002\u0006\u0010V\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lde/jfachwert/bank/Geldbetrag;", "Ljavax/money/MonetaryAmount;", "", "Lde/jfachwert/KFachwert;", "betrag", "", "(J)V", "", "(D)V", "", "(Ljava/lang/String;)V", "other", "(Ljavax/money/MonetaryAmount;)V", "", "currency", "Ljava/util/Currency;", "(Ljava/lang/Number;Ljava/util/Currency;)V", "Ljavax/money/CurrencyUnit;", "context", "Ljavax/money/MonetaryContext;", "(Ljava/lang/Number;Ljavax/money/CurrencyUnit;Ljavax/money/MonetaryContext;)V", "Ljava/math/BigDecimal;", "abs", "add", "checkCurrency", "", "compareTo", "", "divide", "divisor", "divideAndRemainder", "", "(D)[Lde/jfachwert/bank/Geldbetrag;", "(J)[Lde/jfachwert/bank/Geldbetrag;", "(Ljava/lang/Number;)[Lde/jfachwert/bank/Geldbetrag;", "divideToIntegralValue", "doubleValue", "equals", "", "", "getContext", "getCurrency", "getFactory", "Lde/jfachwert/bank/GeldbetragFactory;", "getNumber", "Ljavax/money/NumberValue;", "hasSameCurrency", "hashCode", "isEqualTo", "isGreaterThan", "amount", "isGreaterThanOrEqualTo", "isLessThan", "isLessThanOrEqualTo", "isNegative", "isNegativeOrZero", "isNumberEqualTo", "value", "isPositive", "isPositiveOrZero", "isZero", "multiply", "multiplicand", "negate", "plus", "query", "R", "Ljavax/money/MonetaryQuery;", "(Ljavax/money/MonetaryQuery;)Ljava/lang/Object;", "remainder", "scaleByPowerOfTen", "power", "signum", "stripTrailingZeros", "subtract", "toGeldbetragArray", "numbers", "([Ljava/math/BigDecimal;)[Lde/jfachwert/bank/Geldbetrag;", "toLongString", "toShortString", "toString", "with", "operator", "Ljavax/money/MonetaryOperator;", "withCurrency", "unit", "waehrung", "Companion", "Validator", "jfachwert"})
@SourceDebugExtension(value={"SMAP\nGeldbetrag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Geldbetrag.kt\nde/jfachwert/bank/Geldbetrag\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,1306:1\n107#2:1307\n79#2,22:1308\n*S KotlinDebug\n*F\n+ 1 Geldbetrag.kt\nde/jfachwert/bank/Geldbetrag\n*L\n134#1:1307\n134#1:1308,22\n*E\n"})
public class Geldbetrag
implements MonetaryAmount,
Comparable<MonetaryAmount>,
KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigDecimal betrag;
    @NotNull
    private final MonetaryContext context;
    @NotNull
    private final CurrencyUnit currency;
    @NotNull
    private static final GeldbetragFactory FACTORY = new GeldbetragFactory();
    @NotNull
    private static final GeldbetragFormatter DEFAULT_FORMATTER = new GeldbetragFormatter();
    @NotNull
    private static final NumberValidator NUMBER_VALIDATOR = new NumberValidator(null, null, 3, null);
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new Validator();
    @JvmField
    @NotNull
    public static final Geldbetrag ZERO;
    @JvmField
    @NotNull
    public static final Geldbetrag MIN_VALUE;
    @JvmField
    @NotNull
    public static final Geldbetrag MAX_VALUE;
    @JvmField
    @NotNull
    public static final Geldbetrag NULL;

    @JvmOverloads
    public Geldbetrag(@NotNull Number betrag, @NotNull CurrencyUnit currency, @NotNull MonetaryContext context) {
        Intrinsics.checkNotNullParameter(betrag, "betrag");
        Intrinsics.checkNotNullParameter(currency, "currency");
        Intrinsics.checkNotNullParameter(context, "context");
        this.betrag = Geldbetrag.Companion.toBigDecimal(betrag, context);
        this.currency = currency;
        this.context = context;
    }

    public /* synthetic */ Geldbetrag(Number number, CurrencyUnit currencyUnit, MonetaryContext monetaryContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            monetaryContext = FACTORY.getMonetaryContextOf(number);
        }
        this(number, currencyUnit, monetaryContext);
    }

    public Geldbetrag(long betrag) {
        BigDecimal bigDecimal = BigDecimal.valueOf(betrag);
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "valueOf(betrag)");
        this(bigDecimal, null, 2, null);
    }

    public Geldbetrag(double betrag) {
        BigDecimal bigDecimal = BigDecimal.valueOf(betrag);
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "valueOf(betrag)");
        this(bigDecimal, null, 2, null);
    }

    public Geldbetrag(@NotNull String betrag) {
        Intrinsics.checkNotNullParameter(betrag, "betrag");
        this(Companion.valueOf(betrag));
    }

    public Geldbetrag(@NotNull MonetaryAmount other) {
        Intrinsics.checkNotNullParameter(other, "other");
        NumberValue numberValue = other.getNumber();
        Intrinsics.checkNotNullExpressionValue(numberValue, "other.number");
        this((Number)numberValue, Currency.getInstance(other.getCurrency().getCurrencyCode()));
    }

    @JvmOverloads
    public Geldbetrag(@NotNull Number betrag, @Nullable Currency currency) {
        Intrinsics.checkNotNullParameter(betrag, "betrag");
        Currency currency2 = currency;
        Intrinsics.checkNotNull(currency2);
        this(betrag, Waehrung.Companion.of(currency2), null, 4, null);
    }

    public /* synthetic */ Geldbetrag(Number number, Currency currency, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            currency = Waehrung.DEFAULT_CURRENCY;
        }
        this(number, currency);
    }

    @NotNull
    public final Geldbetrag withCurrency(@NotNull CurrencyUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        String string = unit.getCurrencyCode();
        Intrinsics.checkNotNullExpressionValue(string, "unit.currencyCode");
        return this.withCurrency(string);
    }

    @NotNull
    public final Geldbetrag withCurrency(@NotNull String waehrung) {
        String normalized;
        Intrinsics.checkNotNullParameter(waehrung, "waehrung");
        String string = waehrung.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (StringsKt.equals("DM", normalized = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), true)) {
            normalized = "DEM";
        }
        return this.withCurrency(Currency.getInstance(normalized));
    }

    @NotNull
    public final Geldbetrag withCurrency(@Nullable Currency currency) {
        return new Geldbetrag((Number)this.getNumber(), currency);
    }

    @Override
    @NotNull
    public MonetaryContext getContext() {
        return this.context;
    }

    @NotNull
    public GeldbetragFactory getFactory() {
        return new GeldbetragFactory().setCurrency(this.currency).setNumber(this.betrag).setContext(this.context);
    }

    @Override
    public boolean isGreaterThan(@NotNull MonetaryAmount amount) {
        Intrinsics.checkNotNullParameter(amount, "amount");
        return this.compareTo(amount) > 0;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(@NotNull MonetaryAmount amount) {
        Intrinsics.checkNotNullParameter(amount, "amount");
        return this.compareTo(amount) >= 0;
    }

    @Override
    public boolean isLessThan(@NotNull MonetaryAmount amount) {
        Intrinsics.checkNotNullParameter(amount, "amount");
        return this.compareTo(amount) < 0;
    }

    @Override
    public boolean isLessThanOrEqualTo(@NotNull MonetaryAmount amount) {
        Intrinsics.checkNotNullParameter(amount, "amount");
        return this.compareTo(amount) <= 0;
    }

    @Override
    public boolean isEqualTo(@NotNull MonetaryAmount other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.checkCurrency(other);
        NumberValue numberValue = other.getNumber();
        Intrinsics.checkNotNullExpressionValue(numberValue, "other.number");
        return this.isNumberEqualTo(numberValue);
    }

    private final boolean isNumberEqualTo(NumberValue value) {
        BigDecimal otherValue = Geldbetrag.Companion.toBigDecimal(value, this.context);
        return this.betrag.compareTo(otherValue) == 0;
    }

    @Override
    public boolean isNegative() {
        return this.betrag.compareTo(BigDecimal.ZERO) < 0;
    }

    @Override
    public boolean isNegativeOrZero() {
        return this.betrag.compareTo(BigDecimal.ZERO) <= 0;
    }

    @Override
    public boolean isPositive() {
        return this.betrag.compareTo(BigDecimal.ZERO) > 0;
    }

    @Override
    public boolean isPositiveOrZero() {
        return this.betrag.compareTo(BigDecimal.ZERO) >= 0;
    }

    @Override
    public boolean isZero() {
        return this.betrag.compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    public int signum() {
        return Geldbetrag.Companion.toBigDecimal(this.getNumber()).signum();
    }

    @Override
    @NotNull
    public Geldbetrag add(@Nullable MonetaryAmount other) {
        if (this.betrag.compareTo(BigDecimal.ZERO) == 0) {
            MonetaryAmount monetaryAmount = other;
            Intrinsics.checkNotNull(monetaryAmount);
            return Companion.valueOf(monetaryAmount);
        }
        MonetaryAmount monetaryAmount = other;
        Intrinsics.checkNotNull(monetaryAmount);
        NumberValue numberValue = monetaryAmount.getNumber();
        Intrinsics.checkNotNullExpressionValue(numberValue, "other!!.number");
        BigDecimal n = Geldbetrag.Companion.toBigDecimal(numberValue, this.context);
        if (n.compareTo(BigDecimal.ZERO) == 0) {
            return this;
        }
        this.checkCurrency(other);
        BigDecimal bigDecimal = this.betrag.add(n);
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "betrag.add(n)");
        return Companion.valueOf((Number)bigDecimal, this.currency);
    }

    @Override
    @NotNull
    public Geldbetrag subtract(@Nullable MonetaryAmount amount) {
        MonetaryAmount monetaryAmount = amount;
        Intrinsics.checkNotNull(monetaryAmount);
        return this.add(monetaryAmount.negate());
    }

    @Override
    @NotNull
    public MonetaryAmount multiply(long multiplicand) {
        return this.multiply(BigDecimal.valueOf(multiplicand));
    }

    @Override
    @NotNull
    public MonetaryAmount multiply(double multiplicand) {
        return this.multiply(Geldbetrag.Companion.toBigDecimal(multiplicand));
    }

    @Override
    @NotNull
    public MonetaryAmount multiply(@Nullable Number multiplicand) {
        Number number = multiplicand;
        Intrinsics.checkNotNull(number);
        BigDecimal d = Geldbetrag.Companion.toBigDecimal(number, this.context);
        if (BigDecimal.ONE.compareTo(d) == 0) {
            return this;
        }
        BigDecimal multiplied = this.betrag.multiply(d);
        Intrinsics.checkNotNullExpressionValue(multiplied, "multiplied");
        return Companion.valueOf((Number)multiplied, this.currency);
    }

    @Override
    @NotNull
    public Geldbetrag divide(long divisor) {
        return this.divide(BigDecimal.valueOf(divisor));
    }

    @Override
    @NotNull
    public MonetaryAmount divide(double divisor) {
        MonetaryAmount monetaryAmount;
        if (Geldbetrag.Companion.isInfinite(divisor)) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "ZERO");
            monetaryAmount = Companion.valueOf((Number)bigDecimal, this.currency);
        } else {
            monetaryAmount = this.divide(BigDecimal.valueOf(divisor));
        }
        return monetaryAmount;
    }

    @Override
    @NotNull
    public Geldbetrag divide(@Nullable Number divisor) {
        Geldbetrag geldbetrag;
        Number number = divisor;
        Intrinsics.checkNotNull(number);
        BigDecimal d = Geldbetrag.Companion.toBigDecimal(number, this.context);
        if (BigDecimal.ONE.compareTo(d) == 0) {
            geldbetrag = this;
        } else {
            BigDecimal bigDecimal = this.betrag.setScale(4, RoundingMode.HALF_UP).divide(d, RoundingMode.HALF_UP);
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "betrag.setScale(4, Round\u2026(d, RoundingMode.HALF_UP)");
            geldbetrag = Companion.valueOf((Number)bigDecimal, this.currency);
        }
        return geldbetrag;
    }

    @Override
    @NotNull
    public Geldbetrag remainder(long divisor) {
        return this.remainder(BigDecimal.valueOf(divisor));
    }

    @Override
    @NotNull
    public Geldbetrag remainder(double divisor) {
        return Geldbetrag.Companion.isInfinite(divisor) ? Companion.valueOf((Number)0, this.currency) : this.remainder(Geldbetrag.Companion.toBigDecimal(divisor));
    }

    @Override
    @NotNull
    public Geldbetrag remainder(@Nullable Number divisor) {
        Number number = divisor;
        Intrinsics.checkNotNull(number);
        BigDecimal bigDecimal = this.betrag.remainder(Geldbetrag.Companion.toBigDecimal(number, this.context));
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "betrag.remainder(toBigDecimal(divisor!!, context))");
        return Companion.valueOf((Number)bigDecimal, this.currency);
    }

    @NotNull
    public Geldbetrag[] divideAndRemainder(long divisor) {
        return this.divideAndRemainder(BigDecimal.valueOf(divisor));
    }

    @NotNull
    public Geldbetrag[] divideAndRemainder(double divisor) {
        Geldbetrag[] geldbetragArray;
        if (Geldbetrag.Companion.isInfinite(divisor)) {
            BigDecimal[] bigDecimalArray = new BigDecimal[2];
            Intrinsics.checkNotNullExpressionValue(BigDecimal.ZERO, "ZERO");
            Intrinsics.checkNotNullExpressionValue(BigDecimal.ZERO, "ZERO");
            geldbetragArray = this.toGeldbetragArray(bigDecimalArray);
        } else {
            geldbetragArray = this.divideAndRemainder(BigDecimal.valueOf(divisor));
        }
        return geldbetragArray;
    }

    @NotNull
    public Geldbetrag[] divideAndRemainder(@Nullable Number divisor) {
        Number number = divisor;
        Intrinsics.checkNotNull(number);
        BigDecimal[] numbers = this.betrag.divideAndRemainder(Geldbetrag.Companion.toBigDecimal(number, this.context));
        Intrinsics.checkNotNullExpressionValue(numbers, "numbers");
        BigDecimal[] bigDecimalArray = numbers;
        return this.toGeldbetragArray(Arrays.copyOf(bigDecimalArray, bigDecimalArray.length));
    }

    private final Geldbetrag[] toGeldbetragArray(BigDecimal ... numbers) {
        int n = 0;
        int n2 = numbers.length;
        Geldbetrag[] geldbetragArray = new Geldbetrag[n2];
        while (n < n2) {
            int n3 = n++;
            geldbetragArray[n3] = Companion.valueOf((Number)numbers[n3], this.currency);
        }
        Geldbetrag[] betraege = geldbetragArray;
        return betraege;
    }

    @Override
    @NotNull
    public Geldbetrag divideToIntegralValue(long divisor) {
        BigDecimal bigDecimal = BigDecimal.valueOf(divisor);
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "valueOf(divisor)");
        return this.divideToIntegralValue(bigDecimal);
    }

    @Override
    @NotNull
    public Geldbetrag divideToIntegralValue(double divisor) {
        BigDecimal bigDecimal = BigDecimal.valueOf(divisor);
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "valueOf(divisor)");
        return this.divideToIntegralValue(bigDecimal);
    }

    @Override
    @NotNull
    public Geldbetrag divideToIntegralValue(@NotNull Number divisor) {
        Intrinsics.checkNotNullParameter(divisor, "divisor");
        BigDecimal bigDecimal = this.betrag.divideToIntegralValue(Geldbetrag.Companion.toBigDecimal(divisor, this.context));
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "betrag.divideToIntegralV\u2026ecimal(divisor, context))");
        return Companion.valueOf((Number)bigDecimal, this.currency);
    }

    @Override
    @NotNull
    public Geldbetrag scaleByPowerOfTen(int power) {
        BigDecimal scaled = this.betrag.scaleByPowerOfTen(power);
        Intrinsics.checkNotNullExpressionValue(scaled, "scaled");
        return Companion.roundedValueOf(scaled, this.getCurrency(), this.context);
    }

    @Override
    @NotNull
    public Geldbetrag abs() {
        return this.betrag.compareTo(BigDecimal.ZERO) < 0 ? this.negate() : this;
    }

    @Override
    @NotNull
    public Geldbetrag negate() {
        BigDecimal bigDecimal = this.betrag.negate();
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "betrag.negate()");
        return Companion.valueOf((Number)bigDecimal, this.currency);
    }

    @Override
    @NotNull
    public Geldbetrag plus() {
        return this.betrag.compareTo(BigDecimal.ZERO) < 0 ? this.negate() : this;
    }

    @Override
    @NotNull
    public Geldbetrag stripTrailingZeros() {
        Geldbetrag geldbetrag;
        if (this.isZero()) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "ZERO");
            geldbetrag = Companion.valueOf((Number)bigDecimal, this.getCurrency());
        } else {
            BigDecimal bigDecimal = this.betrag.stripTrailingZeros();
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "betrag.stripTrailingZeros()");
            geldbetrag = Companion.valueOf((Number)bigDecimal, this.getCurrency(), this.context);
        }
        return geldbetrag;
    }

    @Override
    public int compareTo(@NotNull MonetaryAmount other) {
        Intrinsics.checkNotNullParameter(other, "other");
        String string = this.getCurrency().getCurrencyCode();
        String string2 = other.getCurrency().getCurrencyCode();
        Intrinsics.checkNotNullExpressionValue(string2, "other.currency.currencyCode");
        int compare = string.compareTo(string2);
        if (compare == 0) {
            NumberValue numberValue = other.getNumber();
            Intrinsics.checkNotNullExpressionValue(numberValue, "other.number");
            BigDecimal n = Geldbetrag.Companion.toBigDecimal(numberValue);
            return this.betrag.compareTo(n);
        }
        return compare;
    }

    @Override
    public final int compareTo(@NotNull Number other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.compareTo(Companion.valueOf(other, this.currency));
    }

    @Override
    @NotNull
    public CurrencyUnit getCurrency() {
        return this.currency;
    }

    @Override
    @NotNull
    public NumberValue getNumber() {
        return new Zahlenwert(this.betrag);
    }

    public final double doubleValue() {
        return this.betrag.doubleValue();
    }

    public int hashCode() {
        return this.betrag.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Geldbetrag)) {
            return false;
        }
        return !this.hasSameCurrency((MonetaryAmount)other) ? false : Intrinsics.areEqual(this.toString(), ((Geldbetrag)other).toString());
    }

    private final boolean hasSameCurrency(MonetaryAmount other) {
        return Intrinsics.areEqual(this.getCurrency(), other.getCurrency());
    }

    private final void checkCurrency(MonetaryAmount other) {
        if (!this.hasSameCurrency(other)) {
            Object[] objectArray = new Object[]{this, other};
            throw new LocalizedMonetaryException("different currencies", objectArray);
        }
    }

    @Override
    @NotNull
    public Geldbetrag with(@Nullable MonetaryOperator operator) {
        Geldbetrag geldbetrag;
        Objects.requireNonNull(operator);
        try {
            MonetaryOperator monetaryOperator = operator;
            Intrinsics.checkNotNull(monetaryOperator);
            MonetaryAmount monetaryAmount = monetaryOperator.apply(this);
            Intrinsics.checkNotNull(monetaryAmount, "null cannot be cast to non-null type de.jfachwert.bank.Geldbetrag");
            geldbetrag = (Geldbetrag)monetaryAmount;
        }
        catch (MonetaryException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            Object[] objectArray = new Object[]{operator, ex};
            throw new LocalizedMonetaryException("operator failed", objectArray);
        }
        return geldbetrag;
    }

    @Override
    public <R> R query(@Nullable MonetaryQuery<R> query) {
        R r;
        Objects.requireNonNull(query);
        try {
            MonetaryQuery<R> monetaryQuery = query;
            Intrinsics.checkNotNull(monetaryQuery);
            r = monetaryQuery.queryFrom(this);
        }
        catch (MonetaryException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            Object[] objectArray = new Object[]{query, ex};
            throw new LocalizedMonetaryException("query failed", objectArray);
        }
        return r;
    }

    @NotNull
    public final String toShortString() {
        return Waehrung.Companion.getSymbol(this.currency) + this.betrag.setScale(0, RoundingMode.HALF_UP);
    }

    @NotNull
    public String toString() {
        String string = DEFAULT_FORMATTER.format(this);
        Intrinsics.checkNotNullExpressionValue(string, "DEFAULT_FORMATTER.format(this)");
        return string;
    }

    @NotNull
    public final String toLongString() {
        NumberFormat formatter = DecimalFormat.getInstance();
        formatter.setMinimumFractionDigits(this.context.getMaxScale());
        formatter.setMinimumFractionDigits(this.context.getMaxScale());
        return formatter.format(this.betrag) + ' ' + this.currency;
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap(this);
    }

    @JvmOverloads
    public Geldbetrag(@NotNull Number betrag, @NotNull CurrencyUnit currency) {
        Intrinsics.checkNotNullParameter(betrag, "betrag");
        Intrinsics.checkNotNullParameter(currency, "currency");
        this(betrag, currency, null, 4, null);
    }

    @JvmOverloads
    public Geldbetrag(@NotNull Number betrag) {
        Intrinsics.checkNotNullParameter(betrag, "betrag");
        this(betrag, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag fromCent(long cents) {
        return Companion.fromCent(cents);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geldbetrag ofMinor(@NotNull CurrencyUnit currency, long amountMinor, int fractionDigits) {
        return Companion.ofMinor(currency, amountMinor, fractionDigits);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull String other) {
        return Companion.of(other);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull String other) {
        return Companion.valueOf(other);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(long value) {
        return Companion.of(value);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(long value) {
        return Companion.valueOf(value);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(double value) {
        return Companion.of(value);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(double value) {
        return Companion.valueOf(value);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull Number value, @NotNull String currency) {
        return Companion.of(value, currency);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull Number value, @NotNull String currency) {
        return Companion.valueOf(value, currency);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull Number value, @NotNull Currency currency) {
        return Companion.of(value, currency);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull Number value, @NotNull Currency currency) {
        return Companion.valueOf(value, currency);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull Number value, @NotNull CurrencyUnit currency) {
        return Companion.of(value, currency);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull Number value, @NotNull CurrencyUnit currency) {
        return Companion.valueOf(value, currency);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull Number value, @NotNull String currency, @NotNull MonetaryContext monetaryContext) {
        return Companion.of(value, currency, monetaryContext);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull Number value, @NotNull String currency, @NotNull MonetaryContext monetaryContext) {
        return Companion.valueOf(value, currency, monetaryContext);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull Number value, @NotNull CurrencyUnit currency, @NotNull MonetaryContext monetaryContext) {
        return Companion.of(value, currency, monetaryContext);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull Number value, @NotNull CurrencyUnit currency, @NotNull MonetaryContext monetaryContext) {
        return Companion.valueOf(value, currency, monetaryContext);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag roundedValueOf(@NotNull Number value, @NotNull CurrencyUnit currency, @NotNull MonetaryContext monetaryContext) {
        return Companion.roundedValueOf(value, currency, monetaryContext);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geldbetrag parse(@Nullable CharSequence text, @NotNull MonetaryAmountFormat formatter) {
        return Companion.parse(text, formatter);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag from(@NotNull MonetaryAmount other) {
        return Companion.from(other);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag of(@NotNull MonetaryAmount other) {
        return Companion.of(other);
    }

    @JvmStatic
    @NotNull
    public static final Geldbetrag valueOf(@NotNull MonetaryAmount other) {
        return Companion.valueOf(other);
    }

    @JvmStatic
    @NotNull
    public static final String validate(@NotNull String zahl) {
        return Companion.validate(zahl);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geldbetrag ofMinor(@NotNull CurrencyUnit currency, long amountMinor) {
        return Companion.ofMinor(currency, amountMinor);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geldbetrag parse(@Nullable CharSequence text) {
        return Companion.parse(text);
    }

    static {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "ZERO");
        ZERO = new Geldbetrag(bigDecimal, null, 2, null);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(Long.MIN_VALUE);
        Intrinsics.checkNotNullExpressionValue(bigDecimal2, "valueOf(Long.MIN_VALUE)");
        MIN_VALUE = new Geldbetrag(bigDecimal2, null, 2, null);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue(bigDecimal3, "valueOf(Long.MAX_VALUE)");
        MAX_VALUE = new Geldbetrag(bigDecimal3, null, 2, null);
        NULL = ZERO;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0007J\u0018\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0018\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020 H\u0007J \u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0018\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fH\u0007J \u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000fH\u0007J\"\u0010#\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00162\b\b\u0002\u0010%\u001a\u00020&H\u0007J\u001c\u0010'\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010)2\b\b\u0002\u0010*\u001a\u00020+H\u0007J \u0010,\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020/H\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020/2\u0006\u00100\u001a\u00020\"H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u00101\u001a\u00020.2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u00020\u000fH\u0007J\u0010\u00104\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u00104\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001aH\u0007J\u0010\u00104\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0016H\u0007J\u0018\u00104\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0018\u00104\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020 H\u0007J \u00104\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0018\u00104\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fH\u0007J \u00104\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u00104\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lde/jfachwert/bank/Geldbetrag$Companion;", "", "()V", "DEFAULT_FORMATTER", "Lde/jfachwert/bank/internal/GeldbetragFormatter;", "FACTORY", "Lde/jfachwert/bank/GeldbetragFactory;", "MAX_VALUE", "Lde/jfachwert/bank/Geldbetrag;", "MIN_VALUE", "NULL", "NUMBER_VALIDATOR", "Lde/jfachwert/pruefung/NumberValidator;", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "ZERO", "from", "other", "Ljavax/money/MonetaryAmount;", "fromCent", "cents", "", "isInfinite", "", "divisor", "", "of", "value", "", "currency", "Ljava/util/Currency;", "Ljavax/money/CurrencyUnit;", "monetaryContext", "Ljavax/money/MonetaryContext;", "ofMinor", "amountMinor", "fractionDigits", "", "parse", "text", "", "formatter", "Ljavax/money/format/MonetaryAmountFormat;", "roundedValueOf", "toBigDecimal", "Ljava/math/BigDecimal;", "Ljavax/money/NumberValue;", "mc", "toBigDecimalRounded", "validate", "zahl", "valueOf", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag fromCent(long cents) {
            return de.jfachwert.bank.Geldbetrag$Companion.ofMinor$default(this, Waehrung.Companion.of("EUR"), cents, 0, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geldbetrag ofMinor(@NotNull CurrencyUnit currency, long amountMinor, int fractionDigits) {
            Intrinsics.checkNotNullParameter(currency, "currency");
            BigDecimal bigDecimal = BigDecimal.valueOf(amountMinor, fractionDigits);
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "valueOf(amountMinor, fractionDigits)");
            return this.of((Number)bigDecimal, currency);
        }

        public static /* synthetic */ Geldbetrag ofMinor$default(Companion companion, CurrencyUnit currencyUnit, long l, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = currencyUnit.getDefaultFractionDigits();
            }
            return companion.ofMinor(currencyUnit, l, n);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull String other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return this.valueOf(other);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull String other) {
            Geldbetrag geldbetrag;
            Intrinsics.checkNotNullParameter(other, "other");
            try {
                MonetaryAmount monetaryAmount = DEFAULT_FORMATTER.parse((CharSequence)other);
                Intrinsics.checkNotNull(monetaryAmount, "null cannot be cast to non-null type de.jfachwert.bank.Geldbetrag");
                geldbetrag = (Geldbetrag)monetaryAmount;
            }
            catch (MonetaryParseException ex) {
                throw new IllegalArgumentException(other, ex);
            }
            return geldbetrag;
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(long value) {
            return this.valueOf(new Geldbetrag(value));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(long value) {
            return this.valueOf(new Geldbetrag(value));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(double value) {
            return this.valueOf(new Geldbetrag(value));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(double value) {
            return this.valueOf(new Geldbetrag(value));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull Number value, @NotNull String currency) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(currency, "currency");
            return this.valueOf(value, currency);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull Number value, @NotNull String currency) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(currency, "currency");
            return this.valueOf(value, Waehrung.Companion.toCurrency(currency));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull Number value, @NotNull Currency currency) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(currency, "currency");
            return this.valueOf(value, currency);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull Number value, @NotNull Currency currency) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(currency, "currency");
            return this.valueOf(new Geldbetrag(value, currency));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull Number value, @NotNull CurrencyUnit currency) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(currency, "currency");
            return this.valueOf(value, currency);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull Number value, @NotNull CurrencyUnit currency) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(currency, "currency");
            return this.valueOf(new Geldbetrag(value, currency, null, 4, null));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull Number value, @NotNull String currency, @NotNull MonetaryContext monetaryContext) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(currency, "currency");
            Intrinsics.checkNotNullParameter(monetaryContext, "monetaryContext");
            return this.valueOf(value, currency, monetaryContext);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull Number value, @NotNull String currency, @NotNull MonetaryContext monetaryContext) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(currency, "currency");
            Intrinsics.checkNotNullParameter(monetaryContext, "monetaryContext");
            return this.valueOf(value, Waehrung.Companion.of(currency), monetaryContext);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull Number value, @NotNull CurrencyUnit currency, @NotNull MonetaryContext monetaryContext) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(currency, "currency");
            Intrinsics.checkNotNullParameter(monetaryContext, "monetaryContext");
            return this.valueOf(value, currency, monetaryContext);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull Number value, @NotNull CurrencyUnit currency, @NotNull MonetaryContext monetaryContext) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(currency, "currency");
            Intrinsics.checkNotNullParameter(monetaryContext, "monetaryContext");
            return this.valueOf(new Geldbetrag(value, currency, monetaryContext));
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag roundedValueOf(@NotNull Number value, @NotNull CurrencyUnit currency, @NotNull MonetaryContext monetaryContext) {
            Intrinsics.checkNotNullParameter(value, "value");
            Intrinsics.checkNotNullParameter(currency, "currency");
            Intrinsics.checkNotNullParameter(monetaryContext, "monetaryContext");
            BigDecimal roundedValue = this.toBigDecimalRounded(value, monetaryContext);
            return this.valueOf(new Geldbetrag(roundedValue, currency, monetaryContext));
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geldbetrag parse(@Nullable CharSequence text, @NotNull MonetaryAmountFormat formatter) {
            Intrinsics.checkNotNullParameter(formatter, "formatter");
            MonetaryAmount monetaryAmount = formatter.parse(text);
            Intrinsics.checkNotNullExpressionValue(monetaryAmount, "formatter.parse(text)");
            return this.from(monetaryAmount);
        }

        public static /* synthetic */ Geldbetrag parse$default(Companion companion, CharSequence charSequence, MonetaryAmountFormat monetaryAmountFormat, int n, Object object) {
            if ((n & 2) != 0) {
                monetaryAmountFormat = DEFAULT_FORMATTER;
            }
            return companion.parse(charSequence, monetaryAmountFormat);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag from(@NotNull MonetaryAmount other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return this.of(other);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag of(@NotNull MonetaryAmount other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return this.valueOf(other);
        }

        @JvmStatic
        @NotNull
        public final Geldbetrag valueOf(@NotNull MonetaryAmount other) {
            Geldbetrag geldbetrag;
            Intrinsics.checkNotNullParameter(other, "other");
            if (other instanceof Geldbetrag) {
                return (Geldbetrag)other;
            }
            BigDecimal value = other.getNumber().numberValue(BigDecimal.class);
            if (Intrinsics.areEqual(value, BigDecimal.ZERO)) {
                geldbetrag = ZERO;
            } else {
                Intrinsics.checkNotNullExpressionValue(value, "value");
                Geldbetrag geldbetrag2 = new Geldbetrag(value, null, 2, null);
                CurrencyUnit currencyUnit = other.getCurrency();
                Intrinsics.checkNotNullExpressionValue(currencyUnit, "other.currency");
                geldbetrag = geldbetrag2.withCurrency(currencyUnit);
            }
            return geldbetrag;
        }

        @JvmStatic
        @NotNull
        public final String validate(@NotNull String zahl) {
            Intrinsics.checkNotNullParameter(zahl, "zahl");
            return (String)((Object)VALIDATOR.validate((Serializable)((Object)zahl)));
        }

        private final BigDecimal toBigDecimal(NumberValue value) {
            BigDecimal bigDecimal = value.numberValue(BigDecimal.class);
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "value.numberValue(BigDecimal::class.java)");
            return bigDecimal;
        }

        private final BigDecimal toBigDecimal(NumberValue value, MonetaryContext mc) {
            Number n = this.toBigDecimal(value);
            return this.toBigDecimal(n, mc);
        }

        private final BigDecimal toBigDecimal(double value) {
            NUMBER_VALIDATOR.verifyNumber(value);
            BigDecimal bigDecimal = BigDecimal.valueOf(value);
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "valueOf(value)");
            return bigDecimal;
        }

        private final boolean isInfinite(double divisor) {
            if (divisor == Double.POSITIVE_INFINITY || divisor == Double.NEGATIVE_INFINITY) {
                return true;
            }
            if (Double.isNaN(divisor)) {
                throw new ArithmeticException("invalid number: NaN");
            }
            return false;
        }

        private final BigDecimal toBigDecimal(Number value, MonetaryContext monetaryContext) {
            BigDecimal rounded;
            BigDecimal n = this.toBigDecimal(value);
            if (n.compareTo(rounded = this.toBigDecimalRounded(value, monetaryContext)) != 0) {
                throw new LocalizedArithmeticException(value, "lost_precision");
            }
            return n;
        }

        private final BigDecimal toBigDecimalRounded(Number value, MonetaryContext monetaryContext) {
            BigDecimal bigDecimal;
            int scale;
            BigDecimal n = this.toBigDecimal(value);
            RoundingMode roundingMode = monetaryContext.get(RoundingMode.class);
            if (roundingMode == null) {
                roundingMode = RoundingMode.HALF_UP;
            }
            if ((scale = monetaryContext.getMaxScale()) <= 0) {
                bigDecimal = n;
            } else {
                BigDecimal scaled;
                BigDecimal bigDecimal2 = scaled = n.setScale(scale, roundingMode);
                bigDecimal = bigDecimal2;
                Intrinsics.checkNotNullExpressionValue(bigDecimal2, "{\n                val sc\u2026     scaled\n            }");
            }
            return bigDecimal;
        }

        private final BigDecimal toBigDecimal(Number value) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Zahlenwert) {
                return ((Zahlenwert)value).numberValue(BigDecimal.class);
            }
            BigDecimal bigDecimal = BigDecimal.valueOf(value.doubleValue());
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "valueOf(value.toDouble())");
            return bigDecimal;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geldbetrag ofMinor(@NotNull CurrencyUnit currency, long amountMinor) {
            Intrinsics.checkNotNullParameter(currency, "currency");
            return de.jfachwert.bank.Geldbetrag$Companion.ofMinor$default(this, currency, amountMinor, 0, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geldbetrag parse(@Nullable CharSequence text) {
            return de.jfachwert.bank.Geldbetrag$Companion.parse$default(this, text, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\u0006"}, d2={"Lde/jfachwert/bank/Geldbetrag$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "()V", "validate", "value", "jfachwert"})
    public static final class Validator
    implements KSimpleValidator<String> {
        @Override
        @NotNull
        public String validate(@NotNull String value) {
            String string;
            Intrinsics.checkNotNullParameter(value, "value");
            try {
                string = Companion.valueOf(value).toString();
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidValueException((Serializable)((Object)value), "money_amount", ex);
            }
            return string;
        }

        @Override
        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject(this, value);
        }

        @Override
        @NotNull
        public String verify(@NotNull String value) {
            return (String)((Object)KSimpleValidator.DefaultImpls.verify(this, (Serializable)((Object)value)));
        }
    }
}

