/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.jfachwert.KFachwert;
import de.jfachwert.math.Prozent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Period;
import java.util.Map;
import java.util.WeakHashMap;
import javax.money.MonetaryAmount;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToStringSerializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0017\u0018\u0000 \u001d2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u001dB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012J\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lde/jfachwert/bank/Zinssatz;", "Lde/jfachwert/KFachwert;", "", "satz", "", "(Ljava/lang/String;)V", "prozent", "Lde/jfachwert/math/Prozent;", "(Lde/jfachwert/math/Prozent;)V", "getProzent", "()Lde/jfachwert/math/Prozent;", "compareTo", "", "other", "equals", "", "", "getEndkapital", "Ljavax/money/MonetaryAmount;", "startKapital", "dauer", "Ljava/time/Period;", "getJahresszins", "kapital", "getMonatszins", "getTageszins", "getZinsen", "hashCode", "toString", "Companion", "jfachwert"})
public class Zinssatz
implements KFachwert,
Comparable<Zinssatz> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Prozent prozent;
    @NotNull
    private static final WeakHashMap<Prozent, Zinssatz> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Zinssatz ZERO = Companion.of(Prozent.ZERO);
    @JvmField
    @NotNull
    public static final Zinssatz ONE = Companion.of(Prozent.ONE);
    @JvmField
    @NotNull
    public static final Zinssatz TEN = Companion.of(Prozent.TEN);

    public Zinssatz(@NotNull Prozent prozent) {
        Intrinsics.checkNotNullParameter(prozent, "prozent");
        this.prozent = prozent;
    }

    @NotNull
    public final Prozent getProzent() {
        return this.prozent;
    }

    public Zinssatz(@NotNull String satz) {
        Intrinsics.checkNotNullParameter(satz, "satz");
        this(Prozent.Companion.of(satz));
    }

    @NotNull
    public final MonetaryAmount getJahresszins(@NotNull MonetaryAmount kapital) {
        Intrinsics.checkNotNullParameter(kapital, "kapital");
        return this.prozent.multiply(kapital);
    }

    @NotNull
    public final MonetaryAmount getMonatszins(@NotNull MonetaryAmount kapital) {
        Intrinsics.checkNotNullParameter(kapital, "kapital");
        MonetaryAmount monetaryAmount = this.prozent.multiply(kapital).divide(12L);
        Intrinsics.checkNotNullExpressionValue(monetaryAmount, "prozent.multiply(kapital).divide(12)");
        return monetaryAmount;
    }

    @NotNull
    public final MonetaryAmount getTageszins(@NotNull MonetaryAmount kapital) {
        Intrinsics.checkNotNullParameter(kapital, "kapital");
        MonetaryAmount monetaryAmount = this.prozent.multiply(kapital).divide(360L);
        Intrinsics.checkNotNullExpressionValue(monetaryAmount, "prozent.multiply(kapital).divide(360)");
        return monetaryAmount;
    }

    @NotNull
    public final MonetaryAmount getZinsen(@NotNull MonetaryAmount kapital, @NotNull Period dauer) {
        Intrinsics.checkNotNullParameter(kapital, "kapital");
        Intrinsics.checkNotNullParameter(dauer, "dauer");
        MonetaryAmount monetaryAmount = this.getEndkapital(kapital, dauer).subtract(kapital);
        Intrinsics.checkNotNullExpressionValue(monetaryAmount, "getEndkapital(kapital, dauer).subtract(kapital)");
        return monetaryAmount;
    }

    @NotNull
    public final MonetaryAmount getEndkapital(@NotNull MonetaryAmount startKapital, @NotNull Period dauer) {
        Intrinsics.checkNotNullParameter(startKapital, "startKapital");
        Intrinsics.checkNotNullParameter(dauer, "dauer");
        Period normalized = dauer.normalized();
        BigDecimal faktor = this.prozent.toBigDecimal().add(BigDecimal.ONE);
        MonetaryAmount endKapital = startKapital.multiply(faktor.pow(normalized.getYears()).setScale(startKapital.getContext().getMaxScale(), RoundingMode.HALF_UP));
        Intrinsics.checkNotNullExpressionValue(endKapital, "endKapital");
        MonetaryAmount monetaryAmount = endKapital.add(this.getMonatszins(endKapital).multiply((Number)normalized.getMonths())).add(this.getTageszins(endKapital).multiply((Number)normalized.getDays()));
        Intrinsics.checkNotNullExpressionValue(monetaryAmount, "endKapital.add(getMonats\u2026ultiply(normalized.days))");
        return monetaryAmount;
    }

    @Override
    public int compareTo(@NotNull Zinssatz other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.prozent.compareTo(other.prozent);
    }

    @NotNull
    public String toString() {
        return this.prozent.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Zinssatz)) {
            return false;
        }
        return Intrinsics.areEqual(this.prozent, ((Zinssatz)other).prozent);
    }

    public int hashCode() {
        return this.prozent.hashCode();
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap(this);
    }

    @JvmStatic
    @NotNull
    public static final Zinssatz of(@NotNull String satz) {
        return Companion.of(satz);
    }

    @JvmStatic
    @NotNull
    public static final Zinssatz of(@NotNull Prozent satz) {
        return Companion.of(satz);
    }

    @JvmStatic
    @NotNull
    public static final Zinssatz of(@NotNull MonetaryAmount kapital, @NotNull MonetaryAmount zins, long monate) {
        return Companion.of(kapital, zins, monate);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0007J \u0010\n\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0011H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/jfachwert/bank/Zinssatz$Companion;", "", "()V", "ONE", "Lde/jfachwert/bank/Zinssatz;", "TEN", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lde/jfachwert/math/Prozent;", "ZERO", "of", "satz", "kapital", "Ljavax/money/MonetaryAmount;", "zins", "monate", "", "", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Zinssatz of(@NotNull String satz) {
            Intrinsics.checkNotNullParameter(satz, "satz");
            return this.of(Prozent.Companion.of(satz));
        }

        @JvmStatic
        @NotNull
        public final Zinssatz of(@NotNull Prozent satz) {
            Intrinsics.checkNotNullParameter(satz, "satz");
            Zinssatz zinssatz = WEAK_CACHE.computeIfAbsent(satz, Zinssatz::new);
            Intrinsics.checkNotNullExpressionValue(zinssatz, "WEAK_CACHE.computeIfAbse\u2026tz, Function(::Zinssatz))");
            return zinssatz;
        }

        @JvmStatic
        @NotNull
        public final Zinssatz of(@NotNull MonetaryAmount kapital, @NotNull MonetaryAmount zins, long monate) {
            Intrinsics.checkNotNullParameter(kapital, "kapital");
            Intrinsics.checkNotNullParameter(zins, "zins");
            BigDecimal bigDecimal = kapital.getNumber().numberValue(BigDecimal.class);
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "kapital.number.numberVal\u2026>(BigDecimal::class.java)");
            BigDecimal k = bigDecimal;
            BigDecimal bigDecimal2 = zins.getNumber().numberValue(BigDecimal.class);
            Intrinsics.checkNotNullExpressionValue(bigDecimal2, "zins.number.numberValue<\u2026>(BigDecimal::class.java)");
            BigDecimal z = bigDecimal2;
            BigDecimal bigDecimal3 = z.divide(k).multiply(BigDecimal.valueOf(1200L).divide(BigDecimal.valueOf(monate)));
            Intrinsics.checkNotNullExpressionValue(bigDecimal3, "z.divide(k).multiply(Big\u2026Decimal.valueOf(monate)))");
            BigDecimal p = bigDecimal3;
            return this.of(Prozent.Companion.of(p));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

