/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank.internal;

import de.jfachwert.bank.Geldbetrag;
import de.jfachwert.bank.Waehrung;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.NumberValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.LocalizedMonetaryParseException;
import de.jfachwert.pruefung.exception.ValidationException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.format.AmountFormatContext;
import javax.money.format.AmountFormatContextBuilder;
import javax.money.format.MonetaryAmountFormat;
import javax.money.format.MonetaryParseException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\rH\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/jfachwert/bank/internal/GeldbetragFormatter;", "Ljavax/money/format/MonetaryAmountFormat;", "()V", "locale", "Ljava/util/Locale;", "(Ljava/util/Locale;)V", "context", "Ljavax/money/format/AmountFormatContext;", "(Ljavax/money/format/AmountFormatContext;)V", "getContext", "getFormatter", "Ljava/text/NumberFormat;", "getMonetaryAmount", "Ljavax/money/MonetaryAmount;", "cry", "Ljava/util/Currency;", "n", "Ljava/math/BigDecimal;", "parse", "text", "", "", "print", "", "appendable", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "amount", "queryFrom", "toString", "Companion", "jfachwert"})
@SourceDebugExtension(value={"SMAP\nGeldbetragFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeldbetragFormatter.kt\nde/jfachwert/bank/internal/GeldbetragFormatter\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,185:1\n107#2:186\n79#2,22:187\n107#2:209\n79#2,22:210\n*S KotlinDebug\n*F\n+ 1 GeldbetragFormatter.kt\nde/jfachwert/bank/internal/GeldbetragFormatter\n*L\n140#1:186\n140#1:187,22\n148#1:209\n148#1:210,22\n*E\n"})
public final class GeldbetragFormatter
implements MonetaryAmountFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AmountFormatContext context;
    @NotNull
    private static final Map<Locale, Locale> MAPPED_LOCALES = new HashMap();

    private GeldbetragFormatter(AmountFormatContext context) {
        this.context = context;
    }

    public GeldbetragFormatter() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault()");
        this(locale);
    }

    private GeldbetragFormatter(Locale locale) {
        AmountFormatContext amountFormatContext = AmountFormatContextBuilder.of("jfachwert").setLocale(locale).build();
        Intrinsics.checkNotNullExpressionValue(amountFormatContext, "of(\"jfachwert\").setLocale(locale).build()");
        this(amountFormatContext);
    }

    @Override
    @NotNull
    public AmountFormatContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(@NotNull Appendable appendable, @NotNull MonetaryAmount amount) throws IOException {
        Intrinsics.checkNotNullParameter(appendable, "appendable");
        Intrinsics.checkNotNullParameter(amount, "amount");
        CurrencyUnit currency = amount.getCurrency();
        int fractionDigits = currency.getDefaultFractionDigits();
        AmountFormatContext amountFormatContext = this.context;
        synchronized (amountFormatContext) {
            boolean bl = false;
            Locale locale = this.context.getLocale();
            Intrinsics.checkNotNullExpressionValue(locale, "context.locale");
            NumberFormat formatter = this.getFormatter(locale);
            formatter.setMinimumFractionDigits(fractionDigits);
            formatter.setMaximumFractionDigits(fractionDigits);
            String s = formatter.format(amount.getNumber()) + ' ' + currency;
            Appendable appendable2 = appendable.append(s);
        }
    }

    private final NumberFormat getFormatter(Locale locale) {
        NumberFormat formatter = NumberFormat.getInstance(locale);
        String s = formatter.format(0L);
        if (!Intrinsics.areEqual("0", s)) {
            formatter = NumberFormat.getInstance();
        }
        NumberFormat numberFormat = formatter;
        Intrinsics.checkNotNullExpressionValue(numberFormat, "formatter");
        return numberFormat;
    }

    @Override
    @NotNull
    public MonetaryAmount parse(@NotNull CharSequence text) throws MonetaryParseException {
        Intrinsics.checkNotNullParameter(text, "text");
        String string = Objects.toString(text);
        Intrinsics.checkNotNullExpressionValue(string, "toString(text)");
        return this.parse(string);
    }

    private final MonetaryAmount parse(String text) throws MonetaryParseException {
        MonetaryAmount monetaryAmount;
        String trimmed;
        String[] parts;
        String $this$trim$iv = (String)((Object)new NullValidator<Serializable>().validate((Serializable)((Object)text)));
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if ((parts = StringUtils.splitByCharacterType(StringUtils.upperCase(trimmed = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()))).length == 0) {
            throw new InvalidValueException((Serializable)((Object)text), "money amount");
        }
        Currency cry = Waehrung.DEFAULT_CURRENCY;
        Intrinsics.checkNotNullExpressionValue(parts, "parts");
        String currencyString = GeldbetragFormatter.Companion.findCurrencyString(parts);
        try {
            String string = StringUtils.remove(trimmed, currencyString);
            Intrinsics.checkNotNullExpressionValue(string, "remove(trimmed, currencyString)");
            String $this$trim$iv2 = string;
            boolean $i$f$trim3 = false;
            CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
            boolean $i$f$trim4 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            trimmed = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
            BigDecimal n = new BigDecimal(new NumberValidator(null, null, 3, null).validate(trimmed));
            if (StringUtils.isNotEmpty(currencyString)) {
                cry = Waehrung.Companion.toCurrency(currencyString);
            }
            monetaryAmount = this.getMonetaryAmount(cry, n);
        }
        catch (IllegalArgumentException ex) {
            throw new LocalizedMonetaryParseException((CharSequence)text, (Throwable)ex);
        }
        catch (ValidationException ex) {
            throw new LocalizedMonetaryParseException((CharSequence)text, (Throwable)ex);
        }
        return monetaryAmount;
    }

    private final MonetaryAmount getMonetaryAmount(Currency cry, BigDecimal n) {
        MonetaryAmount monetaryAmount;
        MonetaryAmountFactory amountFactory = this.context.get(MonetaryAmountFactory.class);
        if (amountFactory == null) {
            monetaryAmount = Geldbetrag.Companion.of((Number)n, cry);
        } else {
            Object t = amountFactory.setNumber(n).setCurrency(cry.toString()).create();
            monetaryAmount = t;
            Intrinsics.checkNotNullExpressionValue(t, "{\n            amountFact\u2026ing()).create()\n        }");
        }
        return monetaryAmount;
    }

    @Override
    @NotNull
    public String queryFrom(@NotNull MonetaryAmount amount) {
        Intrinsics.checkNotNullParameter(amount, "amount");
        String string = Objects.toString(amount);
        Intrinsics.checkNotNullExpressionValue(string, "toString(amount)");
        return string;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.context.getLocale() + ')';
    }

    @JvmStatic
    @NotNull
    public static final GeldbetragFormatter of(@NotNull Locale locale) {
        return Companion.of(locale);
    }

    @JvmStatic
    @NotNull
    public static final GeldbetragFormatter of(@NotNull AmountFormatContext context) {
        return Companion.of(context);
    }

    public /* synthetic */ GeldbetragFormatter(AmountFormatContext context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    static {
        Map<Locale, Locale> map = MAPPED_LOCALES;
        Locale locale = new Locale("de_DE");
        Locale locale2 = Locale.GERMANY;
        Intrinsics.checkNotNullExpressionValue(locale2, "GERMANY");
        Locale locale3 = locale2;
        map.put(locale, locale3);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/jfachwert/bank/internal/GeldbetragFormatter$Companion;", "", "()V", "MAPPED_LOCALES", "", "Ljava/util/Locale;", "findCurrencyString", "", "parts", "", "([Ljava/lang/String;)Ljava/lang/String;", "of", "Lde/jfachwert/bank/internal/GeldbetragFormatter;", "locale", "context", "Ljavax/money/format/AmountFormatContext;", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GeldbetragFormatter of(@NotNull Locale locale) {
            Intrinsics.checkNotNullParameter(locale, "locale");
            Locale mapped = MAPPED_LOCALES.getOrDefault(locale, locale);
            AmountFormatContext amountFormatContext = AmountFormatContextBuilder.of("jfachwert").setLocale(mapped).build();
            Intrinsics.checkNotNullExpressionValue(amountFormatContext, "of(\"jfachwert\").setLocale(mapped).build()");
            return new GeldbetragFormatter(amountFormatContext, null);
        }

        @JvmStatic
        @NotNull
        public final GeldbetragFormatter of(@NotNull AmountFormatContext context) {
            Intrinsics.checkNotNullParameter(context, "context");
            return new GeldbetragFormatter(context, null);
        }

        private final String findCurrencyString(String[] parts) {
            if (!StringUtils.isNumericSpace(parts[0])) {
                return parts[0];
            }
            return !StringUtils.isNumericSpace(parts[parts.length - 1]) ? parts[parts.length - 1] : "";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

