/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.bank.internal;

import de.jfachwert.math.Bruch;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import javax.money.NumberValue;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\f\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J%\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\rH\u0016\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0017\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\rH\u0016\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0018\u001a\u00020\u00012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\bH\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u000fH\u0016J\b\u0010'\u001a\u00020\nH\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006-"}, d2={"Lde/jfachwert/bank/internal/Zahlenwert;", "Ljavax/money/NumberValue;", "number", "", "(Ljava/lang/Number;)V", "getNumber", "()Ljava/lang/Number;", "doubleValueExact", "", "getAmountFractionDenominator", "", "getAmountFractionNumerator", "getNumberType", "Ljava/lang/Class;", "getPrecision", "", "getScale", "intValueExact", "longValueExact", "numberValue", "T", "numberType", "(Ljava/lang/Class;)Ljava/lang/Number;", "numberValueExact", "round", "mathContext", "Ljava/math/MathContext;", "toBigDecimal", "Ljava/math/BigDecimal;", "toBruch", "Lde/jfachwert/math/Bruch;", "toByte", "", "toChar", "", "toDouble", "toFloat", "", "toInt", "toLong", "toShort", "", "toString", "", "Companion", "jfachwert"})
public final class Zahlenwert
extends NumberValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Number number;

    public Zahlenwert(@NotNull Number number) {
        Intrinsics.checkNotNullParameter(number, "number");
        this.number = number;
    }

    @NotNull
    public final Number getNumber() {
        return this.number;
    }

    public byte toByte() {
        return this.toBigDecimal().byteValue();
    }

    public char toChar() {
        return this.toBigDecimal().toChar();
    }

    public double toDouble() {
        return this.number.doubleValue();
    }

    public float toFloat() {
        return this.toBigDecimal().floatValue();
    }

    public int toInt() {
        return this.toBigDecimal().intValue();
    }

    public long toLong() {
        return this.toBigDecimal().longValue();
    }

    public short toShort() {
        return this.toBigDecimal().shortValue();
    }

    @NotNull
    public final BigDecimal toBigDecimal() {
        if (this.number instanceof BigDecimal) {
            return (BigDecimal)this.number;
        }
        return new BigDecimal(this.number.toString());
    }

    @NotNull
    public final Bruch toBruch() {
        return Bruch.Companion.of(this.toString());
    }

    @NotNull
    public String toString() {
        String string = this.toBigDecimal().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toBigDecimal().toString()");
        return string;
    }

    @Override
    @NotNull
    public Class<?> getNumberType() {
        return this.number.getClass();
    }

    @Override
    public int getPrecision() {
        return this.toBigDecimal().precision();
    }

    @Override
    public int getScale() {
        return this.toBigDecimal().scale();
    }

    @Override
    public int intValueExact() {
        return this.toBigDecimal().intValueExact();
    }

    @Override
    public long longValueExact() {
        return this.toBigDecimal().longValueExact();
    }

    @Override
    public double doubleValueExact() {
        return this.toBigDecimal().doubleValue();
    }

    @Override
    @NotNull
    public <T extends Number> T numberValue(@NotNull Class<T> numberType) {
        Intrinsics.checkNotNullParameter(numberType, "numberType");
        Class<T> clazz = numberType;
        if (Intrinsics.areEqual(clazz, Short.class)) {
            return (T)((Number)this.number.shortValue());
        }
        if (Intrinsics.areEqual(clazz, Integer.class)) {
            return (T)((Number)this.number.intValue());
        }
        if (Intrinsics.areEqual(clazz, Long.class)) {
            return (T)((Number)this.number.longValue());
        }
        if (Intrinsics.areEqual(clazz, Float.class)) {
            return (T)Float.valueOf(this.number.floatValue());
        }
        if (Intrinsics.areEqual(clazz, Double.class)) {
            return (T)((Number)this.number.doubleValue());
        }
        if (Intrinsics.areEqual(clazz, Byte.class)) {
            return (T)((Number)this.number.byteValue());
        }
        if (Intrinsics.areEqual(clazz, BigInteger.class)) {
            BigInteger bigInteger = new BigDecimal(this.number.toString()).toBigInteger();
            Intrinsics.checkNotNullExpressionValue(bigInteger, "BigDecimal(number.toString()).toBigInteger()");
            BigInteger x = bigInteger;
            return (T)x;
        }
        Number number = this.number;
        Intrinsics.checkNotNull(number, "null cannot be cast to non-null type T of de.jfachwert.bank.internal.Zahlenwert.numberValue");
        return (T)number;
    }

    @Override
    @NotNull
    public NumberValue round(@Nullable MathContext mathContext) {
        BigDecimal bigDecimal = this.toBigDecimal().round(mathContext);
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "toBigDecimal().round(mathContext)");
        return new Zahlenwert(bigDecimal);
    }

    @Override
    @NotNull
    public <T extends Number> T numberValueExact(@NotNull Class<T> numberType) {
        Intrinsics.checkNotNullParameter(numberType, "numberType");
        T valueExact = this.numberValue(numberType);
        if (this.toBigDecimal().toString().equals(valueExact.toString())) {
            return valueExact;
        }
        throw new LocalizedIllegalArgumentException(this.number, "data_type " + numberType, null, 4, null);
    }

    @Override
    public long getAmountFractionNumerator() {
        return this.toBruch().getZaehler().longValue();
    }

    @Override
    public long getAmountFractionDenominator() {
        return this.toBruch().getNenner().longValue();
    }

    @JvmStatic
    @NotNull
    public static final Zahlenwert of(@NotNull Number n) {
        return Companion.of(n);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lde/jfachwert/bank/internal/Zahlenwert$Companion;", "", "()V", "of", "Lde/jfachwert/bank/internal/Zahlenwert;", "n", "", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Zahlenwert of(@NotNull Number n) {
            Intrinsics.checkNotNullParameter(n, "n");
            return new Zahlenwert(n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

