/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.math;

import de.jfachwert.KFachwert;
import de.jfachwert.math.AbstractNumber;
import de.jfachwert.math.Primzahl;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\n\b\u0016\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0015\b\u0012\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eB\u0017\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0012B\u0015\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0000J\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0000J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020\u001aH\u0016J\u0006\u0010!\u001a\u00020\u0000J\u0006\u0010\"\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010$\u001a\u00020\u0000J\u000e\u0010%\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0000J\b\u0010&\u001a\u00020\nH\u0016J\b\u0010'\u001a\u00020\u0004H\u0016R\u0011\u0010\u0011\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006)"}, d2={"Lde/jfachwert/math/Bruch;", "Lde/jfachwert/math/AbstractNumber;", "Lde/jfachwert/KFachwert;", "bruch", "", "(Ljava/lang/String;)V", "number", "", "(D)V", "decimal", "Ljava/math/BigDecimal;", "(Ljava/math/BigDecimal;)V", "", "Ljava/math/BigInteger;", "([Ljava/math/BigInteger;)V", "zaehler", "", "nenner", "(JJ)V", "(Ljava/math/BigInteger;Ljava/math/BigInteger;)V", "getNenner", "()Ljava/math/BigInteger;", "getZaehler", "add", "operand", "compareTo", "", "other", "divide", "equals", "", "", "hashCode", "kehrwert", "kuerzen", "multiply", "negate", "subtract", "toBigDecimal", "toString", "Companion", "jfachwert"})
public class Bruch
extends AbstractNumber
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInteger zaehler;
    @NotNull
    private final BigInteger nenner;
    @NotNull
    private static final Bruch NULL = new Bruch(0L, 1L);

    public Bruch(@NotNull BigInteger zaehler, @NotNull BigInteger nenner) {
        Intrinsics.checkNotNullParameter(zaehler, "zaehler");
        Intrinsics.checkNotNullParameter(nenner, "nenner");
        this.zaehler = zaehler;
        this.nenner = nenner;
    }

    @NotNull
    public final BigInteger getZaehler() {
        return this.zaehler;
    }

    @NotNull
    public final BigInteger getNenner() {
        return this.nenner;
    }

    public Bruch(@NotNull String bruch) {
        Intrinsics.checkNotNullParameter(bruch, "bruch");
        this(Bruch.Companion.toNumbers(bruch));
    }

    public Bruch(double number) {
        BigDecimal bigDecimal = BigDecimal.valueOf(number);
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "valueOf(number)");
        this(bigDecimal);
    }

    public Bruch(@NotNull BigDecimal decimal) {
        Intrinsics.checkNotNullParameter(decimal, "decimal");
        this(Bruch.Companion.toNumbers(decimal));
    }

    private Bruch(BigInteger[] number) {
        this(number[0], number[1]);
    }

    public Bruch(long zaehler, long nenner) {
        BigInteger bigInteger = BigInteger.valueOf(zaehler);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "valueOf(zaehler)");
        BigInteger bigInteger2 = BigInteger.valueOf(nenner);
        Intrinsics.checkNotNullExpressionValue(bigInteger2, "valueOf(nenner)");
        this(bigInteger, bigInteger2);
    }

    @NotNull
    public final Bruch kuerzen() {
        BigInteger z = this.zaehler;
        BigInteger n = this.nenner;
        Primzahl p = Primzahl.Companion.first();
        while (p.toBigInteger().compareTo(n) < 0) {
            BigInteger teiler = p.toBigInteger();
            while (Intrinsics.areEqual(z.mod(teiler), BigInteger.ZERO) && Intrinsics.areEqual(n.mod(teiler), BigInteger.ZERO)) {
                Intrinsics.checkNotNullExpressionValue(z.divide(teiler), "z.divide(teiler)");
                Intrinsics.checkNotNullExpressionValue(n.divide(teiler), "n.divide(teiler)");
            }
            p = p.next();
        }
        return Companion.of(z, n);
    }

    @NotNull
    public final Bruch kehrwert() {
        return Companion.of(this.nenner, this.zaehler);
    }

    @NotNull
    public final Bruch negate() {
        BigInteger bigInteger = this.zaehler.negate();
        Intrinsics.checkNotNullExpressionValue(bigInteger, "zaehler.negate()");
        return Companion.of(bigInteger, this.nenner);
    }

    @NotNull
    public final AbstractNumber multiply(@NotNull Bruch operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        BigInteger z = this.zaehler.multiply(operand.zaehler);
        BigInteger n = this.nenner.multiply(operand.nenner);
        Intrinsics.checkNotNullExpressionValue(z, "z");
        Intrinsics.checkNotNullExpressionValue(n, "n");
        return Companion.of(z, n).kuerzen();
    }

    @NotNull
    public final AbstractNumber divide(@NotNull Bruch operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        return this.multiply(operand.kehrwert());
    }

    @NotNull
    public final AbstractNumber add(@NotNull Bruch operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        BigInteger n = this.nenner.multiply(operand.nenner);
        BigInteger z1 = this.zaehler.multiply(operand.nenner);
        BigInteger z2 = operand.zaehler.multiply(this.nenner);
        BigInteger bigInteger = z1.add(z2);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "z1.add(z2)");
        Intrinsics.checkNotNullExpressionValue(n, "n");
        return Companion.of(bigInteger, n).kuerzen();
    }

    @NotNull
    public final AbstractNumber subtract(@NotNull Bruch operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        return this.add(operand.negate());
    }

    @NotNull
    public String toString() {
        return this.zaehler.toString() + '/' + this.nenner;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Bruch)) {
            return false;
        }
        Bruch bruch = ((Bruch)other).kuerzen();
        Bruch gekuerzt = this.kuerzen();
        return Intrinsics.areEqual(gekuerzt.zaehler, bruch.zaehler) && Intrinsics.areEqual(gekuerzt.nenner, bruch.nenner);
    }

    public int hashCode() {
        return this.kuerzen().toString().hashCode();
    }

    @Override
    public int compareTo(@NotNull AbstractNumber other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return other instanceof Bruch ? this.compareTo((Bruch)other) : super.compareTo(other);
    }

    @Override
    public final int compareTo(@NotNull Bruch other) {
        Intrinsics.checkNotNullParameter(other, "other");
        BigInteger thisZaehlerErweitert = this.zaehler.multiply(other.nenner);
        BigInteger otherZaehlerErweitert = other.zaehler.multiply(this.nenner);
        return thisZaehlerErweitert.compareTo(otherZaehlerErweitert);
    }

    @Override
    @NotNull
    public BigDecimal toBigDecimal() {
        BigDecimal bigDecimal = new BigDecimal(this.zaehler).divide(new BigDecimal(this.nenner));
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "BigDecimal(zaehler).divide(BigDecimal(nenner))");
        return bigDecimal;
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap(this);
    }

    @NotNull
    public static final Bruch getNULL() {
        return Companion.getNULL();
    }

    @JvmStatic
    @NotNull
    public static final Bruch of(@NotNull String bruch) {
        return Companion.of(bruch);
    }

    @JvmStatic
    @NotNull
    public static final Bruch of(long zaehler, long nenner) {
        return Companion.of(zaehler, nenner);
    }

    @JvmStatic
    @NotNull
    public static final Bruch of(@NotNull BigInteger zaehler, @NotNull BigInteger nenner) {
        return Companion.of(zaehler, nenner);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0015R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lde/jfachwert/math/Bruch$Companion;", "", "()V", "NULL", "Lde/jfachwert/math/Bruch;", "getNULL$annotations", "getNULL", "()Lde/jfachwert/math/Bruch;", "of", "zaehler", "Ljava/math/BigInteger;", "nenner", "", "bruch", "", "toBruch", "decimal", "Ljava/math/BigDecimal;", "toNumbers", "", "(Ljava/math/BigDecimal;)[Ljava/math/BigInteger;", "(Ljava/lang/String;)[Ljava/math/BigInteger;", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Bruch getNULL() {
            return NULL;
        }

        @JvmStatic
        public static /* synthetic */ void getNULL$annotations() {
        }

        private final BigInteger[] toNumbers(String bruch) {
            String[] parts = StringUtils.split(bruch, "/");
            try {
                switch (parts.length) {
                    case 1: {
                        Bruch dezimalBruch = this.toBruch(new BigDecimal(parts[0]));
                        BigInteger[] bigIntegerArray = new BigInteger[]{dezimalBruch.getZaehler(), dezimalBruch.getNenner()};
                        return bigIntegerArray;
                    }
                    case 2: {
                        BigInteger[] dezimalBruch = new BigInteger[]{new BigInteger(parts[0]), new BigInteger(parts[1])};
                        return dezimalBruch;
                    }
                }
                throw new LocalizedIllegalArgumentException((Serializable)((Object)bruch), "fraction", null, 4, null);
            }
            catch (IllegalArgumentException ex) {
                throw new LocalizedIllegalArgumentException((Serializable)((Object)bruch), "fraction", ex);
            }
        }

        private final BigInteger[] toNumbers(BigDecimal decimal) {
            Bruch dezimalBruch = this.toBruch(decimal);
            BigInteger[] bigIntegerArray = new BigInteger[]{dezimalBruch.getZaehler(), dezimalBruch.getNenner()};
            return bigIntegerArray;
        }

        private final Bruch toBruch(BigDecimal decimal) {
            int scale = decimal.scale();
            BigInteger z = decimal.movePointRight(scale).toBigInteger();
            BigInteger n = BigDecimal.ONE.movePointRight(scale).toBigInteger();
            Intrinsics.checkNotNullExpressionValue(z, "z");
            Intrinsics.checkNotNullExpressionValue(n, "n");
            return this.of(z, n).kuerzen();
        }

        @JvmStatic
        @NotNull
        public final Bruch of(@NotNull String bruch) {
            Intrinsics.checkNotNullParameter(bruch, "bruch");
            return new Bruch(bruch);
        }

        @JvmStatic
        @NotNull
        public final Bruch of(long zaehler, long nenner) {
            return new Bruch(zaehler, nenner);
        }

        @JvmStatic
        @NotNull
        public final Bruch of(@NotNull BigInteger zaehler, @NotNull BigInteger nenner) {
            Intrinsics.checkNotNullParameter(zaehler, "zaehler");
            Intrinsics.checkNotNullParameter(nenner, "nenner");
            return new Bruch(zaehler, nenner);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

