/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.math;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.jfachwert.KFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.math.AbstractNumber;
import de.jfachwert.math.Bruch;
import de.jfachwert.math.PackedDecimal;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToStringSerializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\f\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\nJ\u0011\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0018J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nJ\u0013\u0010\u001d\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020\u0004H\u0016J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0018J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nJ\u0016\u0010$\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0018J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nJ\b\u0010(\u001a\u00020\nH\u0016J\u0006\u0010)\u001a\u00020\u0018J\b\u0010*\u001a\u00020\fH\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006,"}, d2={"Lde/jfachwert/math/PackedDecimal;", "Lde/jfachwert/math/AbstractNumber;", "Lde/jfachwert/KFachwert;", "zahl", "", "(I)V", "", "(J)V", "", "(D)V", "Ljava/math/BigDecimal;", "(Ljava/math/BigDecimal;)V", "", "validator", "Lde/jfachwert/KSimpleValidator;", "(Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "code", "", "isBruch", "", "()Z", "isNumber", "add", "summand", "Lde/jfachwert/math/Bruch;", "compareTo", "other", "divide", "operand", "equals", "", "hashCode", "movePointLeft", "n", "movePointRight", "multiply", "setScale", "mode", "Ljava/math/RoundingMode;", "subtract", "toBigDecimal", "toBruch", "toString", "Companion", "jfachwert"})
@SourceDebugExtension(value={"SMAP\nPackedDecimal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackedDecimal.kt\nde/jfachwert/math/PackedDecimal\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,671:1\n107#2:672\n79#2,22:673\n*S KotlinDebug\n*F\n+ 1 PackedDecimal.kt\nde/jfachwert/math/PackedDecimal\n*L\n618#1:672\n618#1:673,22\n*E\n"})
public class PackedDecimal
extends AbstractNumber
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] code;
    private static final Logger LOG = Logger.getLogger(PackedDecimal.class.getName());
    @NotNull
    private static final NullValidator<String> VALIDATOR = new NullValidator();
    @NotNull
    private static final PackedDecimal[] CACHE = new PackedDecimal[10];
    @NotNull
    private static final WeakHashMap<String, PackedDecimal> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final PackedDecimal NULL;
    @JvmField
    @NotNull
    public static final PackedDecimal EMPTY;
    @JvmField
    @Nullable
    public static final PackedDecimal ZERO;
    @JvmField
    @Nullable
    public static final PackedDecimal ONE;
    @JvmField
    @NotNull
    public static final PackedDecimal TEN;

    @JvmOverloads
    public PackedDecimal(@NotNull String zahl, @NotNull KSimpleValidator<String> validator) {
        Intrinsics.checkNotNullParameter(zahl, "zahl");
        Intrinsics.checkNotNullParameter(validator, "validator");
        this.code = PackedDecimal.Companion.asNibbles(validator.validate((String)((Object)((Serializable)((Object)zahl)))));
    }

    public /* synthetic */ PackedDecimal(String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(string, kSimpleValidator);
    }

    public PackedDecimal(int zahl) {
        this((long)zahl);
    }

    public PackedDecimal(long zahl) {
        String string = Long.toString(zahl);
        Intrinsics.checkNotNullExpressionValue(string, "toString(zahl)");
        this(string, null, 2, null);
    }

    public PackedDecimal(double zahl) {
        String string = Double.toString(zahl);
        Intrinsics.checkNotNullExpressionValue(string, "toString(zahl)");
        this(string, null, 2, null);
    }

    public PackedDecimal(@NotNull BigDecimal zahl) {
        Intrinsics.checkNotNullParameter(zahl, "zahl");
        String string = zahl.toString();
        Intrinsics.checkNotNullExpressionValue(string, "zahl.toString()");
        this(string, null, 2, null);
    }

    public final boolean isBruch() {
        boolean bl;
        String s = this.toString();
        if (StringsKt.contains$default((CharSequence)s, "/", false, 2, null)) {
            boolean bl2;
            try {
                Bruch.Companion.of(s);
                bl2 = true;
            }
            catch (IllegalArgumentException ex) {
                LOG.fine(s + " is not a fraction: " + ex);
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isNumber() {
        boolean bl;
        CharSequence charSequence = this.toString();
        Regex regex = new Regex(" ");
        String string = "";
        String packed = regex.replace(charSequence, string);
        try {
            new BigDecimal(packed);
            bl = true;
        }
        catch (NumberFormatException nfe) {
            LOG.fine(packed + " is not a number: " + nfe);
            bl = this.isBruch();
        }
        return bl;
    }

    @NotNull
    public final Bruch toBruch() {
        return Bruch.Companion.of(this.toString());
    }

    @Override
    @NotNull
    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.toString());
    }

    @NotNull
    public final PackedDecimal add(@NotNull PackedDecimal summand) {
        Intrinsics.checkNotNullParameter(summand, "summand");
        return this.isBruch() || summand.isBruch() ? this.add(summand.toBruch()) : this.add(summand.toBigDecimal());
    }

    @NotNull
    public final PackedDecimal add(@NotNull BigDecimal summand) {
        Intrinsics.checkNotNullParameter(summand, "summand");
        BigDecimal summe = this.toBigDecimal().add(summand);
        Intrinsics.checkNotNullExpressionValue(summe, "summe");
        return Companion.valueOf(summe);
    }

    @NotNull
    public final PackedDecimal add(@NotNull Bruch summand) {
        Intrinsics.checkNotNullParameter(summand, "summand");
        AbstractNumber summe = this.toBruch().add(summand);
        return Companion.valueOf(summe);
    }

    @NotNull
    public final PackedDecimal subtract(@NotNull PackedDecimal operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        return this.isBruch() || operand.isBruch() ? this.subtract(operand.toBruch()) : this.subtract(operand.toBigDecimal());
    }

    @NotNull
    public final PackedDecimal subtract(@NotNull BigDecimal operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        BigDecimal result = this.toBigDecimal().subtract(operand);
        Intrinsics.checkNotNullExpressionValue(result, "result");
        return Companion.valueOf(result);
    }

    @NotNull
    public final PackedDecimal subtract(@NotNull Bruch operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        AbstractNumber result = this.toBruch().subtract(operand);
        return Companion.valueOf(result);
    }

    @NotNull
    public final PackedDecimal multiply(@NotNull PackedDecimal operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        return this.isBruch() || operand.isBruch() ? this.multiply(operand.toBruch()) : this.multiply(operand.toBigDecimal());
    }

    @NotNull
    public final PackedDecimal multiply(@NotNull BigDecimal operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        BigDecimal produkt = this.toBigDecimal().multiply(operand);
        Intrinsics.checkNotNullExpressionValue(produkt, "produkt");
        return Companion.valueOf(produkt);
    }

    @NotNull
    public final PackedDecimal multiply(@NotNull Bruch operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        AbstractNumber produkt = this.toBruch().multiply(operand);
        return Companion.valueOf(produkt);
    }

    @NotNull
    public final PackedDecimal divide(@NotNull PackedDecimal operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        return this.isBruch() || operand.isBruch() ? this.divide(operand.toBruch()) : this.divide(operand.toBigDecimal());
    }

    @NotNull
    public final PackedDecimal divide(@NotNull Bruch operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        return this.multiply(operand.kehrwert());
    }

    @NotNull
    public final PackedDecimal divide(@NotNull BigDecimal operand) {
        Intrinsics.checkNotNullParameter(operand, "operand");
        BigDecimal result = this.toBigDecimal().divide(operand, RoundingMode.HALF_UP);
        Intrinsics.checkNotNullExpressionValue(result, "result");
        return Companion.valueOf(result);
    }

    @NotNull
    public final PackedDecimal movePointLeft(int n) {
        BigDecimal result = this.toBigDecimal().movePointLeft(n);
        Intrinsics.checkNotNullExpressionValue(result, "result");
        return Companion.valueOf(result);
    }

    @NotNull
    public final PackedDecimal movePointRight(int n) {
        BigDecimal result = this.toBigDecimal().movePointRight(n);
        Intrinsics.checkNotNullExpressionValue(result, "result");
        return Companion.valueOf(result);
    }

    @NotNull
    public final PackedDecimal setScale(int n, @NotNull RoundingMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        BigDecimal result = this.toBigDecimal().setScale(n, mode);
        Intrinsics.checkNotNullExpressionValue(result, "result");
        return Companion.valueOf(result);
    }

    @NotNull
    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (byte b : this.code) {
            buf.append(PackedDecimal.Companion.encode(b >> 4));
            buf.append(PackedDecimal.Companion.encode(b & 0xF));
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "buf.toString()");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof PackedDecimal && Intrinsics.areEqual(this.toString(), ((PackedDecimal)other).toString());
    }

    @Override
    public int compareTo(@NotNull AbstractNumber other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return other instanceof PackedDecimal ? this.compareTo((PackedDecimal)other) : super.compareTo(other);
    }

    @Override
    public final int compareTo(@NotNull PackedDecimal other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.toBruch().compareTo(other.toBruch());
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap(this);
    }

    @JvmOverloads
    public PackedDecimal(@NotNull String zahl) {
        Intrinsics.checkNotNullParameter(zahl, "zahl");
        this(zahl, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final PackedDecimal valueOf(long zahl) {
        return Companion.valueOf(zahl);
    }

    @JvmStatic
    @NotNull
    public static final PackedDecimal of(long zahl) {
        return Companion.of(zahl);
    }

    @JvmStatic
    @NotNull
    public static final PackedDecimal valueOf(double zahl) {
        return Companion.valueOf(zahl);
    }

    @JvmStatic
    @NotNull
    public static final PackedDecimal of(double zahl) {
        return Companion.of(zahl);
    }

    @JvmStatic
    @NotNull
    public static final PackedDecimal valueOf(@NotNull BigDecimal zahl) {
        return Companion.valueOf(zahl);
    }

    @JvmStatic
    @NotNull
    public static final PackedDecimal of(@NotNull BigDecimal zahl) {
        return Companion.of(zahl);
    }

    @JvmStatic
    @NotNull
    public static final PackedDecimal valueOf(@NotNull AbstractNumber bruch) {
        return Companion.valueOf(bruch);
    }

    @JvmStatic
    @NotNull
    public static final PackedDecimal of(@NotNull AbstractNumber zahl) {
        return Companion.of(zahl);
    }

    @JvmStatic
    @NotNull
    public static final PackedDecimal valueOf(@NotNull String zahl) {
        return Companion.valueOf(zahl);
    }

    @JvmStatic
    @NotNull
    public static final PackedDecimal of(@NotNull String zahl) {
        return Companion.of(zahl);
    }

    static {
        int n = CACHE.length;
        for (int i = 0; i < n; ++i) {
            PackedDecimal.CACHE[i] = new PackedDecimal(i);
        }
        NULL = new PackedDecimal("", null, 2, null);
        EMPTY = new PackedDecimal("", null, 2, null);
        ZERO = CACHE[0];
        ONE = CACHE[1];
        TEN = Companion.of(10L);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u001eH\u0007J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u001fH\u0007J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020 H\u0007J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020!H\u0007J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0010H\u0007J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u001eH\u0007J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u001fH\u0007J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020 H\u0007J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0010H\u0007R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/jfachwert/math/PackedDecimal$Companion;", "", "()V", "CACHE", "", "Lde/jfachwert/math/PackedDecimal;", "[Lde/jfachwert/math/PackedDecimal;", "EMPTY", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "NULL", "ONE", "TEN", "VALIDATOR", "Lde/jfachwert/pruefung/NullValidator;", "", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "ZERO", "asNibbles", "", "zahl", "decode", "", "x", "", "encode", "nibble", "of", "Lde/jfachwert/math/AbstractNumber;", "Ljava/math/BigDecimal;", "", "", "valueOf", "bruch", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PackedDecimal valueOf(long zahl) {
            return this.valueOf(String.valueOf(zahl));
        }

        @JvmStatic
        @NotNull
        public final PackedDecimal of(long zahl) {
            return this.valueOf(zahl);
        }

        @JvmStatic
        @NotNull
        public final PackedDecimal valueOf(double zahl) {
            String string = Double.toString(zahl);
            Intrinsics.checkNotNullExpressionValue(string, "toString(zahl)");
            return this.valueOf(string);
        }

        @JvmStatic
        @NotNull
        public final PackedDecimal of(double zahl) {
            return this.valueOf(zahl);
        }

        @JvmStatic
        @NotNull
        public final PackedDecimal valueOf(@NotNull BigDecimal zahl) {
            Intrinsics.checkNotNullParameter(zahl, "zahl");
            String string = zahl.toString();
            Intrinsics.checkNotNullExpressionValue(string, "zahl.toString()");
            return this.valueOf(string);
        }

        @JvmStatic
        @NotNull
        public final PackedDecimal of(@NotNull BigDecimal zahl) {
            Intrinsics.checkNotNullParameter(zahl, "zahl");
            return this.valueOf(zahl);
        }

        @JvmStatic
        @NotNull
        public final PackedDecimal valueOf(@NotNull AbstractNumber bruch) {
            Intrinsics.checkNotNullParameter(bruch, "bruch");
            return this.valueOf(bruch.toString());
        }

        @JvmStatic
        @NotNull
        public final PackedDecimal of(@NotNull AbstractNumber zahl) {
            Intrinsics.checkNotNullParameter(zahl, "zahl");
            return this.valueOf(zahl);
        }

        @JvmStatic
        @NotNull
        public final PackedDecimal valueOf(@NotNull String zahl) {
            PackedDecimal packedDecimal;
            Intrinsics.checkNotNullParameter(zahl, "zahl");
            String trimmed = StringUtils.trimToEmpty(zahl);
            if (StringUtils.isEmpty(trimmed)) {
                return EMPTY;
            }
            if (trimmed.length() == 1 && Character.isDigit(trimmed.charAt(0))) {
                PackedDecimal packedDecimal2 = CACHE[Character.getNumericValue(trimmed.charAt(0))];
                packedDecimal = packedDecimal2;
                Intrinsics.checkNotNull(packedDecimal2);
            } else {
                PackedDecimal packedDecimal3 = WEAK_CACHE.computeIfAbsent(zahl, arg_0 -> Companion.valueOf$lambda$0(valueOf.1.INSTANCE, arg_0));
                Intrinsics.checkNotNullExpressionValue(packedDecimal3, "{\n                WEAK_C\u2026ecimal(z) }\n            }");
                packedDecimal = packedDecimal3;
            }
            return packedDecimal;
        }

        @JvmStatic
        @NotNull
        public final PackedDecimal of(@NotNull String zahl) {
            Intrinsics.checkNotNullParameter(zahl, "zahl");
            return this.valueOf(zahl);
        }

        private final byte[] asNibbles(String zahl) {
            char[] cArray = (zahl + ' ').toCharArray();
            Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
            char[] chars = cArray;
            byte[] bytes = new byte[chars.length / 2];
            try {
                int n = bytes.length;
                for (int i = 0; i < n; ++i) {
                    int upper = this.decode(chars[i * 2]);
                    int lower = this.decode(chars[i * 2 + 1]);
                    bytes[i] = (byte)(upper << 4 | lower);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new LocalizedIllegalArgumentException((Serializable)((Object)zahl), "number", ex);
            }
            return bytes;
        }

        private final int decode(char x) {
            int n;
            char c = x;
            if (c == '0') {
                n = 0;
            } else if (c == '1') {
                n = 1;
            } else if (c == '2') {
                n = 2;
            } else if (c == '3') {
                n = 3;
            } else if (c == '4') {
                n = 4;
            } else if (c == '5') {
                n = 5;
            } else if (c == '6') {
                n = 6;
            } else if (c == '7') {
                n = 7;
            } else if (c == '8') {
                n = 8;
            } else if (c == '9') {
                n = 9;
            } else if (c == '/') {
                n = 10;
            } else if (c == '\t' ? true : c == ' ') {
                n = 11;
            } else if (c == '+') {
                n = 12;
            } else if (c == '-') {
                n = 13;
            } else if (c == '.') {
                n = 14;
            } else if (c == ',') {
                n = 15;
            } else {
                throw new LocalizedIllegalArgumentException(Character.valueOf(x), "number", null, 4, null);
            }
            return n;
        }

        private final char encode(int nibble) {
            char c;
            switch (0xF & nibble) {
                case 0: {
                    c = '0';
                    break;
                }
                case 1: {
                    c = '1';
                    break;
                }
                case 2: {
                    c = '2';
                    break;
                }
                case 3: {
                    c = '3';
                    break;
                }
                case 4: {
                    c = '4';
                    break;
                }
                case 5: {
                    c = '5';
                    break;
                }
                case 6: {
                    c = '6';
                    break;
                }
                case 7: {
                    c = '7';
                    break;
                }
                case 8: {
                    c = '8';
                    break;
                }
                case 9: {
                    c = '9';
                    break;
                }
                case 10: {
                    c = '/';
                    break;
                }
                case 11: {
                    c = ' ';
                    break;
                }
                case 12: {
                    c = '+';
                    break;
                }
                case 13: {
                    c = '-';
                    break;
                }
                case 14: {
                    c = '.';
                    break;
                }
                case 15: {
                    c = ',';
                    break;
                }
                default: {
                    throw new IllegalStateException("internal error");
                }
            }
            return c;
        }

        private static final PackedDecimal valueOf$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (PackedDecimal)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

