/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.math;

import de.jfachwert.KFachwert;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001f2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0001\u001fB\u000f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\t\u001a\u00020\n2\b\u0010\b\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\u0005H\u0016J\t\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/jfachwert/math/Primzahl;", "", "Lde/jfachwert/KFachwert;", "", "value", "", "(I)V", "compareTo", "other", "equals", "", "", "hashCode", "next", "toBigInteger", "Ljava/math/BigInteger;", "toByte", "", "toChar", "", "toDouble", "", "toFloat", "", "toInt", "toLong", "", "toShort", "", "toString", "", "Companion", "jfachwert"})
public class Primzahl
extends Number
implements KFachwert,
Comparable<Primzahl> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int value;
    @JvmField
    @NotNull
    public static final Primzahl ZWEI = new Primzahl(2);
    @JvmField
    @NotNull
    public static final Primzahl DREI = new Primzahl(3);
    @NotNull
    private static SoftReference<List<Primzahl>> refPrimzahlen = new SoftReference<List>(de.jfachwert.math.Primzahl$Companion.access$initPrimzahlen(Companion));

    private Primzahl(int value) {
        this.value = value;
    }

    public long toLong() {
        return this.value;
    }

    public int toInt() {
        return this.value;
    }

    public float toFloat() {
        return this.toBigInteger().floatValue();
    }

    public double toDouble() {
        return this.toBigInteger().doubleValue();
    }

    public short toShort() {
        return this.toBigInteger().shortValue();
    }

    public byte toByte() {
        return this.toBigInteger().byteValue();
    }

    public char toChar() {
        return this.toBigInteger().toChar();
    }

    @NotNull
    public final BigInteger toBigInteger() {
        BigInteger bigInteger = BigInteger.valueOf(this.longValue());
        Intrinsics.checkNotNullExpressionValue(bigInteger, "valueOf(toLong())");
        return bigInteger;
    }

    @NotNull
    public final Primzahl next() {
        return Companion.after(this.intValue());
    }

    @Override
    public int compareTo(@NotNull Primzahl other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.value - other.value;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        Primzahl primzahl = (Primzahl)other;
        return this.value == primzahl.value;
    }

    public int hashCode() {
        return this.value;
    }

    @NotNull
    public String toString() {
        String string = Integer.toString(this.value);
        Intrinsics.checkNotNullExpressionValue(string, "toString(value)");
        return string;
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap(this);
    }

    @JvmStatic
    @NotNull
    public static final Primzahl after(int zahl) {
        return Companion.after(zahl);
    }

    public /* synthetic */ Primzahl(int value, DefaultConstructorMarker $constructor_marker) {
        this(value);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0006\u0010\u0010\u001a\u00020\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR(\u0010\n\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004 \f*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00070\u00070\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/jfachwert/math/Primzahl$Companion;", "", "()V", "DREI", "Lde/jfachwert/math/Primzahl;", "ZWEI", "primzahlen", "", "getPrimzahlen", "()Ljava/util/List;", "refPrimzahlen", "Ljava/lang/ref/SoftReference;", "kotlin.jvm.PlatformType", "after", "zahl", "", "first", "hasTeiler", "", "n", "initPrimzahlen", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Primzahl> initPrimzahlen() {
            List primzahlen = new CopyOnWriteArrayList();
            primzahlen.add(DREI);
            return primzahlen;
        }

        @NotNull
        public final Primzahl first() {
            return ZWEI;
        }

        @JvmStatic
        @NotNull
        public final Primzahl after(int zahl) {
            List<Primzahl> primzahlen;
            List<Primzahl> list = primzahlen = this.getPrimzahlen();
            Intrinsics.checkNotNull(list);
            for (Primzahl p : list) {
                if (zahl >= p.intValue()) continue;
                return p;
            }
            Companion $this$after_u24lambda_u240 = this;
            boolean bl = false;
            for (int n = primzahlen.get(primzahlen.size() - 1).intValue() + 2; n <= zahl; n += 2) {
                if ($this$after_u24lambda_u240.hasTeiler(n)) continue;
                primzahlen.add(new Primzahl(n, null));
            }
            int n = primzahlen.get(primzahlen.size() - 1).intValue() + 2;
            while (this.hasTeiler(n)) {
                n += 2;
            }
            Primzahl nextPrimzahl = new Primzahl(n, null);
            primzahlen.add(nextPrimzahl);
            return nextPrimzahl;
        }

        private final boolean hasTeiler(int n) {
            List<Primzahl> list = this.getPrimzahlen();
            Intrinsics.checkNotNull(list);
            for (Primzahl p : list) {
                int teiler = p.intValue();
                if (n % teiler == 0) {
                    return true;
                }
                if (teiler * teiler <= n) continue;
                break;
            }
            return false;
        }

        private final List<Primzahl> getPrimzahlen() {
            List<Primzahl> primzahlen = (List<Primzahl>)refPrimzahlen.get();
            if (primzahlen == null) {
                primzahlen = this.initPrimzahlen();
                refPrimzahlen = new SoftReference<List<Primzahl>>(primzahlen);
            }
            return primzahlen;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ List access$initPrimzahlen(Companion $this) {
            return $this.initPrimzahlen();
        }
    }
}

