/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.math;

import de.jfachwert.math.Promille;
import de.jfachwert.math.Prozent;
import java.math.BigDecimal;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016\u00a8\u0006\f"}, d2={"Lde/jfachwert/math/Promille;", "Lde/jfachwert/math/Prozent;", "wert", "", "(Ljava/lang/String;)V", "", "(J)V", "Ljava/math/BigDecimal;", "(Ljava/math/BigDecimal;)V", "toBigDecimal", "toString", "Companion", "jfachwert"})
public class Promille
extends Prozent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final WeakHashMap<BigDecimal, Promille> WEAK_CACHE = new WeakHashMap();
    private static final char PROMILLE_ZEICHEN = '\u2030';
    @JvmField
    @NotNull
    public static final Promille ZERO;
    @JvmField
    @NotNull
    public static final Promille ONE;
    @JvmField
    @NotNull
    public static final Promille TEN;

    public Promille(@NotNull String wert) {
        Intrinsics.checkNotNullParameter(wert, "wert");
        this(Promille.Companion.toNumber(wert));
    }

    public Promille(long wert) {
        super(wert);
    }

    public Promille(@NotNull BigDecimal wert) {
        Intrinsics.checkNotNullParameter(wert, "wert");
        super(wert);
    }

    @Override
    @NotNull
    public BigDecimal toBigDecimal() {
        BigDecimal bigDecimal = this.getWert().divide(BigDecimal.valueOf(1000L));
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "wert.divide(BigDecimal.valueOf(1000))");
        return bigDecimal;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getWert().toString() + Character.toString('\u2030');
    }

    @JvmStatic
    @NotNull
    public static final Promille of(@NotNull String wert) {
        return Companion.of(wert);
    }

    @JvmStatic
    @NotNull
    public static final Promille of(long wert) {
        return Companion.of(wert);
    }

    @JvmStatic
    @NotNull
    public static final Promille of(@NotNull BigDecimal wert) {
        return Companion.of(wert);
    }

    static {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Intrinsics.checkNotNullExpressionValue(bigDecimal, "ZERO");
        ZERO = Companion.of(bigDecimal);
        BigDecimal bigDecimal2 = BigDecimal.ONE;
        Intrinsics.checkNotNullExpressionValue(bigDecimal2, "ONE");
        ONE = Companion.of(bigDecimal2);
        BigDecimal bigDecimal3 = BigDecimal.TEN;
        Intrinsics.checkNotNullExpressionValue(bigDecimal3, "TEN");
        TEN = Companion.of(bigDecimal3);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\nH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/jfachwert/math/Promille$Companion;", "", "()V", "ONE", "Lde/jfachwert/math/Promille;", "PROMILLE_ZEICHEN", "", "TEN", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Ljava/math/BigDecimal;", "ZERO", "of", "wert", "", "", "toNumber", "s", "jfachwert"})
    @SourceDebugExtension(value={"SMAP\nPromille.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Promille.kt\nde/jfachwert/math/Promille$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,135:1\n107#2:136\n79#2,22:137\n*S KotlinDebug\n*F\n+ 1 Promille.kt\nde/jfachwert/math/Promille$Companion\n*L\n103#1:136\n103#1:137,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Promille of(@NotNull String wert) {
            Intrinsics.checkNotNullParameter(wert, "wert");
            return this.of(this.toNumber(wert));
        }

        private final BigDecimal toNumber(String s) {
            String string = StringUtils.replaceChars(s, "\u00b0/o\u2030", "");
            Intrinsics.checkNotNullExpressionValue(string, "replaceChars(s, \"\u00b0/o$PROMILLE_ZEICHEN\", \"\")");
            String $this$trim$iv = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String number = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            return new BigDecimal(number);
        }

        @JvmStatic
        @NotNull
        public final Promille of(long wert) {
            BigDecimal bigDecimal = BigDecimal.valueOf(wert);
            Intrinsics.checkNotNullExpressionValue(bigDecimal, "valueOf(wert)");
            return this.of(bigDecimal);
        }

        @JvmStatic
        @NotNull
        public final Promille of(@NotNull BigDecimal wert) {
            Intrinsics.checkNotNullParameter(wert, "wert");
            Promille promille = WEAK_CACHE.computeIfAbsent(wert, arg_0 -> Companion.of$lambda$1(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue(promille, "WEAK_CACHE.computeIfAbse\u2026gDecimal -> Promille(w) }");
            return promille;
        }

        private static final Promille of$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Promille)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

