/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.med;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.med.LANR;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.Mod10Verfahren;
import de.jfachwert.pruefung.NullValidator;
import java.util.Arrays;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0016\u0018\u0000 \u00152\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0015B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0004H\u0016R\u0011\u0010\t\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lde/jfachwert/med/LANR;", "Lde/jfachwert/AbstractFachwert;", "", "code", "", "(Ljava/lang/String;)V", "validator", "Lde/jfachwert/KSimpleValidator;", "(ILde/jfachwert/KSimpleValidator;)V", "arztnummer", "getArztnummer", "()I", "fachgruppe", "getFachgruppe", "isPseudoNummer", "", "()Z", "isValid", "pruefziffer", "getPruefziffer", "toString", "Companion", "jfachwert"})
public class LANR
extends AbstractFachwert<Integer, LANR> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LengthValidator<Integer> VALIDATOR = new LengthValidator(4, 9);
    @NotNull
    private static final WeakHashMap<Integer, LANR> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final LANR NULL = new LANR(0, new NullValidator());
    @JvmField
    @NotNull
    public static final LANR PSEUDO_NUMMER = Companion.of(999999900);

    @JvmOverloads
    public LANR(int code, @NotNull KSimpleValidator<Integer> validator) {
        Intrinsics.checkNotNullParameter(validator, "validator");
        super(code, validator);
    }

    public /* synthetic */ LANR(int n, KSimpleValidator kSimpleValidator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(n, kSimpleValidator);
    }

    public LANR(@NotNull String code) {
        Intrinsics.checkNotNullParameter(code, "code");
        this(Integer.parseInt(code), null, 2, null);
    }

    public final int getArztnummer() {
        return ((Number)this.getCode()).intValue() / 100;
    }

    public final int getPruefziffer() {
        return ((Number)this.getCode()).intValue() / 100 % 10;
    }

    public final boolean isValid() {
        Mod10Verfahren mod10Verfahren = new Mod10Verfahren(4, 9);
        String string = Integer.toString(this.getArztnummer());
        Intrinsics.checkNotNullExpressionValue(string, "toString(arztnummer)");
        return mod10Verfahren.isValid(string);
    }

    public final int getFachgruppe() {
        return ((Number)this.getCode()).intValue() % 100;
    }

    public final boolean isPseudoNummer() {
        boolean bl;
        int arztNr = this.getArztnummer();
        switch (arztNr) {
            case 3333333: 
            case 4444444: 
            case 9999999: {
                bl = true;
                break;
            }
            default: {
                bl = arztNr / 10 == 555555;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public String toString() {
        String string = "%09d";
        Object[] objectArray = new Object[]{this.getCode()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        return string2;
    }

    @JvmOverloads
    public LANR(int code) {
        this(code, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final LANR of(int code) {
        return Companion.of(code);
    }

    @JvmStatic
    @NotNull
    public static final LANR of(@NotNull String code) {
        return Companion.of(code);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\bH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/jfachwert/med/LANR$Companion;", "", "()V", "NULL", "Lde/jfachwert/med/LANR;", "PSEUDO_NUMMER", "VALIDATOR", "Lde/jfachwert/pruefung/LengthValidator;", "", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "of", "code", "", "validate", "nummer", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LANR of(int code) {
            LANR lANR = WEAK_CACHE.computeIfAbsent(code, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue(lANR, "WEAK_CACHE.computeIfAbse\u2026de) { n: Int -> LANR(n) }");
            return lANR;
        }

        @JvmStatic
        @NotNull
        public final LANR of(@NotNull String code) {
            Intrinsics.checkNotNullParameter(code, "code");
            return this.of(Integer.parseInt(code));
        }

        public final int validate(int nummer) {
            return ((Number)VALIDATOR.validate(nummer)).intValue();
        }

        private static final LANR of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (LANR)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

