/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.net;

import de.jfachwert.KSimpleValidator;
import de.jfachwert.Text;
import de.jfachwert.net.Telefonnummer;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0016\u0018\u0000  2\u00020\u0001:\u0002 !B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u0006J\u0006\u0010\u001d\u001a\u00020\u0006J\u0006\u0010\u001e\u001a\u00020\u0006J\u0006\u0010\u001f\u001a\u00020\u0003R\u0011\u0010\n\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lde/jfachwert/net/Telefonnummer;", "Lde/jfachwert/Text;", "uri", "Ljava/net/URI;", "(Ljava/net/URI;)V", "nummer", "", "validator", "Lde/jfachwert/KSimpleValidator;", "(Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "inlandsnummer", "getInlandsnummer", "()Lde/jfachwert/net/Telefonnummer;", "laenderkennzahl", "Ljava/util/Optional;", "getLaenderkennzahl", "()Ljava/util/Optional;", "rufnummer", "getRufnummer", "vorwahl", "getVorwahl", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toDinString", "toE123String", "toShortString", "toURI", "Companion", "Validator", "jfachwert"})
@SourceDebugExtension(value={"SMAP\nTelefonnummer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Telefonnummer.kt\nde/jfachwert/net/Telefonnummer\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,290:1\n107#2:291\n79#2,22:292\n107#2:314\n79#2,22:315\n37#3,2:337\n*S KotlinDebug\n*F\n+ 1 Telefonnummer.kt\nde/jfachwert/net/Telefonnummer\n*L\n85#1:291\n85#1:292,22\n125#1:314\n125#1:315,22\n125#1:337,2\n*E\n"})
public class Telefonnummer
extends Text {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new Validator();
    @NotNull
    private static final WeakHashMap<String, Telefonnummer> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Telefonnummer NULL = new Telefonnummer("", new NullValidator());

    @JvmOverloads
    public Telefonnummer(@NotNull String nummer, @NotNull KSimpleValidator<String> validator) {
        Intrinsics.checkNotNullParameter(nummer, "nummer");
        Intrinsics.checkNotNullParameter(validator, "validator");
        super(Telefonnummer.Companion.normalize(nummer), validator);
    }

    public /* synthetic */ Telefonnummer(String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(string, kSimpleValidator);
    }

    public Telefonnummer(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter(uri, "uri");
        String string = uri.getSchemeSpecificPart();
        Intrinsics.checkNotNullExpressionValue(string, "uri.schemeSpecificPart");
        this(string, null, 2, null);
    }

    @NotNull
    public final Telefonnummer getInlandsnummer() {
        Telefonnummer telefonnummer;
        if (this.getLaenderkennzahl().isPresent()) {
            CharSequence[] charSequenceArray;
            String nummer;
            String string = ((String)this.getCode()).substring(3);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            String $this$trim$iv = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringUtils.startsWithAny(nummer = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), charSequenceArray = new CharSequence[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"})) {
                nummer = '0' + nummer;
            }
            telefonnummer = new Telefonnummer(nummer, null, 2, null);
        } else {
            telefonnummer = this;
        }
        return telefonnummer;
    }

    @NotNull
    public final Optional<String> getLaenderkennzahl() {
        Optional<String> optional;
        if (StringsKt.startsWith$default((String)this.getCode(), "+", false, 2, null)) {
            String string = ((String)this.getCode()).substring(0, 3);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            Optional<String> optional2 = Optional.of(string);
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, "{\n                Option\u2026ring(0, 3))\n            }");
        } else if (StringsKt.startsWith$default((String)this.getCode(), "00", false, 2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append('+');
            String string = ((String)this.getCode()).substring(2, 4);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            Optional<String> optional3 = Optional.of(stringBuilder.append(string).toString());
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, "{\n                Option\u2026ring(2, 4))\n            }");
        } else if (StringsKt.contains$default((CharSequence)this.getCode(), "(0)", false, 2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append('+');
            String string = ((String)this.getCode()).substring(0, 2);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            Optional<String> optional4 = Optional.of(stringBuilder.append(string).toString());
            optional = optional4;
            Intrinsics.checkNotNullExpressionValue(optional4, "{\n                Option\u2026ring(0, 2))\n            }");
        } else {
            Optional optional5 = Optional.empty();
            optional = optional5;
            Intrinsics.checkNotNullExpressionValue(optional5, "{\n                Optional.empty()\n            }");
        }
        return optional;
    }

    @NotNull
    public final String getVorwahl() {
        CharSequence $this$trim$iv = (String)this.getCode();
        boolean $i$f$trim22 = false;
        CharSequence $this$trim$iv$iv22 = $this$trim$iv;
        boolean $i$f$trim = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv22.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv22.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        $this$trim$iv = ((Object)$this$trim$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        Regex $i$f$trim22 = new Regex("[ /-]|(\\(0\\))");
        int $this$trim$iv$iv22 = 0;
        Collection $this$toTypedArray$iv = $i$f$trim22.split($this$trim$iv, $this$trim$iv$iv22);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        String vorwahl = parts[0];
        if (StringsKt.startsWith$default(vorwahl, "+", false, 2, null)) {
            vorwahl = StringUtils.isBlank(parts[1]) ? parts[2] : parts[1];
        }
        String string = RegExUtils.removeAll(vorwahl, "[ \t+-/(\\(\\))]");
        Intrinsics.checkNotNullExpressionValue(string, "removeAll(vorwahl, \"[ \\t+-/(\\\\(\\\\))]\")");
        vorwahl = string;
        return StringsKt.startsWith$default(vorwahl, "0", false, 2, null) ? vorwahl : '0' + vorwahl;
    }

    @NotNull
    public final Telefonnummer getRufnummer() {
        String inlandsnummer = RegExUtils.replaceAll(this.getInlandsnummer().toString(), "[ /]+", " ");
        String string = StringUtils.substringAfter(inlandsnummer, " ");
        Intrinsics.checkNotNullExpressionValue(string, "substringAfter(inlandsnummer, \" \")");
        CharSequence charSequence = string;
        Regex regex = new Regex(" ");
        String string2 = "";
        return new Telefonnummer(regex.replace(charSequence, string2), null, 2, null);
    }

    @Override
    public int hashCode() {
        return this.toShortString().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Telefonnummer)) {
            return false;
        }
        return Intrinsics.areEqual(this.toShortString(), ((Telefonnummer)other).toShortString());
    }

    @NotNull
    public final String toShortString() {
        String string = RegExUtils.removeAll((String)this.getCode(), "[ \t+-/]|(\\(0\\))");
        Intrinsics.checkNotNullExpressionValue(string, "removeAll(code, \"[ \\t+-/]|(\\\\(0\\\\))\")");
        return string;
    }

    @NotNull
    public final String toDinString() {
        Optional<String> laenderkennzahl = this.getLaenderkennzahl();
        String string = laenderkennzahl.map(arg_0 -> Telefonnummer.toDinString$lambda$2(new Function1<String, String>(this){
            final /* synthetic */ Telefonnummer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final String invoke(@NotNull String s) {
                Intrinsics.checkNotNullParameter(s, "s");
                StringBuilder stringBuilder = new StringBuilder().append(s).append(' ');
                String string = this.this$0.getVorwahl().substring(1);
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                return stringBuilder.append(string).append(' ').append(this.this$0.getRufnummer()).toString();
            }
        }, arg_0)).orElseGet(() -> Telefonnummer.toDinString$lambda$3(this));
        Intrinsics.checkNotNullExpressionValue(string, "fun toDinString(): Strin\u2026rwahl $rufnummer\" }\n    }");
        return string;
    }

    @NotNull
    public final String toE123String() {
        return this.getLaenderkennzahl().isPresent() ? StringsKt.replace$default(this.toDinString(), '-', ' ', false, 4, null) : '(' + this.getVorwahl() + ") " + StringsKt.replace$default(this.getRufnummer().toString(), '-', ' ', false, 4, null);
    }

    @NotNull
    public final URI toURI() {
        URI uRI = URI.create("tel:" + StringsKt.replace$default(this.toDinString(), ' ', '-', false, 4, null));
        Intrinsics.checkNotNullExpressionValue(uRI, "create(\"tel:\" + toDinString().replace(' ', '-'))");
        return uRI;
    }

    @JvmOverloads
    public Telefonnummer(@NotNull String nummer) {
        Intrinsics.checkNotNullParameter(nummer, "nummer");
        this(nummer, null, 2, null);
    }

    private static final String toDinString$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String toDinString$lambda$3(Telefonnummer this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.getVorwahl() + ' ' + this$0.getRufnummer();
    }

    @JvmStatic
    @NotNull
    public static final Telefonnummer of(@NotNull String nummer) {
        return Companion.of(nummer);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0007H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/jfachwert/net/Telefonnummer$Companion;", "", "()V", "NULL", "Lde/jfachwert/net/Telefonnummer;", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "normalize", "nummer", "of", "jfachwert"})
    @SourceDebugExtension(value={"SMAP\nTelefonnummer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Telefonnummer.kt\nde/jfachwert/net/Telefonnummer$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,290:1\n107#2:291\n79#2,22:292\n*S KotlinDebug\n*F\n+ 1 Telefonnummer.kt\nde/jfachwert/net/Telefonnummer$Companion\n*L\n282#1:291\n282#1:292,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Telefonnummer of(@NotNull String nummer) {
            Intrinsics.checkNotNullParameter(nummer, "nummer");
            Telefonnummer telefonnummer = WEAK_CACHE.computeIfAbsent(nummer, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue(telefonnummer, "WEAK_CACHE.computeIfAbse\u2026ing -> Telefonnummer(n) }");
            return telefonnummer;
        }

        private final String normalize(String nummer) {
            String normalized;
            String $this$trim$iv = nummer;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringsKt.startsWith$default(normalized = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), "(0)", false, 2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append('0');
                String string = normalized.substring(3);
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
                normalized = stringBuilder.append(string).toString();
            }
            return normalized;
        }

        private static final Telefonnummer of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Telefonnummer)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/jfachwert/net/Telefonnummer$Validator;", "Lde/jfachwert/KSimpleValidator;", "", "()V", "pattern", "Ljava/util/regex/Pattern;", "(Ljava/util/regex/Pattern;)V", "lengthValidator", "Lde/jfachwert/pruefung/LengthValidator;", "validate", "value", "jfachwert"})
    public static final class Validator
    implements KSimpleValidator<String> {
        @NotNull
        private final Pattern pattern;
        @NotNull
        private final LengthValidator<String> lengthValidator;

        public Validator(@NotNull Pattern pattern) {
            Intrinsics.checkNotNullParameter(pattern, "pattern");
            this.pattern = pattern;
            this.lengthValidator = new LengthValidator(3, 15);
        }

        public Validator() {
            Pattern pattern = Pattern.compile("[0-9-+/ ()]+");
            Intrinsics.checkNotNullExpressionValue(pattern, "compile(\"[0-9-+/ ()]+\")");
            this(pattern);
        }

        @Override
        @NotNull
        public String validate(@NotNull String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            Matcher matcher = this.pattern.matcher(value);
            if (matcher.matches()) {
                String normalized = RegExUtils.removeAll(value, "[ \t+-/]|(\\(0\\))");
                Intrinsics.checkNotNullExpressionValue(normalized, "normalized");
                this.lengthValidator.validate((String)((Object)((Serializable)((Object)normalized))));
                return value;
            }
            throw new InvalidValueException((Serializable)((Object)value), "phone_number");
        }

        @Override
        @Nullable
        public Object validateObject(@NotNull Object value) {
            return KSimpleValidator.DefaultImpls.validateObject(this, value);
        }

        @Override
        @NotNull
        public String verify(@NotNull String value) {
            return (String)((Object)KSimpleValidator.DefaultImpls.verify(this, (Serializable)((Object)value)));
        }
    }
}

