/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.jfachwert.KFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.Text;
import de.jfachwert.post.Ort;
import de.jfachwert.post.PLZ;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import de.jfachwert.pruefung.exception.ValidationException;
import de.jfachwert.util.ToFachwertSerializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToFachwertSerializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\b\u0017\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\b\u0017\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\tB/\b\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0000J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0000H\u0002J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0000H\u0002J\u0006\u0010%\u001a\u00020\u0003J\u0006\u0010&\u001a\u00020\u0003J\b\u0010'\u001a\u00020(H\u0016J\u0014\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020!0\bH\u0016J\u0006\u0010*\u001a\u00020\u0003J\b\u0010+\u001a\u00020\u0003H\u0016R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013\u00a8\u0006-"}, d2={"Lde/jfachwert/post/Adresse;", "Lde/jfachwert/KFachwert;", "adresse", "", "(Ljava/lang/String;)V", "", "([Ljava/lang/String;)V", "map", "", "(Ljava/util/Map;)V", "ort", "Lde/jfachwert/post/Ort;", "strasse", "hausnummer", "validator", "Lde/jfachwert/KSimpleValidator;", "(Lde/jfachwert/post/Ort;Ljava/lang/String;Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "hausnummerKurz", "getHausnummerKurz", "()Ljava/lang/String;", "getOrt", "()Lde/jfachwert/post/Ort;", "ortsname", "getOrtsname", "pLZ", "Lde/jfachwert/post/PLZ;", "getPLZ", "()Lde/jfachwert/post/PLZ;", "strasseKurz", "getStrasseKurz", "equals", "", "other", "", "equalsExact", "equalsHausnummer", "equalsStrasse", "getHausnummer", "getStrasse", "hashCode", "", "toMap", "toShortString", "toString", "Companion", "jfachwert"})
public class Adresse
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ort ort;
    @NotNull
    private final String strasse;
    @NotNull
    private final String hausnummer;
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new LengthValidator(1, 0, 2, null);
    private static final Logger LOG = Logger.getLogger(Adresse.class.getName());
    private static final Pattern PATTERN_STRASSE = Pattern.compile(".*(?i)tra(ss|[\u00dfe])e$");
    @JvmField
    @NotNull
    public static final Adresse NULL = new Adresse(Ort.NULL, "", "", new NullValidator());

    @JvmOverloads
    public Adresse(@NotNull Ort ort, @NotNull String strasse, @NotNull String hausnummer, @NotNull KSimpleValidator<String> validator) {
        Intrinsics.checkNotNullParameter(ort, "ort");
        Intrinsics.checkNotNullParameter(strasse, "strasse");
        Intrinsics.checkNotNullParameter(hausnummer, "hausnummer");
        Intrinsics.checkNotNullParameter(validator, "validator");
        this.ort = ort;
        this.strasse = strasse;
        this.hausnummer = hausnummer;
        Adresse.Companion.verify(this.ort, this.strasse, this.hausnummer, validator);
    }

    public /* synthetic */ Adresse(Ort ort, String string, String string2, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(ort, string, string2, kSimpleValidator);
    }

    @NotNull
    public final Ort getOrt() {
        return this.ort;
    }

    public Adresse(@NotNull String adresse) {
        Intrinsics.checkNotNullParameter(adresse, "adresse");
        this(Adresse.Companion.split(adresse));
    }

    private Adresse(String[] adresse) {
        this(new Ort(adresse[0]), adresse[1], adresse[2], null, 8, null);
    }

    @JsonCreator
    public Adresse(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, "map");
        String string = map.get("plz");
        Intrinsics.checkNotNull(string);
        PLZ pLZ = PLZ.Companion.of(string);
        String string2 = map.get("ortsname");
        Intrinsics.checkNotNull(string2);
        Ort ort = new Ort(pLZ, string2, null, 4, null);
        String string3 = map.get("strasse");
        Intrinsics.checkNotNull(string3);
        String string4 = map.get("hausnummer");
        Intrinsics.checkNotNull(string4);
        this(ort, string3, string4, null, 8, null);
    }

    @NotNull
    public final String getOrtsname() {
        return this.ort.getName();
    }

    @NotNull
    public final PLZ getPLZ() {
        PLZ pLZ = this.ort.getPLZ().get();
        Intrinsics.checkNotNullExpressionValue(pLZ, "ort.pLZ.get()");
        return pLZ;
    }

    @NotNull
    public final String getStrasse() {
        return this.strasse;
    }

    @NotNull
    public final String getStrasseKurz() {
        String string;
        if (PATTERN_STRASSE.matcher(this.strasse).matches()) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = this.strasse.substring(0, StringUtils.lastIndexOfIgnoreCase(this.strasse, "stra") + 3);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = stringBuilder.append(string2).append('.').toString();
        } else {
            string = this.strasse;
        }
        return string;
    }

    @NotNull
    public final String getHausnummer() {
        return this.hausnummer;
    }

    @NotNull
    public final String getHausnummerKurz() {
        String string = StringUtils.deleteWhitespace(this.hausnummer);
        Intrinsics.checkNotNullExpressionValue(string, "deleteWhitespace(hausnummer)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Adresse)) {
            return false;
        }
        return this.ort.equals(((Adresse)other).ort) && this.equalsStrasse((Adresse)other) && this.equalsHausnummer((Adresse)other);
    }

    private final boolean equalsStrasse(Adresse other) {
        return StringsKt.equals(Adresse.Companion.normalizeStrasse(this), Adresse.Companion.normalizeStrasse(other), true);
    }

    private final boolean equalsHausnummer(Adresse other) {
        String[] otherNr;
        String[] thisNr = Adresse.Companion.normalizeHausnummer(this.getHausnummer());
        return Intrinsics.areEqual(thisNr[0], (otherNr = Adresse.Companion.normalizeHausnummer(other.getHausnummer()))[0]) || Intrinsics.areEqual(thisNr[1], otherNr[0]) || Intrinsics.areEqual(thisNr[0], otherNr[1]) || Intrinsics.areEqual(thisNr[1], otherNr[1]);
    }

    public final boolean equalsExact(@NotNull Adresse other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.ort.equalsExact(other.ort) && Intrinsics.areEqual(this.strasse, other.strasse) && StringsKt.equals(this.hausnummer, other.hausnummer, true);
    }

    public int hashCode() {
        String string = Adresse.Companion.normalizeStrasse(this).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string.hashCode();
    }

    @NotNull
    public String toString() {
        return this.ort + ", " + this.getStrasse() + ' ' + this.getHausnummer();
    }

    @NotNull
    public final String toShortString() {
        return this.ort + ", " + this.getStrasseKurz() + ' ' + this.getHausnummerKurz();
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Map map = new HashMap();
        map.put("plz", this.getPLZ());
        map.put("ortsname", this.getOrtsname());
        map.put("strasse", this.getStrasse());
        map.put("hausnummer", this.getHausnummer());
        return map;
    }

    @JvmOverloads
    public Adresse(@NotNull Ort ort, @NotNull String strasse, @NotNull String hausnummer) {
        Intrinsics.checkNotNullParameter(ort, "ort");
        Intrinsics.checkNotNullParameter(strasse, "strasse");
        Intrinsics.checkNotNullParameter(hausnummer, "hausnummer");
        this(ort, strasse, hausnummer, null, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final Adresse of(@NotNull String adresse) {
        return Companion.of(adresse);
    }

    @JvmStatic
    @NotNull
    public static final Adresse of(@NotNull Ort ort, @NotNull String strasse) {
        return Companion.of(ort, strasse);
    }

    @JvmStatic
    @NotNull
    public static final Adresse of(@NotNull Ort ort, @NotNull String strasse, @NotNull String hausnummer) {
        return Companion.of(ort, strasse, hausnummer);
    }

    @JvmStatic
    @NotNull
    public static final Adresse of(@NotNull Ort ort, @NotNull String strasse, int hausnummer) {
        return Companion.of(ort, strasse, hausnummer);
    }

    @JvmStatic
    public static final void validate(@NotNull String adresse) {
        Companion.validate(adresse);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0007J \u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J \u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fH\u0007J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\fH\u0007J\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u001c\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u001e\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\fJ.\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\fH\u0007J.\u0010#\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/jfachwert/post/Adresse$Companion;", "", "()V", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "NULL", "Lde/jfachwert/post/Adresse;", "PATTERN_STRASSE", "Ljava/util/regex/Pattern;", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "hasPLZ", "", "line", "normalizeHausnummer", "", "nr", "(Ljava/lang/String;)[Ljava/lang/String;", "normalizeStrasse", "adr", "of", "ort", "Lde/jfachwert/post/Ort;", "strasse", "hausnummer", "", "adresse", "split", "toStrasseHausnummer", "", "validate", "", "validator", "verify", "jfachwert"})
    @SourceDebugExtension(value={"SMAP\nAdresse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Adresse.kt\nde/jfachwert/post/Adresse$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,391:1\n107#2:392\n79#2,29:393\n107#2:424\n79#2,22:425\n107#2:447\n79#2,22:448\n107#2:472\n79#2,22:473\n107#2:495\n79#2,29:496\n37#3,2:422\n37#3,2:470\n37#3,2:525\n*S KotlinDebug\n*F\n+ 1 Adresse.kt\nde/jfachwert/post/Adresse$Companion\n*L\n313#1:392\n313#1:393,29\n343#1:424\n343#1:425,22\n346#1:447\n346#1:448,22\n365#1:472\n365#1:473,22\n367#1:495\n367#1:496,29\n337#1:422,2\n349#1:470,2\n377#1:525,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Adresse of(@NotNull String adresse) {
            Intrinsics.checkNotNullParameter(adresse, "adresse");
            return new Adresse(adresse);
        }

        @JvmStatic
        @NotNull
        public final Adresse of(@NotNull Ort ort, @NotNull String strasse) {
            Intrinsics.checkNotNullParameter(ort, "ort");
            Intrinsics.checkNotNullParameter(strasse, "strasse");
            List<String> splitted = this.toStrasseHausnummer(strasse);
            return this.of(ort, splitted.get(0), splitted.get(1));
        }

        @JvmStatic
        @NotNull
        public final Adresse of(@NotNull Ort ort, @NotNull String strasse, @NotNull String hausnummer) {
            Intrinsics.checkNotNullParameter(ort, "ort");
            Intrinsics.checkNotNullParameter(strasse, "strasse");
            Intrinsics.checkNotNullParameter(hausnummer, "hausnummer");
            return new Adresse(ort, strasse, hausnummer, null, 8, null);
        }

        @JvmStatic
        @NotNull
        public final Adresse of(@NotNull Ort ort, @NotNull String strasse, int hausnummer) {
            Intrinsics.checkNotNullParameter(ort, "ort");
            Intrinsics.checkNotNullParameter(strasse, "strasse");
            String string = Integer.toString(hausnummer);
            Intrinsics.checkNotNullExpressionValue(string, "toString(hausnummer)");
            return this.of(ort, strasse, string);
        }

        private final void verify(Ort ort, String strasse, String hausnummer, KSimpleValidator<String> validator) {
            try {
                this.validate(ort, strasse, hausnummer, validator);
            }
            catch (ValidationException ex) {
                throw new LocalizedIllegalArgumentException(ex);
            }
        }

        public final void validate(@NotNull Ort ort, @NotNull String strasse, @NotNull String hausnummer) {
            Intrinsics.checkNotNullParameter(ort, "ort");
            Intrinsics.checkNotNullParameter(strasse, "strasse");
            Intrinsics.checkNotNullParameter(hausnummer, "hausnummer");
            if (StringUtils.isBlank(strasse)) {
                throw new InvalidValueException((Serializable)((Object)strasse), "street");
            }
            this.validate(ort, strasse, hausnummer, VALIDATOR);
        }

        private final void validate(Ort ort, String strasse, String hausnummer, KSimpleValidator<String> validator) {
            if (!ort.getPLZ().isPresent()) {
                throw new InvalidValueException(ort, "postal_code");
            }
            validator.validate((String)((Object)((Serializable)((Object)strasse))));
            if (StringUtils.isNotBlank(strasse) && StringUtils.isNotBlank(hausnummer)) {
                boolean match$iv$iv;
                char it;
                int index$iv$iv;
                String $this$trim$iv = strasse;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (Character.isDigit(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString().charAt(0))) {
                    $this$trim$iv = hausnummer;
                    $i$f$trim = false;
                    $this$trim$iv$iv = $this$trim$iv;
                    $i$f$trim2 = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    if (Character.isLetter(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString().charAt(0)) && strasse.length() < hausnummer.length()) {
                        throw new InvalidValueException((Serializable)((Object)(strasse + ' ' + hausnummer)), "values_exchanged");
                    }
                }
            }
        }

        @JvmStatic
        public final void validate(@NotNull String adresse) {
            Intrinsics.checkNotNullParameter(adresse, "adresse");
            String[] splitted = this.split(adresse);
            Ort ort = new Ort(splitted[0]);
            this.validate(ort, splitted[1], splitted[2]);
        }

        private final String[] split(String adresse) {
            CharSequence $this$trim$iv$iv;
            String $this$trim$iv;
            boolean $i$f$trim;
            String string = StringUtils.trimToEmpty(adresse);
            Intrinsics.checkNotNullExpressionValue(string, "trimToEmpty(adresse)");
            CharSequence charSequence = string;
            Regex regex = new Regex("[,\\n$]");
            int n = 0;
            Collection $this$toTypedArray$iv = regex.split(charSequence, n);
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] lines = thisCollection$iv.toArray(new String[0]);
            if (lines.length != 2) {
                throw new LocalizedIllegalArgumentException((Serializable)((Object)adresse), "address", null, 4, null);
            }
            List splitted = new ArrayList();
            if (this.hasPLZ(lines[0])) {
                String $i$f$toTypedArray2 = lines[0];
                List list = splitted;
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                list.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                splitted.addAll((Collection)this.toStrasseHausnummer(lines[1]));
            } else {
                $this$trim$iv = lines[1];
                List list = splitted;
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim3 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                list.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                splitted.addAll((Collection)this.toStrasseHausnummer(lines[0]));
            }
            Collection $this$toTypedArray$iv2 = splitted;
            boolean $i$f$toTypedArray3 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            return thisCollection$iv2.toArray(new String[0]);
        }

        private final boolean hasPLZ(String line) {
            boolean bl;
            try {
                Ort ort = new Ort(line);
                bl = ort.getPLZ().isPresent();
            }
            catch (ValidationException ex) {
                LOG.log(Level.FINE, "no PLZ inside '" + line + "' found:", ex);
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> toStrasseHausnummer(String line) {
            List<String> list;
            int indexNr = StringUtils.indexOfAny((CharSequence)line, "0123456789");
            if (indexNr <= 0) {
                String string;
                void $this$trim$iv;
                String[] stringArray = new String[2];
                String string2 = line;
                int n = 0;
                String[] stringArray2 = stringArray;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                stringArray2[n] = string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                stringArray[1] = "";
                List<String> list2 = Arrays.asList(stringArray);
                list = list2;
                Intrinsics.checkNotNullExpressionValue(list2, "{\n                Arrays\u2026 ' ' }, \"\")\n            }");
            } else {
                String string;
                boolean match$iv$iv;
                char it;
                int index$iv$iv;
                String[] stringArray = new String[2];
                String string3 = line.substring(0, indexNr);
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                String $this$trim$iv = string3;
                int n = 0;
                String[] stringArray3 = stringArray;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim3 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                stringArray3[n] = string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                String string4 = line.substring(indexNr);
                Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).substring(startIndex)");
                $this$trim$iv = string4;
                n = 1;
                stringArray3 = stringArray;
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim3 = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl4 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                stringArray3[n] = string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                List<String> list3 = Arrays.asList(stringArray);
                list = list3;
                Intrinsics.checkNotNullExpressionValue(list3, "{\n                Arrays\u2026t <= ' ' })\n            }");
            }
            return list;
        }

        private final String normalizeStrasse(Adresse adr) {
            String string = RegExUtils.removeAll(adr.getStrasseKurz(), "[\\s\\p{Punct}]");
            Intrinsics.checkNotNullExpressionValue(string, "removeAll(adr.strasseKurz, \"[\\\\s\\\\p{Punct}]\")");
            return Text.Companion.replaceUmlaute(string);
        }

        private final String[] normalizeHausnummer(String nr) {
            String[] stringArray;
            CharSequence charSequence = nr;
            String[] stringArray2 = new Regex("[^\\d\\-]");
            String string = "";
            String vonBis = stringArray2.replace(charSequence, string);
            stringArray2 = new String[]{"-"};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)vonBis, stringArray2, false, 0, 6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] splitted = thisCollection$iv.toArray(new String[0]);
            switch (splitted.length) {
                case 0: {
                    String[] stringArray3 = new String[]{vonBis, vonBis};
                    stringArray = stringArray3;
                    break;
                }
                case 1: {
                    String[] stringArray4 = new String[]{splitted[0], splitted[0]};
                    stringArray = stringArray4;
                    break;
                }
                default: {
                    if (((CharSequence)splitted[1]).length() == 0) {
                        String[] stringArray5 = new String[]{splitted[0], splitted[0]};
                        return stringArray5;
                    }
                    stringArray = splitted;
                }
            }
            return stringArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

