/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.post;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.jfachwert.KFachwert;
import de.jfachwert.KSimpleValidator;
import de.jfachwert.Text;
import de.jfachwert.post.PLZ;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import de.jfachwert.pruefung.exception.ValidationException;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToStringSerializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0012\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007B)\b\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0000J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/jfachwert/post/Ort;", "Lde/jfachwert/KFachwert;", "name", "", "(Ljava/lang/String;)V", "values", "", "([Ljava/lang/String;)V", "plz", "Lde/jfachwert/post/PLZ;", "validator", "Lde/jfachwert/KSimpleValidator;", "(Lde/jfachwert/post/PLZ;Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "getName", "()Ljava/lang/String;", "pLZ", "Ljava/util/Optional;", "getPLZ", "()Ljava/util/Optional;", "equals", "", "other", "", "equalsExact", "hashCode", "", "toString", "Companion", "jfachwert"})
public class Ort
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PLZ plz;
    @NotNull
    private final String name;
    @NotNull
    private static final KSimpleValidator<String> VALIDATOR = new LengthValidator(1, 0, 2, null);
    private static final Logger LOG = Logger.getLogger(Ort.class.getName());
    @JvmField
    @NotNull
    public static final Ort NULL = new Ort(PLZ.NULL, "", new NullValidator());

    @JvmOverloads
    public Ort(@Nullable PLZ plz, @NotNull String name, @NotNull KSimpleValidator<String> validator) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(validator, "validator");
        this.plz = plz;
        this.name = Ort.Companion.verify(name, validator);
    }

    public /* synthetic */ Ort(PLZ pLZ, String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(pLZ, string, kSimpleValidator);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public Ort(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this(Ort.Companion.split(name));
    }

    private Ort(String[] values) {
        this(((CharSequence)values[0]).length() == 0 ? null : new PLZ(values[0]), values[1], null, 4, null);
    }

    @NotNull
    public final Optional<PLZ> getPLZ() {
        Optional<PLZ> optional;
        if (this.plz == null) {
            Optional optional2 = Optional.empty();
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, "{\n            Optional.empty()\n        }");
        } else {
            Optional<PLZ> optional3 = Optional.of(this.plz);
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, "{\n            Optional.of(plz)\n        }");
        }
        return optional;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Ort)) {
            return false;
        }
        String thisName = Text.Companion.replaceUmlaute(this.name);
        String otherName = Text.Companion.replaceUmlaute(((Ort)other).name);
        return this.plz == null || ((Ort)other).plz == null ? StringsKt.equals(thisName, otherName, true) : Intrinsics.areEqual(this.plz, ((Ort)other).plz) && Character.toLowerCase(thisName.charAt(0)) == Character.toLowerCase(otherName.charAt(0));
    }

    public final boolean equalsExact(@NotNull Ort other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.areEqual(this.plz, other.plz) && Intrinsics.areEqual(this.name, other.name);
    }

    public int hashCode() {
        return Character.toUpperCase(Text.Companion.replaceUmlaute(this.name).charAt(0));
    }

    @NotNull
    public String toString() {
        return this.plz == null ? this.name : this.plz + ' ' + this.name;
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap(this);
    }

    @JvmOverloads
    public Ort(@Nullable PLZ plz, @NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this(plz, name, null, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final Ort of(@NotNull String name) {
        return Companion.of(name);
    }

    @JvmStatic
    @NotNull
    public static final Ort of(@NotNull PLZ plz, @NotNull String name) {
        return Companion.of(plz, name);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/jfachwert/post/Ort$Companion;", "", "()V", "LOG", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "NULL", "Lde/jfachwert/post/Ort;", "VALIDATOR", "Lde/jfachwert/KSimpleValidator;", "", "of", "plz", "Lde/jfachwert/post/PLZ;", "name", "split", "", "(Ljava/lang/String;)[Ljava/lang/String;", "validate", "validator", "verify", "jfachwert"})
    @SourceDebugExtension(value={"SMAP\nOrt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ort.kt\nde/jfachwert/post/Ort$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,226:1\n107#2:227\n79#2,22:228\n*S KotlinDebug\n*F\n+ 1 Ort.kt\nde/jfachwert/post/Ort$Companion\n*L\n217#1:227\n217#1:228,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Ort of(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return new Ort(name);
        }

        @JvmStatic
        @NotNull
        public final Ort of(@NotNull PLZ plz, @NotNull String name) {
            Intrinsics.checkNotNullParameter(plz, "plz");
            Intrinsics.checkNotNullParameter(name, "name");
            return new Ort(plz, name, null, 4, null);
        }

        @NotNull
        public final String validate(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return this.validate(name, VALIDATOR);
        }

        private final String validate(String name, KSimpleValidator<String> validator) {
            String[] splitted = this.split(name);
            String ortsname = splitted[1];
            validator.validate((String)((Object)((Serializable)((Object)ortsname))));
            return name;
        }

        private final String verify(String name, KSimpleValidator<String> validator) {
            String string;
            try {
                string = this.validate(name, validator);
            }
            catch (ValidationException ex) {
                throw new LocalizedIllegalArgumentException(ex);
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final String[] split(String name) {
            String input = StringUtils.trimToEmpty(name);
            String[] stringArray = new String[]{"", input};
            String[] splitted = stringArray;
            Intrinsics.checkNotNullExpressionValue(input, "input");
            if (StringsKt.contains$default((CharSequence)input, " ", false, 2, null)) {
                try {
                    String string;
                    void $this$trim$iv;
                    String plz;
                    PLZ.Validator validator = new PLZ.Validator();
                    String string2 = StringUtils.substringBefore(input, " ");
                    Intrinsics.checkNotNullExpressionValue(string2, "substringBefore(input, \" \")");
                    splitted[0] = plz = validator.validate(string2);
                    String string3 = StringUtils.substringAfter(input, " ");
                    Intrinsics.checkNotNullExpressionValue(string3, "substringAfter(input, \" \")");
                    String string4 = string3;
                    int n = 1;
                    String[] stringArray2 = splitted;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    stringArray2[n] = string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                }
                catch (ValidationException ex) {
                    LOG.log(Level.FINE, "no PLZ inside '" + name + "' found:", ex);
                }
            }
            return splitted;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

