/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.jfachwert.KFachwert;
import de.jfachwert.post.Ort;
import de.jfachwert.post.PLZ;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import de.jfachwert.pruefung.exception.ValidationException;
import de.jfachwert.util.ToFachwertSerializer;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToFachwertSerializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0017\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bB\u001b\b\u0017\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r\u00a2\u0006\u0002\u0010\u000eB\u0017\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000f\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010B\u0017\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0011\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0012B\u001d\b\u0016\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013J\b\u0010%\u001a\u00020&H\u0016J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020#0\rH\u0016J\b\u0010(\u001a\u00020\u0003H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006*"}, d2={"Lde/jfachwert/post/Postfach;", "Lde/jfachwert/KFachwert;", "postfach", "", "(Ljava/lang/String;)V", "", "([Ljava/lang/String;)V", "ort", "Lde/jfachwert/post/Ort;", "(Lde/jfachwert/post/Ort;)V", "nummer", "(Ljava/lang/String;Ljava/lang/String;)V", "map", "", "(Ljava/util/Map;)V", "", "(JLde/jfachwert/post/Ort;)V", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;Lde/jfachwert/post/Ort;)V", "Ljava/util/Optional;", "(Ljava/util/Optional;Lde/jfachwert/post/Ort;)V", "nummerFormatted", "getNummerFormatted", "()Ljava/lang/String;", "getOrt", "()Lde/jfachwert/post/Ort;", "ortsname", "getOrtsname", "pLZ", "Lde/jfachwert/post/PLZ;", "getPLZ", "()Lde/jfachwert/post/PLZ;", "equals", "", "other", "", "getNummer", "hashCode", "", "toMap", "toString", "Companion", "jfachwert"})
@SourceDebugExtension(value={"SMAP\nPostfach.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Postfach.kt\nde/jfachwert/post/Postfach\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,368:1\n1#2:369\n107#3:370\n79#3,22:371\n*S KotlinDebug\n*F\n+ 1 Postfach.kt\nde/jfachwert/post/Postfach\n*L\n167#1:370\n167#1:371,22\n*E\n"})
public class Postfach
implements KFachwert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final BigInteger nummer;
    @NotNull
    private final Ort ort;
    @JvmField
    @NotNull
    public static final Postfach NULL = new Postfach(Ort.NULL);

    @NotNull
    public final Ort getOrt() {
        return this.ort;
    }

    public Postfach(@NotNull String postfach) {
        Intrinsics.checkNotNullParameter(postfach, "postfach");
        this(Postfach.Companion.split(postfach));
    }

    private Postfach(String[] postfach) {
        this(postfach[0], postfach[1]);
    }

    public Postfach(@NotNull Ort ort) {
        Intrinsics.checkNotNullParameter(ort, "ort");
        this.ort = ort;
        this.nummer = null;
        Companion.validate(ort);
    }

    public Postfach(@NotNull String nummer, @NotNull String ort) {
        Intrinsics.checkNotNullParameter(nummer, "nummer");
        Intrinsics.checkNotNullParameter(ort, "ort");
        this(Postfach.Companion.toNumber(nummer), new Ort(ort));
    }

    @JsonCreator
    public Postfach(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, "map");
        String string = map.get("nummer");
        Intrinsics.checkNotNull(string);
        Optional optional = Postfach.Companion.toNumber(string);
        String string2 = map.get("plz");
        Intrinsics.checkNotNull(string2);
        PLZ pLZ = PLZ.Companion.of(string2);
        String string3 = map.get("ortsname");
        Intrinsics.checkNotNull(string3);
        this(optional, new Ort(pLZ, string3, null, 4, null));
    }

    public Postfach(long nummer, @NotNull Ort ort) {
        Intrinsics.checkNotNullParameter(ort, "ort");
        BigInteger bigInteger = BigInteger.valueOf(nummer);
        Intrinsics.checkNotNullExpressionValue(bigInteger, "valueOf(nummer)");
        this(bigInteger, ort);
    }

    public Postfach(@NotNull BigInteger nummer, @NotNull Ort ort) {
        Intrinsics.checkNotNullParameter(nummer, "nummer");
        Intrinsics.checkNotNullParameter(ort, "ort");
        this.nummer = nummer;
        this.ort = ort;
        Postfach.Companion.verify(nummer, ort);
    }

    public Postfach(@NotNull Optional<BigInteger> nummer, @NotNull Ort ort) {
        Intrinsics.checkNotNullParameter(nummer, "nummer");
        Intrinsics.checkNotNullParameter(ort, "ort");
        this.nummer = nummer.orElse(null);
        this.ort = ort;
        if (this.nummer == null) {
            Postfach.Companion.verify(ort);
        } else {
            BigInteger bigInteger = nummer.get();
            Intrinsics.checkNotNullExpressionValue(bigInteger, "nummer.get()");
            Postfach.Companion.verify(bigInteger, ort);
        }
    }

    @NotNull
    public final Optional<BigInteger> getNummer() {
        Optional<BigInteger> optional;
        if (this.nummer == null) {
            Optional optional2 = Optional.empty();
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue(optional2, "{\n            Optional.empty()\n        }");
        } else {
            Optional<BigInteger> optional3 = Optional.of(this.nummer);
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, "{\n            Optional.of(nummer)\n        }");
        }
        return optional;
    }

    @NotNull
    public final String getNummerFormatted() {
        if (!this.getNummer().isPresent()) {
            boolean $i$a$-check-Postfach$nummerFormatted$22 = false;
            String $i$a$-check-Postfach$nummerFormatted$22 = "no number present";
            throw new IllegalStateException($i$a$-check-Postfach$nummerFormatted$22.toString());
        }
        BigInteger hundert = BigInteger.valueOf(100L);
        StringBuilder formatted = new StringBuilder();
        BigInteger bigInteger = this.getNummer().get();
        Intrinsics.checkNotNullExpressionValue(bigInteger, "getNummer().get()");
        BigInteger i = bigInteger;
        while (i.compareTo(BigInteger.ONE) > 0) {
            formatted.insert(0, "" + ' ' + i.remainder(hundert));
            Intrinsics.checkNotNullExpressionValue(i.divide(hundert), "i.divide(hundert)");
        }
        String string = formatted.toString();
        Intrinsics.checkNotNullExpressionValue(string, "formatted.toString()");
        String $this$trim$iv = string;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    @NotNull
    public final PLZ getPLZ() {
        PLZ pLZ = this.ort.getPLZ().get();
        Intrinsics.checkNotNullExpressionValue(pLZ, "ort.pLZ.get()");
        return pLZ;
    }

    @NotNull
    public final String getOrtsname() {
        return this.ort.getName();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Postfach)) {
            return false;
        }
        return Intrinsics.areEqual(this.nummer, ((Postfach)other).nummer) && this.ort.equals(((Postfach)other).ort);
    }

    public int hashCode() {
        return this.ort.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getNummer().isPresent() ? "Postfach " + this.getNummerFormatted() + ", " + this.ort : this.ort.toString();
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Map map = new HashMap();
        map.put("plz", this.getPLZ());
        map.put("ortsname", this.getOrtsname());
        if (this.nummer != null) {
            map.put("nummer", this.nummer);
        }
        return map;
    }

    @JvmStatic
    @NotNull
    public static final Postfach of(@NotNull String postfach) {
        return Companion.of(postfach);
    }

    @JvmStatic
    @NotNull
    public static final Postfach of(long nummer, @NotNull Ort ort) {
        return Companion.of(nummer, ort);
    }

    @JvmStatic
    @NotNull
    public static final Postfach of(@NotNull BigInteger nummer, @NotNull Ort ort) {
        return Companion.of(nummer, ort);
    }

    @JvmStatic
    public static final void validate(@NotNull String postfach) {
        Companion.validate(postfach);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/jfachwert/post/Postfach$Companion;", "", "()V", "NULL", "Lde/jfachwert/post/Postfach;", "of", "nummer", "Ljava/math/BigInteger;", "ort", "Lde/jfachwert/post/Ort;", "", "postfach", "", "split", "", "(Ljava/lang/String;)[Ljava/lang/String;", "toNumber", "Ljava/util/Optional;", "number", "validate", "", "verify", "jfachwert"})
    @SourceDebugExtension(value={"SMAP\nPostfach.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Postfach.kt\nde/jfachwert/post/Postfach$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,368:1\n37#2,2:369\n*S KotlinDebug\n*F\n+ 1 Postfach.kt\nde/jfachwert/post/Postfach$Companion\n*L\n305#1:369,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Postfach of(@NotNull String postfach) {
            Intrinsics.checkNotNullParameter(postfach, "postfach");
            return new Postfach(postfach);
        }

        @JvmStatic
        @NotNull
        public final Postfach of(long nummer, @NotNull Ort ort) {
            Intrinsics.checkNotNullParameter(ort, "ort");
            return new Postfach(nummer, ort);
        }

        @JvmStatic
        @NotNull
        public final Postfach of(@NotNull BigInteger nummer, @NotNull Ort ort) {
            Intrinsics.checkNotNullParameter(nummer, "nummer");
            Intrinsics.checkNotNullParameter(ort, "ort");
            return new Postfach(nummer, ort);
        }

        @JvmStatic
        public final void validate(@NotNull String postfach) {
            Intrinsics.checkNotNullParameter(postfach, "postfach");
            String[] lines = this.split(postfach);
            this.toNumber(lines[0]);
            Ort ort = new Ort(lines[1]);
            if (!ort.getPLZ().isPresent()) {
                throw new InvalidValueException((Serializable)((Object)postfach), "postal_code");
            }
        }

        private final String[] split(String postfach) {
            String string = StringUtils.trimToEmpty(postfach);
            Intrinsics.checkNotNullExpressionValue(string, "trimToEmpty(postfach)");
            CharSequence charSequence = string;
            Regex regex = new Regex("[,\\n$]");
            int n = 0;
            Collection $this$toTypedArray$iv = regex.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] lines = thisCollection$iv.toArray(new String[0]);
            String[] stringArray = new String[]{"", lines[0]};
            String[] splitted = stringArray;
            if (lines.length == 2) {
                splitted = lines;
            } else if (lines.length > 2) {
                throw new InvalidValueException((Serializable)((Object)postfach), "post_office_box");
            }
            return splitted;
        }

        private final Optional<BigInteger> toNumber(String number) {
            Optional<BigInteger> optional;
            if (StringUtils.isBlank(number)) {
                Optional<BigInteger> optional2 = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional2, "empty()");
                return optional2;
            }
            String unformatted = RegExUtils.replaceAll(number, "Postfach|\\s+", "");
            try {
                Optional<BigInteger> optional3 = Optional.of(new BigInteger(unformatted));
                Intrinsics.checkNotNullExpressionValue(optional3, "{\n                Option\u2026formatted))\n            }");
                optional = optional3;
            }
            catch (NumberFormatException nfe) {
                throw new InvalidValueException((Serializable)((Object)number), "number", nfe);
            }
            return optional;
        }

        public final void validate(@NotNull BigInteger nummer, @NotNull Ort ort) {
            Intrinsics.checkNotNullParameter(nummer, "nummer");
            Intrinsics.checkNotNullParameter(ort, "ort");
            if (nummer.compareTo(BigInteger.ONE) < 0) {
                throw new InvalidValueException(nummer, "number");
            }
            this.validate(ort);
        }

        private final void verify(BigInteger nummer, Ort ort) {
            try {
                this.validate(nummer, ort);
            }
            catch (ValidationException ex) {
                throw new LocalizedIllegalArgumentException(ex);
            }
        }

        public final void validate(@NotNull Ort ort) {
            Intrinsics.checkNotNullParameter(ort, "ort");
            if (!ort.getPLZ().isPresent()) {
                throw new InvalidValueException(ort, "postal_code");
            }
        }

        private final void verify(Ort ort) {
            try {
                this.validate(ort);
            }
            catch (ValidationException ex) {
                throw new LocalizedIllegalArgumentException(ex);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

