/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung;

import de.jfachwert.PruefzifferVerfahren;
import de.jfachwert.pruefung.exception.LocalizedValidationException;
import de.jfachwert.pruefung.exception.PruefzifferException;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/jfachwert/pruefung/Mod11Verfahren;", "Lde/jfachwert/PruefzifferVerfahren;", "", "anzahlStellen", "", "(I)V", "berechnePruefziffer", "wert", "getPruefziffer", "isValid", "", "validate", "jfachwert"})
@SourceDebugExtension(value={"SMAP\nMod11Verfahren.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mod11Verfahren.kt\nde/jfachwert/pruefung/Mod11Verfahren\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public class Mod11Verfahren
implements PruefzifferVerfahren<String> {
    private final int anzahlStellen;

    public Mod11Verfahren(int anzahlStellen) {
        this.anzahlStellen = anzahlStellen;
    }

    @Override
    @NotNull
    public String getPruefziffer(@NotNull String wert) {
        Intrinsics.checkNotNullParameter(wert, "wert");
        String string = wert.substring(wert.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
        return string;
    }

    @Override
    public boolean isValid(@NotNull String wert) {
        Intrinsics.checkNotNullParameter(wert, "wert");
        int n = this.anzahlStellen + 1;
        if (!(wert.length() == n)) {
            boolean bl = false;
            String string = "Nummer '" + wert + "' ist nicht " + n + " Zeichen lang";
            throw new IllegalArgumentException(string.toString());
        }
        String pruefziffer = this.getPruefziffer(wert);
        String string = wert.substring(0, wert.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return Intrinsics.areEqual(pruefziffer, this.berechnePruefziffer(string));
    }

    @Override
    @NotNull
    public String berechnePruefziffer(@NotNull String wert) {
        int pruefziffer;
        Intrinsics.checkNotNullParameter(wert, "wert");
        char[] cArray = wert.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
        char[] ziffernfolge = cArray;
        int produkt = 10;
        int stelle = 1;
        int n = this.anzahlStellen;
        if (stelle <= n) {
            while (true) {
                int summe;
                if ((summe = (Character.getNumericValue(ziffernfolge[stelle - 1]) + produkt) % 10) == 0) {
                    summe = 10;
                }
                produkt = summe * 2 % 11;
                if (stelle == n) break;
                ++stelle;
            }
        }
        if ((pruefziffer = 11 - produkt) == 10) {
            pruefziffer = 0;
        }
        String string = Integer.toString(pruefziffer);
        Intrinsics.checkNotNullExpressionValue(string, "toString(pruefziffer)");
        return string;
    }

    @Override
    @NotNull
    public String validate(@NotNull String wert) {
        String string;
        Intrinsics.checkNotNullParameter(wert, "wert");
        try {
            if (!this.isValid(wert)) {
                throw new PruefzifferException((Serializable)((Object)wert), (Serializable)((Object)this.berechnePruefziffer(wert)), (Serializable)((Object)this.getPruefziffer(wert)));
            }
            string = wert;
        }
        catch (IllegalArgumentException ex) {
            throw new LocalizedValidationException(ex.getMessage(), ex);
        }
        return string;
    }

    @Override
    @Nullable
    public Object validateObject(@NotNull Object value) {
        return PruefzifferVerfahren.DefaultImpls.validateObject(this, value);
    }

    @Override
    @NotNull
    public String verify(@NotNull String value) {
        return (String)((Object)PruefzifferVerfahren.DefaultImpls.verify(this, (Serializable)((Object)value)));
    }
}

