/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.pruefung.exception;

import de.jfachwert.pruefung.exception.LocalizedValidationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fB\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/jfachwert/pruefung/exception/InvalidLengthException;", "Lde/jfachwert/pruefung/exception/LocalizedValidationException;", "argument", "", "expected", "", "(Ljava/lang/String;I)V", "array", "", "([BI)V", "min", "max", "(Ljava/lang/String;II)V", "allowedLengths", "", "(Ljava/lang/String;Ljava/util/List;)V", "", "arguments", "", "Ljava/io/Serializable;", "[Ljava/io/Serializable;", "getLocalizedMessage", "Companion", "jfachwert"})
public class InvalidLengthException
extends LocalizedValidationException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Serializable[] arguments;
    private final int min;
    private final int max;
    @NotNull
    private final List<Integer> allowedLengths;

    public InvalidLengthException(@NotNull String argument, int expected) {
        Intrinsics.checkNotNullParameter(argument, "argument");
        this(argument, CollectionsKt.listOf(expected));
    }

    public InvalidLengthException(@NotNull byte[] array, int expected) {
        Intrinsics.checkNotNullParameter(array, "array");
        super("array=" + Arrays.toString(array) + " has not length " + expected + " (but " + array.length + ')');
        this.allowedLengths = new ArrayList();
        this.min = expected;
        this.max = expected;
        this.arguments = new Serializable[array.length];
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            this.arguments[i] = Byte.valueOf(array[i]);
        }
    }

    public InvalidLengthException(@NotNull String argument, int min, int max) {
        Intrinsics.checkNotNullParameter(argument, "argument");
        super('\'' + argument + "': length (" + argument.length() + ") is not between " + min + " and " + max);
        this.allowedLengths = new ArrayList();
        this.min = min;
        this.max = max;
        this.arguments = InvalidLengthException.Companion.asArray(argument);
    }

    public InvalidLengthException(@NotNull String argument, @NotNull List<Integer> allowedLengths) {
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(allowedLengths, "allowedLengths");
        super('\'' + argument + "': " + argument.length() + " is not in allowed lengths " + allowedLengths);
        this.allowedLengths = new ArrayList();
        this.min = 0;
        this.max = 0;
        this.arguments = InvalidLengthException.Companion.asArray(argument);
        this.allowedLengths.addAll((Collection<Integer>)allowedLengths);
    }

    @Override
    @NotNull
    public String getLocalizedMessage() {
        String string;
        String arg = String.valueOf(this.arguments[0]);
        if (this.allowedLengths.isEmpty()) {
            if (this.min < this.max) {
                Object[] objectArray = new Object[]{arg, arg.length(), this.min, this.max};
                string = this.getLocalizedMessage("pruefung.illegallength.exception.message.range", objectArray);
            } else {
                Object[] objectArray = new Object[]{Arrays.toString(this.arguments), this.arguments.length, this.min};
                string = this.getLocalizedMessage("pruefung.illegallength.exception.message.array", objectArray);
            }
        } else {
            Object[] objectArray = new Object[]{arg, arg.length(), this.allowedLengths};
            string = this.getLocalizedMessage("pruefung.illegallength.exception.message.values", objectArray);
        }
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lde/jfachwert/pruefung/exception/InvalidLengthException$Companion;", "", "()V", "asArray", "", "Ljava/io/Serializable;", "s", "", "(Ljava/lang/String;)[Ljava/io/Serializable;", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        private final Serializable[] asArray(String s) {
            Serializable[] a = new Serializable[]{(Serializable)((Object)s)};
            return a;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

