/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.steuer;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import de.jfachwert.KFachwert;
import de.jfachwert.math.Prozent;
import java.math.BigDecimal;
import java.util.Map;
import java.util.WeakHashMap;
import javax.money.MonetaryAmount;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=ToStringSerializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0017\u0018\u0000 \u001a2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u001aB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0013\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u000e\u0010\u0018\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0019\u001a\u00020\u0004H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lde/jfachwert/steuer/Mehrwertsteuer;", "Lde/jfachwert/KFachwert;", "", "satz", "", "(Ljava/lang/String;)V", "prozent", "Lde/jfachwert/math/Prozent;", "(Lde/jfachwert/math/Prozent;)V", "getProzent", "()Lde/jfachwert/math/Prozent;", "betragVonBrutto", "Ljavax/money/MonetaryAmount;", "brutto", "betragVonNetto", "netto", "bruttoZuNetto", "compareTo", "", "other", "equals", "", "", "hashCode", "nettoZuBrutto", "toString", "Companion", "jfachwert"})
public class Mehrwertsteuer
implements KFachwert,
Comparable<Mehrwertsteuer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Prozent prozent;
    @NotNull
    private static final WeakHashMap<Prozent, Mehrwertsteuer> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final Mehrwertsteuer DE_NORMAL = Companion.of("19%");
    @JvmField
    @NotNull
    public static final Mehrwertsteuer DE_REDUZIERT = Companion.of("7%");
    @JvmField
    @NotNull
    public static final Mehrwertsteuer CH_NORMAL = Companion.of("7.7%");
    @JvmField
    @NotNull
    public static final Mehrwertsteuer CH_REDUZIERT = Companion.of("2.5%");
    @JvmField
    @NotNull
    public static final Mehrwertsteuer CH_SONDER = Companion.of("3.7%");

    public Mehrwertsteuer(@NotNull Prozent prozent) {
        Intrinsics.checkNotNullParameter(prozent, "prozent");
        this.prozent = prozent;
    }

    @NotNull
    public final Prozent getProzent() {
        return this.prozent;
    }

    public Mehrwertsteuer(@NotNull String satz) {
        Intrinsics.checkNotNullParameter(satz, "satz");
        this(Prozent.Companion.of(satz));
    }

    @NotNull
    public final MonetaryAmount nettoZuBrutto(@NotNull MonetaryAmount netto) {
        Intrinsics.checkNotNullParameter(netto, "netto");
        MonetaryAmount monetaryAmount = netto.add(this.betragVonNetto(netto));
        Intrinsics.checkNotNullExpressionValue(monetaryAmount, "netto.add(betragVonNetto(netto))");
        return monetaryAmount;
    }

    @NotNull
    public final MonetaryAmount bruttoZuNetto(@NotNull MonetaryAmount brutto) {
        Intrinsics.checkNotNullParameter(brutto, "brutto");
        MonetaryAmount monetaryAmount = brutto.divide(BigDecimal.ONE.add(this.prozent.toBigDecimal()));
        Intrinsics.checkNotNullExpressionValue(monetaryAmount, "brutto.divide(BigDecimal\u2026(prozent.toBigDecimal()))");
        return monetaryAmount;
    }

    @NotNull
    public final MonetaryAmount betragVonBrutto(@NotNull MonetaryAmount brutto) {
        Intrinsics.checkNotNullParameter(brutto, "brutto");
        MonetaryAmount monetaryAmount = brutto.subtract(this.bruttoZuNetto(brutto));
        Intrinsics.checkNotNullExpressionValue(monetaryAmount, "brutto.subtract(bruttoZuNetto(brutto))");
        return monetaryAmount;
    }

    @NotNull
    public final MonetaryAmount betragVonNetto(@NotNull MonetaryAmount netto) {
        Intrinsics.checkNotNullParameter(netto, "netto");
        MonetaryAmount monetaryAmount = netto.multiply(this.prozent);
        Intrinsics.checkNotNullExpressionValue(monetaryAmount, "netto.multiply(prozent)");
        return monetaryAmount;
    }

    @Override
    public int compareTo(@NotNull Mehrwertsteuer other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.prozent.compareTo(other.prozent);
    }

    @NotNull
    public String toString() {
        return this.prozent.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Mehrwertsteuer)) {
            return false;
        }
        return Intrinsics.areEqual(this.prozent, ((Mehrwertsteuer)other).prozent);
    }

    public int hashCode() {
        return this.prozent.hashCode();
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return KFachwert.DefaultImpls.toMap(this);
    }

    @JvmStatic
    @NotNull
    public static final Mehrwertsteuer of(@NotNull String satz) {
        return Companion.of(satz);
    }

    @JvmStatic
    @NotNull
    public static final Mehrwertsteuer of(@NotNull Prozent satz) {
        return Companion.of(satz);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lde/jfachwert/steuer/Mehrwertsteuer$Companion;", "", "()V", "CH_NORMAL", "Lde/jfachwert/steuer/Mehrwertsteuer;", "CH_REDUZIERT", "CH_SONDER", "DE_NORMAL", "DE_REDUZIERT", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lde/jfachwert/math/Prozent;", "of", "satz", "", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Mehrwertsteuer of(@NotNull String satz) {
            Intrinsics.checkNotNullParameter(satz, "satz");
            return this.of(Prozent.Companion.of(satz));
        }

        @JvmStatic
        @NotNull
        public final Mehrwertsteuer of(@NotNull Prozent satz) {
            Intrinsics.checkNotNullParameter(satz, "satz");
            Mehrwertsteuer mehrwertsteuer = WEAK_CACHE.computeIfAbsent(satz, Mehrwertsteuer::new);
            Intrinsics.checkNotNullExpressionValue(mehrwertsteuer, "WEAK_CACHE.computeIfAbse\u2026nction(::Mehrwertsteuer))");
            return mehrwertsteuer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

