/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.steuer;

import de.jfachwert.KSimpleValidator;
import de.jfachwert.math.PackedDecimal;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.NullValidator;
import de.jfachwert.steuer.SteuerIdNr;
import de.jfachwert.steuer.Steuernummer;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\b\u00a8\u0006\u000b"}, d2={"Lde/jfachwert/steuer/SteuerIdNr;", "Lde/jfachwert/steuer/Steuernummer;", "idNr", "", "(Ljava/lang/String;)V", "validator", "Lde/jfachwert/KSimpleValidator;", "Lde/jfachwert/math/PackedDecimal;", "(Ljava/lang/String;Lde/jfachwert/KSimpleValidator;)V", "Companion", "Validator", "jfachwert"})
public class SteuerIdNr
extends Steuernummer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Validator VALIDATOR = new Validator();
    @NotNull
    private static final WeakHashMap<String, SteuerIdNr> WEAK_CACHE = new WeakHashMap();
    @JvmField
    @NotNull
    public static final SteuerIdNr NULL = new SteuerIdNr("", new NullValidator());

    public SteuerIdNr(@NotNull String idNr, @NotNull KSimpleValidator<PackedDecimal> validator) {
        Intrinsics.checkNotNullParameter(idNr, "idNr");
        Intrinsics.checkNotNullParameter(validator, "validator");
        super(idNr, validator);
    }

    public /* synthetic */ SteuerIdNr(String string, KSimpleValidator kSimpleValidator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kSimpleValidator = VALIDATOR;
        }
        this(string, kSimpleValidator);
    }

    public SteuerIdNr(@NotNull String idNr) {
        Intrinsics.checkNotNullParameter(idNr, "idNr");
        this(idNr, VALIDATOR);
    }

    @JvmStatic
    @NotNull
    public static final SteuerIdNr of(@NotNull String idNr) {
        return Companion.of(idNr);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\tH\u0007J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/jfachwert/steuer/SteuerIdNr$Companion;", "", "()V", "NULL", "Lde/jfachwert/steuer/SteuerIdNr;", "VALIDATOR", "Lde/jfachwert/steuer/SteuerIdNr$Validator;", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "", "of", "idNr", "validate", "nr", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SteuerIdNr of(@NotNull String idNr) {
            Intrinsics.checkNotNullParameter(idNr, "idNr");
            SteuerIdNr steuerIdNr = WEAK_CACHE.computeIfAbsent(idNr, arg_0 -> Companion.of$lambda$0(of.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue(steuerIdNr, "WEAK_CACHE.computeIfAbse\u2026 { nr -> SteuerIdNr(nr) }");
            return steuerIdNr;
        }

        @NotNull
        public final String validate(@NotNull String nr) {
            Intrinsics.checkNotNullParameter(nr, "nr");
            return VALIDATOR.validate(nr);
        }

        private static final SteuerIdNr of$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (SteuerIdNr)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lde/jfachwert/steuer/SteuerIdNr$Validator;", "Lde/jfachwert/steuer/Steuernummer$Validator;", "()V", "validate", "", "nr", "jfachwert"})
    public static class Validator
    extends Steuernummer.Validator {
        @Override
        @NotNull
        public String validate(@NotNull String nr) {
            Intrinsics.checkNotNullParameter(nr, "nr");
            LengthValidator.Companion.validate(nr, 11);
            return super.validate(nr);
        }
    }
}

