/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.steuer;

import de.jfachwert.PruefzifferVerfahren;
import de.jfachwert.Text;
import de.jfachwert.pruefung.LengthValidator;
import de.jfachwert.pruefung.Mod11Verfahren;
import de.jfachwert.pruefung.NoopVerfahren;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lde/jfachwert/steuer/UStIdNr;", "Lde/jfachwert/Text;", "nr", "", "(Ljava/lang/String;)V", "pzVerfahren", "Lde/jfachwert/PruefzifferVerfahren;", "(Ljava/lang/String;Lde/jfachwert/PruefzifferVerfahren;)V", "land", "Ljava/util/Locale;", "getLand", "()Ljava/util/Locale;", "Companion", "jfachwert"})
public class UStIdNr
extends Text {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HashMap<String, PruefzifferVerfahren<String>> PRUEFZIFFER_VERFAHREN = new HashMap();
    @NotNull
    private static final WeakHashMap<String, UStIdNr> WEAK_CACHE = new WeakHashMap();

    public UStIdNr(@NotNull String nr, @NotNull PruefzifferVerfahren<String> pzVerfahren) {
        Intrinsics.checkNotNullParameter(nr, "nr");
        Intrinsics.checkNotNullParameter(pzVerfahren, "pzVerfahren");
        super(UStIdNr.Companion.verify(nr, pzVerfahren), null, 2, null);
    }

    public /* synthetic */ UStIdNr(String string, PruefzifferVerfahren pruefzifferVerfahren, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pruefzifferVerfahren = UStIdNr.Companion.selectPruefzifferVerfahrenFor(string);
        }
        this(string, pruefzifferVerfahren);
    }

    @NotNull
    public final Locale getLand() {
        return new Locale(UStIdNr.Companion.toLaenderkuerzel((String)this.getCode()));
    }

    public UStIdNr(@NotNull String nr) {
        Intrinsics.checkNotNullParameter(nr, "nr");
        this(nr, UStIdNr.Companion.selectPruefzifferVerfahrenFor(nr));
    }

    @JvmStatic
    @NotNull
    public static final UStIdNr of(@NotNull String nr) {
        return Companion.of(nr);
    }

    static {
        ((Map)PRUEFZIFFER_VERFAHREN).put("DE", new Mod11Verfahren(8));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0006H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/jfachwert/steuer/UStIdNr$Companion;", "", "()V", "PRUEFZIFFER_VERFAHREN", "Ljava/util/HashMap;", "", "Lde/jfachwert/PruefzifferVerfahren;", "WEAK_CACHE", "Ljava/util/WeakHashMap;", "Lde/jfachwert/steuer/UStIdNr;", "of", "nr", "selectPruefzifferVerfahrenFor", "toLaenderkuerzel", "validate", "verify", "verfahren", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UStIdNr of(@NotNull String nr) {
            Intrinsics.checkNotNullParameter(nr, "nr");
            UStIdNr uStIdNr = WEAK_CACHE.computeIfAbsent(nr, UStIdNr::new);
            Intrinsics.checkNotNullExpressionValue(uStIdNr, "WEAK_CACHE.computeIfAbse\u2026(nr, Function(::UStIdNr))");
            return uStIdNr;
        }

        private final PruefzifferVerfahren<String> selectPruefzifferVerfahrenFor(String nr) {
            String laenderkuerzel = this.toLaenderkuerzel(nr);
            PruefzifferVerfahren verfahren = (PruefzifferVerfahren)PRUEFZIFFER_VERFAHREN.get(laenderkuerzel);
            if (verfahren == null) {
                verfahren = new NoopVerfahren();
            }
            return verfahren;
        }

        @NotNull
        public final String validate(@NotNull String nr) {
            Intrinsics.checkNotNullParameter(nr, "nr");
            return this.selectPruefzifferVerfahrenFor(nr).validate((String)((Object)((Serializable)((Object)nr))));
        }

        private final String verify(String nr, PruefzifferVerfahren<String> verfahren) {
            String unformatted = StringUtils.remove(nr, ' ');
            Intrinsics.checkNotNullExpressionValue(unformatted, "unformatted");
            LengthValidator.Companion.verify(unformatted, 7, 14);
            String string = unformatted.substring(2);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            verfahren.verify((String)((Object)((Serializable)((Object)string))));
            return unformatted;
        }

        private final String toLaenderkuerzel(String nr) {
            String string = nr.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = string.toUpperCase();
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toUpperCase()");
            String kuerzel = string2;
            if (!StringUtils.isAlpha(kuerzel)) {
                throw new InvalidValueException((Serializable)((Object)nr), "country");
            }
            return kuerzel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

