/*
 * Decompiled with CFR 0.152.
 */
package de.jfachwert.util;

import de.jfachwert.AbstractFachwert;
import de.jfachwert.pruefung.exception.InvalidValueException;
import de.jfachwert.pruefung.exception.LocalizedIllegalArgumentException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\b\u0016\u0018\u0000 \u001b2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0016\u001a\u00020\nJ\u0006\u0010\u0017\u001a\u00020\u0004J\u0006\u0010\u0018\u001a\u00020\u0007J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lde/jfachwert/util/TinyUUID;", "Lde/jfachwert/AbstractFachwert;", "Ljava/util/UUID;", "uuid", "", "(Ljava/lang/String;)V", "number", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "bytes", "", "([B)V", "(Ljava/util/UUID;)V", "leastSignificantBits", "", "getLeastSignificantBits", "()J", "mostSignificantBits", "getMostSignificantBits", "uUID", "getUUID", "()Ljava/util/UUID;", "toBytes", "toLongString", "toNumber", "toShortString", "toString", "Companion", "jfachwert"})
public class TinyUUID
extends AbstractFachwert<UUID, TinyUUID> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final TinyUUID MIN = new TinyUUID("00000000-0000-0000-0000-000000000000");
    @JvmField
    @NotNull
    public static final TinyUUID MAX = new TinyUUID("ffffffff-ffff-ffff-ffff-ffffffffffff");

    public TinyUUID(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        super(uuid, null, 2, null);
    }

    public TinyUUID(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        this(TinyUUID.Companion.toUUID(uuid));
    }

    public TinyUUID(@NotNull BigInteger number) {
        Intrinsics.checkNotNullParameter(number, "number");
        this(TinyUUID.Companion.toUUID(number));
    }

    public TinyUUID(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        this(TinyUUID.Companion.toUUID(bytes));
    }

    @NotNull
    public final BigInteger toNumber() {
        UUID uuid = (UUID)this.getCode();
        String string = uuid.toString();
        Intrinsics.checkNotNullExpressionValue(string, "uuid.toString()");
        return TinyUUID.Companion.toBigInteger(string);
    }

    @NotNull
    public final byte[] toBytes() {
        byte[] bytes = this.toNumber().toByteArray();
        Intrinsics.checkNotNullExpressionValue(bytes, "bytes");
        return TinyUUID.Companion.to16Bytes(bytes);
    }

    @NotNull
    public final UUID getUUID() {
        return (UUID)this.getCode();
    }

    public final long getLeastSignificantBits() {
        return this.getUUID().getLeastSignificantBits();
    }

    public final long getMostSignificantBits() {
        return this.getUUID().getMostSignificantBits();
    }

    @Override
    @NotNull
    public String toString() {
        return this.toShortString();
    }

    @NotNull
    public String toShortString() {
        String s = Base64.getEncoder().withoutPadding().encodeToString(this.toBytes());
        Intrinsics.checkNotNullExpressionValue(s, "s");
        return StringsKt.replace$default(StringsKt.replace$default(s, '/', '_', false, 4, null), '+', '-', false, 4, null);
    }

    @NotNull
    public final String toLongString() {
        String string = this.getUUID().toString();
        Intrinsics.checkNotNullExpressionValue(string, "uUID.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final TinyUUID fromString(@NotNull String id) {
        return Companion.fromString(id);
    }

    @JvmStatic
    @NotNull
    public static final TinyUUID randomUUID() {
        return Companion.randomUUID();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/jfachwert/util/TinyUUID$Companion;", "", "()V", "MAX", "Lde/jfachwert/util/TinyUUID;", "MIN", "fromString", "id", "", "randomUUID", "to16Bytes", "", "number", "Ljava/math/BigInteger;", "bytes", "toBigInteger", "uuid", "toString", "toUUID", "Ljava/util/UUID;", "verify", "jfachwert"})
    public static final class Companion {
        private Companion() {
        }

        private final byte[] to16Bytes(BigInteger number) {
            byte[] byArray = number.toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "number.toByteArray()");
            return this.to16Bytes(byArray);
        }

        /*
         * WARNING - void declaration
         */
        private final byte[] to16Bytes(byte[] bytes) {
            byte[] byArray;
            if (bytes.length > 15) {
                byte[] byArray2 = Arrays.copyOfRange(bytes, bytes.length - 16, bytes.length);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue(byArray2, "{\n                Arrays\u2026bytes.size)\n            }");
            } else {
                void var2_2;
                byte[] bytes16 = new byte[16];
                System.arraycopy(bytes, 0, bytes16, 16 - bytes.length, bytes.length);
                byArray = var2_2;
            }
            return byArray;
        }

        private final BigInteger toBigInteger(String uuid) {
            Object object;
            try {
                object = uuid;
                Regex regex = new Regex("-");
                String string = "";
                object = new BigInteger(regex.replace((CharSequence)object, string), 16);
            }
            catch (NumberFormatException nfe) {
                throw new InvalidValueException((Serializable)((Object)uuid), "UUID");
            }
            return object;
        }

        private final String toString(BigInteger number) {
            byte[] bytes = this.to16Bytes(number);
            return this.toString(bytes);
        }

        private final String toString(byte[] bytes) {
            String string = "%02x%02x%02x%02x-%02x%02x-%02x%02x-%02x%02x-%02x%02x%02x%02x%02x%02x";
            Object[] objectArray = new Object[]{bytes[0], bytes[1], bytes[2], bytes[3], bytes[4], bytes[5], bytes[6], bytes[7], bytes[8], bytes[9], bytes[10], bytes[11], bytes[12], bytes[13], bytes[14], bytes[15]};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
            return string2;
        }

        @JvmStatic
        @NotNull
        public final TinyUUID fromString(@NotNull String id) {
            Intrinsics.checkNotNullParameter(id, "id");
            return new TinyUUID(this.toUUID(id));
        }

        private final UUID toUUID(String id) {
            UUID uUID;
            switch (id.length()) {
                case 22: {
                    String base64 = StringsKt.replace$default(StringsKt.replace$default(id, '-', '+', false, 4, null), '_', '/', false, 4, null);
                    Base64.Decoder decoder = Base64.getDecoder();
                    String string = base64;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
                    byte[] byArray = string.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
                    byte[] bytes = decoder.decode(byArray);
                    Intrinsics.checkNotNullExpressionValue(bytes, "bytes");
                    uUID = this.toUUID(bytes);
                    break;
                }
                case 25: {
                    BigInteger n = new BigInteger(id, 36);
                    uUID = this.toUUID(n);
                    break;
                }
                default: {
                    UUID uUID2;
                    try {
                        uUID2 = UUID.fromString(id);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new InvalidValueException((Serializable)((Object)id), "UUID");
                    }
                    UUID uUID3 = uUID2;
                    uUID = uUID3;
                    Intrinsics.checkNotNullExpressionValue(uUID3, "try {\n                  \u2026\"UUID\")\n                }");
                }
            }
            return uUID;
        }

        private final UUID toUUID(BigInteger number) {
            UUID uUID = UUID.fromString(this.toString(number));
            Intrinsics.checkNotNullExpressionValue(uUID, "fromString(toString(number))");
            return uUID;
        }

        private final UUID toUUID(byte[] bytes) {
            UUID uUID = UUID.fromString(this.toString(this.verify(bytes)));
            Intrinsics.checkNotNullExpressionValue(uUID, "fromString(toString(verify(bytes)))");
            return uUID;
        }

        private final byte[] verify(byte[] bytes) {
            if (bytes.length != 16) {
                throw new LocalizedIllegalArgumentException(bytes, 16);
            }
            return bytes;
        }

        @JvmStatic
        @NotNull
        public final TinyUUID randomUUID() {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID()");
            return new TinyUUID(uUID);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

