/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gdv.xport.config.Config;
import gdv.xport.event.ImportListener;
import gdv.xport.event.SatzValidator;
import gdv.xport.feld.Betrag;
import gdv.xport.feld.BetragMitVorzeichen;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Datum;
import gdv.xport.feld.Version;
import gdv.xport.io.ExtendedEOFException;
import gdv.xport.io.ImportException;
import gdv.xport.io.Importer;
import gdv.xport.io.PushbackLineNumberReader;
import gdv.xport.io.RecordReader;
import gdv.xport.io.RecyclingInputStreamReader;
import gdv.xport.satz.Datensatz;
import gdv.xport.satz.Nachsatz;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Vorsatz;
import gdv.xport.util.NotRegisteredException;
import gdv.xport.util.SatzRegistry;
import gdv.xport.util.SatzTyp;
import gdv.xport.util.SimpleConstraintViolation;
import gdv.xport.util.URLReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.sf.oval.ConstraintViolation;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Datenpaket
implements ImportListener {
    private static final Logger LOG = LogManager.getLogger(Datenpaket.class);
    private Vorsatz vorsatz;
    private final List<Datensatz> datensaetze = new ArrayList<Datensatz>();
    private final Config config;
    private Nachsatz nachsatz;

    public Datenpaket() {
        this(Config.getInstance());
    }

    public Datenpaket(Config config) {
        this.config = config;
        this.vorsatz = new Vorsatz(SatzRegistry.getInstance(config));
        this.nachsatz = new Nachsatz(SatzRegistry.getInstance(config));
        this.vorsatz.setVersion(this.nachsatz);
        Datum heute = Datum.heute();
        this.setErstellungsDatumVon(heute);
        this.setVuNummer(config.getVUNr().getInhalt());
        LOG.debug("{} created.", (Object)this);
    }

    public Datenpaket(String vuNummer) {
        this(Config.getInstance().withProperty("gdv.VU-Nummer", vuNummer));
    }

    public static Datenpaket of(Collection<Satz> datensaetze) {
        Config cfg = datensaetze.isEmpty() ? Config.DEFAULT : datensaetze.iterator().next().getConfig();
        return Datenpaket.of(datensaetze, cfg);
    }

    public static Datenpaket of(File file) throws IOException {
        Datenpaket datenpaket = new Datenpaket();
        datenpaket.importFrom(file);
        return datenpaket;
    }

    public static Datenpaket of(Collection<Satz> datensaetze, Config cfg) {
        Datenpaket datenpaket = new Datenpaket(cfg);
        ArrayList<Datensatz> dsList = new ArrayList<Datensatz>();
        for (Satz satz : datensaetze) {
            if (satz instanceof Vorsatz) {
                datenpaket.vorsatz = (Vorsatz)satz;
                continue;
            }
            if (satz instanceof Nachsatz) {
                datenpaket.nachsatz = (Nachsatz)satz;
                datenpaket.vorsatz.setVersion(datenpaket.nachsatz);
                continue;
            }
            dsList.add((Datensatz)satz);
        }
        for (Datensatz datensatz : dsList) {
            datenpaket.add(datensatz);
        }
        return datenpaket;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setVuNummer(String vuNummer) {
        this.vorsatz.setVuNummer(vuNummer);
        for (Datensatz datensatz : this.datensaetze) {
            if (!datensatz.hasFeld(Bezeichner.VU_NUMMER)) continue;
            datensatz.setVuNummer(vuNummer);
        }
    }

    public String getVuNummer() {
        return this.vorsatz.getVuNummer();
    }

    public List<Datensatz> getDatensaetze() {
        return Collections.unmodifiableList(this.datensaetze);
    }

    public List<Datensatz> getDatensaetze(SatzTyp typ) {
        ArrayList<Datensatz> saetze = new ArrayList<Datensatz>();
        for (Datensatz ds : this.datensaetze) {
            if (!typ.equals(ds.getSatzTyp())) continue;
            saetze.add(ds);
        }
        return saetze;
    }

    public List<Satz> getAllSaetze() {
        ArrayList<Satz> satzListe = new ArrayList<Satz>();
        satzListe.add(this.vorsatz);
        satzListe.addAll(this.datensaetze);
        satzListe.add(this.nachsatz);
        return Collections.unmodifiableList(satzListe);
    }

    public void setDatensaetze(List<Datensatz> datensaetze) {
        this.datensaetze.clear();
        this.datensaetze.addAll(datensaetze);
    }

    public Vorsatz getVorsatz() {
        return this.vorsatz;
    }

    public Nachsatz getNachsatz() {
        return this.nachsatz;
    }

    public void add(Datensatz datensatz) {
        if ("0001".equalsIgnoreCase(datensatz.getGdvSatzartName()) || "9999".equalsIgnoreCase(datensatz.getGdvSatzartName())) {
            throw new IllegalArgumentException("0001".equalsIgnoreCase(datensatz.getGdvSatzartName()) ? "Einen Vorsatz gibt es bereits!" : "Einen Nachsatz gibt es bereits!");
        }
        this.preset(datensatz);
        this.datensaetze.add(datensatz);
        this.vorsatz.setVersion(datensatz);
        if (datensatz.getSatzTyp().equals(SatzTyp.of(200))) {
            this.setNachsatzSummenAus0200(datensatz);
        } else if (datensatz.getSatzTyp().equals(SatzTyp.of(400))) {
            this.setNachsatzSummenAus0400(datensatz);
        } else if (datensatz.getSatzTyp().equals(SatzTyp.of(500))) {
            this.setNachsatzSummenAus0500(datensatz);
        }
        this.nachsatz.setAnzahlSaetze(this.nachsatz.getAnzahlSaetze() + datensatz.getNumberOfTeildatensaetze());
    }

    private void preset(Datensatz datensatz) {
        if (StringUtils.isNotEmpty(this.getVuNummer()) && datensatz.hasVuNummer() && StringUtils.isEmpty(datensatz.getVuNummer())) {
            datensatz.setVuNummer(this.getVuNummer());
        }
        if (StringUtils.isEmpty(datensatz.getVermittler())) {
            datensatz.setVermittler(this.getVermittler());
        }
    }

    public void export(File file) throws IOException {
        this.export(file, Config.DEFAULT_ENCODING);
    }

    public void export(File file, String encoding) throws IOException {
        this.export(file, Charset.forName(encoding));
    }

    public void export(File file, Charset encoding) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);){
            this.export(writer);
        }
    }

    public void export(OutputStream ostream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(ostream, Config.DEFAULT_ENCODING);
        this.export(writer);
        ((Writer)writer).flush();
        ostream.flush();
    }

    public void export(Writer writer) throws IOException {
        this.vorsatz.export(writer);
        for (Datensatz datensatz : this.datensaetze) {
            datensatz.export(writer);
        }
        this.nachsatz.export(writer);
        writer.flush();
        LOG.info("{} Saetze exportiert.", (Object)this.nachsatz.getAnzahlSaetze());
    }

    public Datenpaket importFrom(URI uri) throws IOException {
        return this.importFrom(uri.toURL());
    }

    public Datenpaket importFrom(URL url) throws IOException {
        URLReader urlReader = new URLReader(url);
        String content = urlReader.read();
        return this.importFrom(content);
    }

    public Datenpaket importFrom(String content) throws IOException {
        try (StringReader reader = new StringReader(content);){
            this.importFrom(reader);
        }
        return this;
    }

    public Datenpaket importFrom(InputStream istream) throws IOException {
        RecyclingInputStreamReader reader = new RecyclingInputStreamReader(istream, Config.DEFAULT_ENCODING);
        return this.importFrom(reader);
    }

    public Datenpaket importFrom(Reader reader) throws IOException {
        PushbackLineNumberReader lnr = new PushbackLineNumberReader(new RecordReader(reader), 256);
        try {
            return this.importFrom(lnr);
        }
        catch (EOFException eofe) {
            throw new ExtendedEOFException("line " + lnr.getLineNumber() + ": " + eofe.getMessage(), eofe);
        }
        catch (IOException ioe) {
            throw new ImportException(lnr, "read error", ioe);
        }
        catch (NumberFormatException nfe) {
            throw new ImportException(lnr, "number expected, but found: \"" + lnr.readLine() + '\"', nfe);
        }
    }

    public Datenpaket importFrom(PushbackLineNumberReader reader) throws IOException {
        Satz satz;
        this.vorsatz.importFrom(reader);
        Map<SatzTyp, Version> satzartVersionen = this.vorsatz.getSatzartVersionen();
        while (true) {
            if ((satz = Datenpaket.importSatz(reader, satzartVersionen)).getSatzart() == 9999) break;
            this.datensaetze.add((Datensatz)satz);
        }
        this.nachsatz = (Nachsatz)satz;
        return this;
    }

    protected static Satz importSatz(PushbackLineNumberReader reader, Map<SatzTyp, Version> satzartVersionen) throws IOException {
        int satzart = Importer.of(reader).readSatzart();
        LOG.debug("Satzart {} wird importiert...", (Object)satzart);
        if (satzart == 9999) {
            return Datenpaket.importNachsatzFrom(reader);
        }
        return Datenpaket.importSatzFrom(reader, satzart, satzartVersionen);
    }

    private static Satz importSatzFrom(PushbackLineNumberReader reader, int satzart, Map<SatzTyp, Version> satzartVersionen) throws IOException {
        SatzTyp satzTyp = Importer.of(reader).readSatzTyp(satzart);
        Version wanted = satzartVersionen.get(satzTyp);
        if (wanted == null) {
            return Datenpaket.importDatensatz(reader, satzart);
        }
        Satz satz = SatzRegistry.getSatz(satzTyp, satzartVersionen.get(satzTyp).getInhalt());
        satz.importFrom(reader);
        return satz;
    }

    public static Satz importSatz(PushbackLineNumberReader reader) throws IOException {
        int satzart = Importer.of(reader).readSatzart();
        LOG.debug("reading Satzart " + satzart + "...");
        if (satzart == 9999) {
            return Datenpaket.importNachsatzFrom(reader);
        }
        return Datenpaket.importDatensatz(reader, satzart);
    }

    private static Nachsatz importNachsatzFrom(PushbackLineNumberReader reader) throws IOException {
        Nachsatz nachsatz = new Nachsatz();
        nachsatz.importFrom(reader);
        return nachsatz;
    }

    private static Satz importDatensatz(PushbackLineNumberReader reader, int satzart) throws IOException {
        SatzTyp satzTyp = Importer.of(reader).readSatzTyp(satzart);
        Satz satz = Datenpaket.getSatz(satzTyp);
        satz.importFrom(reader);
        return satz;
    }

    private static Satz getSatz(SatzTyp satzTyp) {
        try {
            return SatzRegistry.getInstance().getSatz(satzTyp);
        }
        catch (NotRegisteredException ex) {
            LOG.warn("Satzart '{}' ist nicht registriert und wird generiert.", (Object)satzTyp);
            LOG.debug("Details:", (Throwable)ex);
            Datensatz satz = new Datensatz(SatzTyp.of(satzTyp.getSatzart(), satzTyp.getSparte()));
            satz.addFiller();
            return satz;
        }
    }

    public void importFrom(File file) throws IOException {
        this.importFrom(file, Config.DEFAULT_ENCODING);
    }

    public void importFrom(File file, String encoding) throws IOException {
        this.importFrom(file, Charset.forName(encoding));
    }

    public void importFrom(File file, Charset encoding) throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);){
            this.importFrom(reader);
        }
    }

    public Datenpaket pack() {
        for (int i = 0; i < this.datensaetze.size(); ++i) {
            Datensatz ds = this.datensaetze.get(i);
            if (ds.getTeildatensaetze().size() == 0) continue;
            boolean nextVsnrReached = false;
            for (int j = i + 1; j < this.datensaetze.size() && !ds.isComplete() && !nextVsnrReached; ++j) {
                Optional<Datensatz> next = this.findNextDatensatzWithinVsnr(ds.getVersicherungsscheinNummer(), ds.getSatzTyp(), j);
                next.ifPresent(ds::mergeWith);
                if (next.isPresent()) continue;
                nextVsnrReached = true;
            }
        }
        this.removeEmptyDatensaetze();
        return this;
    }

    private void removeEmptyDatensaetze() {
        ArrayList<Datensatz> cleaned = new ArrayList<Datensatz>();
        for (Datensatz ds : this.datensaetze) {
            if (ds.getNumberOfTeildatensaetze() <= 0) continue;
            cleaned.add(ds);
        }
        this.datensaetze.clear();
        this.datensaetze.addAll(cleaned);
    }

    private Optional<Datensatz> findNextDatensatzWithinVsnr(String vsNr, SatzTyp satzTyp, int position) {
        for (int i = position; i < this.datensaetze.size(); ++i) {
            Datensatz ds = this.datensaetze.get(i);
            if (ds.getTeildatensaetze().size() == 0) continue;
            if (!ds.getVersicherungsscheinNummer().equals(vsNr)) break;
            if (!satzTyp.equals(ds.getSatzTyp())) continue;
            return Optional.of(ds);
        }
        return Optional.empty();
    }

    public void setErstellungsDatumVon(Datum d) {
        this.vorsatz.setErstellungsZeitraumVon(d);
    }

    public Datum getErstellungsDatumVon() {
        return this.vorsatz.getErstellungsZeitraumVon();
    }

    public void setErstellungsDatumBis(Datum d) {
        this.vorsatz.setErstellungsZeitraumBis(d);
    }

    public Datum getErstellungsDatumBis() {
        return this.vorsatz.getErstellungsZeitraumBis();
    }

    public void setAbsender(String absender) {
        this.vorsatz.setAbsender(absender);
    }

    public String getAbsender() {
        return this.vorsatz.getAbsender();
    }

    public void setAdressat(String s) {
        this.vorsatz.setAdressat(s);
    }

    public String getAdressat() {
        return this.vorsatz.getAdressat();
    }

    public void setVermittler(String s) {
        for (Satz satz : this.getAllSaetze()) {
            satz.setVermittler(s);
        }
    }

    public String getVermittler() {
        String vermittler = this.vorsatz.getVermittler();
        assert (vermittler.equals(this.nachsatz.getVermittler())) : this.vorsatz + " or " + this.nachsatz + " is corrupt";
        return vermittler;
    }

    @JsonIgnore
    public boolean isValid() {
        if (!this.vorsatz.isValid()) {
            LOG.info(this.vorsatz + " is not valid");
            return false;
        }
        if (!this.nachsatz.isValid()) {
            LOG.info(this.nachsatz + " is not valid");
            return false;
        }
        for (Satz satz : this.datensaetze) {
            if (satz.isValid()) continue;
            LOG.info(satz + " is not valid");
            return false;
        }
        if (!this.validateFolgenummern().isEmpty()) {
            LOG.info("Folgenummern stimmen nicht");
            return false;
        }
        if (!this.validateVUNummer().isEmpty()) {
            LOG.info("VU-Nummer is not set / not valid");
            return false;
        }
        return true;
    }

    public List<ConstraintViolation> validate() {
        return this.validate(this.config);
    }

    public List<ConstraintViolation> validate(Config validationConfig) {
        SatzValidator satzValidator = new SatzValidator(validationConfig);
        satzValidator.notice(this.vorsatz);
        for (Satz satz : this.datensaetze) {
            satzValidator.notice(satz);
        }
        satzValidator.notice(this.nachsatz);
        List<ConstraintViolation> violations = satzValidator.getViolations();
        violations.addAll(this.validateVUNummer());
        violations.addAll(this.nachsatz.validate(validationConfig));
        return violations;
    }

    private List<ConstraintViolation> validateVUNummer() {
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        if ("DUMMY".equals(this.getVuNummer())) {
            SimpleConstraintViolation cv = new SimpleConstraintViolation("VU-Nummer is not set", this, "DUMMY");
            violations.add(cv);
        }
        return violations;
    }

    private List<ConstraintViolation> validateFolgenummern() {
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        HashMap<String, Integer> folgenummern = new HashMap<String, Integer>();
        for (Datensatz datensatz : this.datensaetze) {
            String nr = datensatz.getVersicherungsscheinNummer().trim();
            String key = nr + datensatz.getSatzartFeld().getInhalt() + datensatz.getSparteFeld().getInhalt();
            Integer expected = folgenummern.computeIfAbsent(key, k -> 1);
            int folgenr = datensatz.getFolgenummer();
            if (folgenr == expected) continue;
            Integer n = expected;
            expected = expected + 1;
            folgenummern.put(key, expected);
            if (folgenr == expected) continue;
            SimpleConstraintViolation cv = new SimpleConstraintViolation("falsche Folgenummer (erwartet: " + expected + ")", datensatz, folgenr);
            violations.add(cv);
        }
        return violations;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.getVuNummer() + " with " + this.datensaetze.size() + "+2 (Daten-)Saetze";
    }

    private void setNachsatzSummenAus0200(Datensatz datensatz) {
        Betrag beitrag = datensatz.getFeld(Bezeichner.GESAMTBEITRAG_IN_WAEHRUNGSEINHEITEN, Betrag.class);
        this.nachsatz.addGesamtBeitrag(beitrag.toBigDecimal());
    }

    private void setNachsatzSummenAus0400(Datensatz datensatz) {
        BetragMitVorzeichen betrag = datensatz.getFeld(Bezeichner.GESAMTBEITRAG_BRUTTO_IN_WAEHRUNGSEINHEITEN, BetragMitVorzeichen.class);
        this.nachsatz.addGesamtBeitragBrutto(betrag.toBigDecimal());
        betrag = datensatz.getFeld(Bezeichner.GESAMTPROVISIONSBETRAG_IN_WAEHRUNGSEINHEITEN, BetragMitVorzeichen.class);
        this.nachsatz.addGesamtProvisionsBetrag(betrag.toBigDecimal());
    }

    private void setNachsatzSummenAus0500(Datensatz datensatz) {
        BetragMitVorzeichen betrag = datensatz.getFeld(Bezeichner.BETRAG_IN_WAEHRUNGSEINHEITEN_GEMAESS_ZAHLUNGSART, BetragMitVorzeichen.class);
        this.nachsatz.addVersicherungsLeistungen(betrag.toBigDecimal());
        betrag = datensatz.getFeld(Bezeichner.SCHADENBEARBEITUNGSKOSTEN_IN_WAEHRUNGSEINHEITEN, BetragMitVorzeichen.class);
        this.nachsatz.addSchadenbearbeitungskosten(betrag.toBigDecimal());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Datenpaket other = (Datenpaket)obj;
        return Objects.equals(this.vorsatz, other.vorsatz) && Datenpaket.isEquals(this.datensaetze, other.datensaetze) && Objects.equals(this.nachsatz, other.nachsatz);
    }

    private static boolean isEquals(List<Datensatz> d1, List<Datensatz> d2) {
        if (d1.size() != d2.size()) {
            return false;
        }
        for (int i = 0; i < d1.size(); ++i) {
            if (d1.get(i).equals(d2.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.datensaetze.size();
    }

    @Override
    public void notice(Satz satz) {
        try {
            if (satz.getSatzart() == 1) {
                LOG.info("Vorsatz {} wurde erkannt - {} wird zurueckgesetzt.", (Object)satz, (Object)this);
                this.datensaetze.clear();
                this.vorsatz.importFrom(satz.toLongString());
            } else if (satz.getSatzart() == 9999) {
                this.nachsatz.importFrom(satz.toLongString());
            } else {
                this.add((Datensatz)satz);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Import-Fehler in " + satz, ex);
        }
    }
}

