/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport;

import gdv.xport.Datenpaket;
import gdv.xport.config.Config;
import gdv.xport.event.ImportListener;
import gdv.xport.feld.Version;
import gdv.xport.io.Importer;
import gdv.xport.io.PushbackLineNumberReader;
import gdv.xport.io.RecordReader;
import gdv.xport.io.RecyclingInputStreamReader;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Vorsatz;
import gdv.xport.util.SatzTyp;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatenpaketStreamer {
    private final PushbackLineNumberReader reader;
    private final List<ImportListener> importListener = new ArrayList<ImportListener>();
    private Map<SatzTyp, Version> satzartVersionen = new HashMap<SatzTyp, Version>();

    public DatenpaketStreamer(InputStream istream) {
        this(new RecyclingInputStreamReader(istream, Config.DEFAULT_ENCODING));
    }

    public DatenpaketStreamer(Reader reader) {
        this.reader = new PushbackLineNumberReader(new RecordReader(reader), 256);
    }

    public void register(ImportListener listener) {
        this.importListener.add(listener);
    }

    public void readDatenpaket() throws IOException {
        Satz satz;
        this.readVorsatz();
        do {
            satz = Datenpaket.importSatz(this.reader, this.satzartVersionen);
            this.notice(satz);
        } while (satz.getSatzart() != 9999);
    }

    public boolean canReadDatenpaket() {
        try {
            return Importer.of(this.reader).readSatzart() == 1;
        }
        catch (IOException | NumberFormatException ex) {
            return false;
        }
    }

    private void readVorsatz() throws IOException {
        Vorsatz vorsatz = new Vorsatz();
        vorsatz.importFrom(this.reader);
        this.satzartVersionen = vorsatz.getSatzartVersionen();
        this.notice(vorsatz);
    }

    private void notice(Satz satz) {
        for (ImportListener listener : this.importListener) {
            listener.notice(satz);
        }
    }
}

