/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.config;

import gdv.xport.config.ConfigException;
import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Betrag;
import gdv.xport.feld.BetragMitVorzeichen;
import gdv.xport.feld.Datum;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.feld.Satznummer;
import gdv.xport.feld.VUNummer;
import gdv.xport.feld.Version;
import gdv.xport.feld.Zeichen;
import gdv.xport.satz.xml.FeldXml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Config
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(Config.class);
    private static Config instance = new Config();
    public static final Charset DEFAULT_ENCODING = StandardCharsets.ISO_8859_1;
    public static final String DEFAULT_ENCODING_NAME = DEFAULT_ENCODING.toString();
    public static final String DUMMY_VU_NUMMER = "DUMMY";
    public static final String GDV_VU_NUMMER = "gdv.VU-Nummer";
    public static final Config DEFAULT = new Config("/gdv/xport/config/default.properties");
    public static final Config EXPERIMENTAL = new Config("/gdv/xport/config/experimental.properties");
    public static final Config EMPTY = new Config(new Properties());
    public static final Config LAX = EMPTY.withProperty("gdv.feld.validate", "lax");
    public static final Config STRICT = EMPTY.withProperty("gdv.feld.validate", "strict");
    public static final Config VUVM2018 = DEFAULT;
    public static final Config VUVM2015 = DEFAULT.withProperty("gdv.XML-Resource", "VUVM2015.xml");
    public static final Config VUVM2013 = DEFAULT.withProperty("gdv.XML-Resource", "VUVM2013.xml");
    public static final Config VUVM2009 = DEFAULT.withProperty("gdv.XML-Resource", "VUVM2009.xml");
    private final Properties properties;
    private final Map<Class<? extends Feld>, Feld.Validator> defaultValidators = new HashMap<Class<? extends Feld>, Feld.Validator>();

    public static Config getInstance() {
        return instance;
    }

    public Config() {
        this(System.getProperty("gdv.config", "/gdv.properties"));
    }

    public Config(String resource) {
        this(Config.loadProperties(resource));
    }

    private Config(Properties props) {
        this.properties = props;
        this.defaultValidators.put(Feld.class, new Feld.Validator(this));
        this.defaultValidators.put(FeldXml.class, new Feld.Validator(this));
        this.defaultValidators.put(NumFeld.class, new NumFeld.Validator(this));
        this.defaultValidators.put(AlphaNumFeld.class, new AlphaNumFeld.Validator(this));
        this.defaultValidators.put(Zeichen.class, new AlphaNumFeld.Validator(this));
        this.defaultValidators.put(Satznummer.class, new AlphaNumFeld.Validator(this));
        this.defaultValidators.put(Betrag.class, new NumFeld.Validator(this));
        this.defaultValidators.put(BetragMitVorzeichen.class, new BetragMitVorzeichen.Validator(this));
        this.defaultValidators.put(Datum.class, new Datum.Validator(this));
        this.defaultValidators.put(VUNummer.class, new AlphaNumFeld.Validator(this));
        this.defaultValidators.put(Version.class, new Feld.Validator(this));
        this.init(this.defaultValidators, props);
    }

    private void init(Map<Class<? extends Feld>, Feld.Validator> validators, Properties props) {
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith("gdv.validator.")) continue;
            String classname = key.substring(14);
            this.addTo(validators, classname, props.getProperty(key));
        }
    }

    private void addTo(Map<Class<? extends Feld>, Feld.Validator> validators, String classname, String validatorName) {
        try {
            Class<?> feldClass = Class.forName(classname);
            Class<?> validatorClass = Class.forName(validatorName);
            Feld.Validator v = this.createValidator(validatorClass);
            validators.put(feldClass, v);
            LOG.info("Validator {} wurde fuer {} registriert.", (Object)v, (Object)feldClass);
        }
        catch (ReflectiveOperationException ex) {
            throw new ConfigException(String.format("Validator '%s' fuer '%s' nicht gefunden", validatorName, classname), ex);
        }
    }

    private Feld.Validator createValidator(Class<? extends Feld.Validator> validatorClass) throws ReflectiveOperationException {
        try {
            return validatorClass.getConstructor(Config.class).newInstance(this);
        }
        catch (ReflectiveOperationException ex) {
            LOG.debug("Verwende Default-Ctor, da {} keinen Config-Ctor hat.", (Object)validatorClass);
            LOG.trace("Details:", (Throwable)ex);
            return validatorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadProperties(String resource) {
        Properties properties2 = new Properties();
        try (InputStream input = Config.getInputStream(resource);){
            if (input == null) {
                LOG.info("default.properties werden geladen, da Resource '{}' nicht vorhanden.", (Object)resource);
                Properties properties3 = Config.loadProperties("/gdv/xport/config/default.properties");
                return properties3;
            }
            LOG.info("Properties werden aus '{}' eingelesen.", (Object)resource);
            properties2.load(input);
            Config.addGdvSystemProperties(properties2);
            Properties properties = properties2;
            return properties;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(String.format("'%s' ist fehlerhaft", resource), ex);
        }
    }

    private static InputStream getInputStream(String resource) throws FileNotFoundException {
        try {
            URI uri = new URI(resource);
            if (uri.getScheme() != null) {
                return Config.getInputStream(uri);
            }
        }
        catch (URISyntaxException ex) {
            LOG.debug("'{}' wird als Resource betrachtet ({}).", (Object)resource, (Object)ex);
            LOG.trace("Details:", (Throwable)ex);
        }
        return Config.class.getResourceAsStream(resource);
    }

    private static InputStream getInputStream(URI uri) throws FileNotFoundException {
        String scheme;
        switch (scheme = uri.getScheme().toLowerCase()) {
            case "file": {
                return new FileInputStream(new File(uri));
            }
            case "classpath": {
                return Config.getInputStream(uri.getPath());
            }
        }
        throw new UnsupportedOperationException(String.format("Schema '%s' in %s wird noch nicht unterstuetzt", scheme, uri));
    }

    private static void addGdvSystemProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("gdv.")) continue;
            props.setProperty(key, (String)entry.getValue());
        }
    }

    public Config withProperty(String key, String value) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        props.setProperty(key, value);
        return new Config(props);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public Feld.Validator getValidatorFor(Class<? extends Feld> clazz) {
        return this.defaultValidators.get(clazz);
    }

    public String getString(String key) {
        return this.properties.getProperty(key, "");
    }

    public boolean getBool(String key) {
        return Boolean.parseBoolean(this.getProperty(key, "false"));
    }

    @Deprecated
    public static synchronized void reset() {
        LOG.warn("reset() ist ohne Version und wird in kuenftigen Versionen entfernt.");
    }

    @Deprecated
    public static synchronized void setVUNummer(String nr) {
        Config.setVUNummer(new VUNummer(nr));
    }

    @Deprecated
    public static synchronized void setVUNummer(VUNummer nr) {
        if (!Config.getVUNummer().equals(nr)) {
            instance = Config.createConfigWith(GDV_VU_NUMMER, nr.getInhalt());
            LOG.info("konfigurierte VU-Nummer: " + nr);
        }
    }

    @Deprecated
    public static synchronized VUNummer getVUNummer() {
        return new VUNummer(instance.getProperty(GDV_VU_NUMMER, DUMMY_VU_NUMMER));
    }

    public VUNummer getVUNr() {
        return new VUNummer(this.getString(GDV_VU_NUMMER));
    }

    public boolean isDebug() {
        return this.getBool("gdv.debug");
    }

    public ValidateMode getValidateMode() {
        return ValidateMode.of(this.getProperty("gdv.feld.validate", "off"));
    }

    public static String getXmlResource() {
        return System.getProperty("gdv.XML-Resource", "VUVM2018.xml");
    }

    @Deprecated
    public static synchronized void setEOD(String linefeed) {
        if (Objects.equals(Config.getEOD(), linefeed)) {
            instance = Config.createConfigWith("gdv.eod", linefeed);
        }
    }

    private static Config createConfigWith(String key, String value) {
        Properties props = new Properties(Config.instance.properties);
        props.setProperty(key, value);
        return new Config(props);
    }

    public static synchronized String getEOD() {
        return instance.getString("gdv.eod");
    }

    public static synchronized boolean hasEOD() {
        return StringUtils.isNotEmpty(Config.getEOD());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config config = (Config)o;
        return this.properties.equals(config.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.properties;
    }

    public static enum ValidateMode {
        OFF,
        LAX,
        STRICT;


        public static ValidateMode of(String value) {
            String s = value.toUpperCase();
            for (ValidateMode mode : ValidateMode.values()) {
                if (!mode.name().equals(s)) continue;
                return mode;
            }
            if ("TRUE".equals(s) || "ON".equals(s)) {
                return LAX;
            }
            LOG.debug("'{}' wird als 'OFF' interpretiert.", (Object)s);
            return OFF;
        }
    }
}

