/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.demo;

import gdv.xport.Datenpaket;
import gdv.xport.feld.Bezeichner;
import gdv.xport.satz.Satz;
import gdv.xport.util.SatzFactory;
import gdv.xport.util.SatzTyp;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ImportExport {
    private static final Logger LOG = LogManager.getLogger(ImportExport.class);

    public static void exportSatz100(File file) throws IOException {
        Satz satz100 = SatzFactory.getSatz(SatzTyp.of("0100"));
        satz100.setFeld(Bezeichner.ANREDESCHLUESSEL, 1);
        satz100.setFeld(Bezeichner.NAME1, "Duck");
        satz100.setFeld(Bezeichner.NAME3, "Dagobert");
        satz100.setFeld(Bezeichner.GESCHLECHT, "1");
        satz100.export(file);
    }

    public static Satz importSatz100(File file) throws IOException {
        Satz satz100 = SatzFactory.getSatz(SatzTyp.of("0100"));
        satz100.importFrom(file);
        LOG.info("Datensatz " + satz100.getSatzart() + " von " + satz100.getFeld(Bezeichner.NAME3) + " " + satz100.getFeld(Bezeichner.NAME1) + " importiert.");
        return satz100;
    }

    public static List<Datenpaket> importDatenpakete(InputStream inputStream) throws IOException {
        ArrayList<Datenpaket> datenpakete = new ArrayList<Datenpaket>();
        while (inputStream.available() >= 0) {
            Datenpaket paket = new Datenpaket();
            try {
                paket.importFrom(inputStream);
                datenpakete.add(paket);
            }
            catch (EOFException ex) {
                LOG.info("EOF nach " + datenpakete.size() + " Datenpaketen erreicht.", (Throwable)ex);
                break;
            }
        }
        return datenpakete;
    }

    private ImportExport() {
    }
}

