/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.event;

import gdv.xport.config.Config;
import gdv.xport.event.ImportListener;
import gdv.xport.satz.Satz;
import gdv.xport.util.SimpleConstraintViolation;
import java.util.ArrayList;
import java.util.List;
import net.sf.oval.ConstraintViolation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SatzValidator
implements ImportListener {
    private static final Logger LOG = LogManager.getLogger();
    private final Config config;
    private final List<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
    private int satzNr = 1;
    private int tdsNr = 1;

    public SatzValidator() {
        this(Config.STRICT);
    }

    public SatzValidator(Config config) {
        this.config = config;
    }

    @Override
    public void notice(Satz satz) {
        List<ConstraintViolation> constraintViolations = satz.validate(this.config);
        if (!constraintViolations.isEmpty()) {
            LOG.warn("Record {} Satz {} {}:", (Object)this.tdsNr, (Object)this.satzNr, (Object)satz.toShortString());
            for (ConstraintViolation cv : constraintViolations) {
                LOG.warn("\t* {}", (Object)cv);
                if (!(cv instanceof SimpleConstraintViolation)) continue;
                SatzValidator.logViolations((SimpleConstraintViolation)cv);
            }
        }
        ++this.satzNr;
        this.tdsNr += satz.getNumberOfTeildatensaetze();
        this.violations.addAll(constraintViolations);
    }

    private static void logViolations(SimpleConstraintViolation scv) {
        for (ConstraintViolation cv : scv.getViolations()) {
            LOG.warn("\t\t* {}", (Object)cv);
        }
    }

    public List<ConstraintViolation> getViolations() {
        return this.violations;
    }
}

