/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import de.jfachwert.FachwertFactory;
import gdv.xport.config.Config;
import gdv.xport.feld.Align;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.util.SimpleConstraintViolation;
import java.io.Serializable;
import java.util.List;
import javax.validation.ValidationException;
import net.sf.oval.ConstraintViolation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlphaNumFeld
extends Feld {
    private static final Logger LOG = LogManager.getLogger();
    private static final Validator DEFAULT_VALIDATOR = new Validator(Config.getInstance());

    @Deprecated
    public AlphaNumFeld(String name, String s) {
        this(Bezeichner.of(name), s.length(), 1);
        this.setInhalt(s);
    }

    public AlphaNumFeld(Bezeichner bezeichner, int length, int start) {
        this(bezeichner, length, start, Align.LEFT);
    }

    public AlphaNumFeld(Bezeichner bezeichner, int length, int start, Align alignment) {
        super(bezeichner, length, start, alignment, Config.getInstance());
    }

    @Deprecated
    public AlphaNumFeld(int length, int start) {
        this(length, start, Align.LEFT);
    }

    @Deprecated
    public AlphaNumFeld(int length, int start, Align alignment) {
        this(Bezeichner.of("NN"), length, start, alignment);
    }

    public AlphaNumFeld(Feld other) {
        super(other);
    }

    protected AlphaNumFeld(AlphaNumFeld other, Config c) {
        super(other, c);
    }

    @Override
    public AlphaNumFeld mitConfig(Config c) {
        return new AlphaNumFeld(this, c);
    }

    @Override
    public Object clone() {
        return new AlphaNumFeld(this);
    }

    @Override
    public List<ConstraintViolation> validate(Config validationConfig) {
        List<ConstraintViolation> violations = super.validate(validationConfig);
        if (this.hasValue()) {
            try {
                String name = this.getBezeichner().getName();
                FachwertFactory.getInstance().validate(name, new Serializable[]{this.getInhalt().trim()});
            }
            catch (ValidationException ex) {
                SimpleConstraintViolation cv = new SimpleConstraintViolation(this, ex);
                violations.add(cv);
            }
        }
        return violations;
    }

    public static class Validator
    extends Feld.Validator {
        public Validator() {
        }

        public Validator(Config config) {
            super(config);
        }

        @Override
        protected String validateStrict(String value) {
            String trimmed = this.validateLax(value).trim();
            if (trimmed.length() < value.length() && trimmed.length() > 0) {
                LOG.debug("Wert '{}' wurde auf '{}' fuer die weitere Verabeitung verkuerzt.", (Object)value, (Object)trimmed);
            }
            return trimmed;
        }
    }
}

