/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import gdv.xport.config.Config;
import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Betrag;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BetragMitVorzeichen
extends Betrag {
    private static final Logger LOG = LogManager.getLogger();
    private static final Validator DEFAULT_VALIDATOR = new Validator(Config.getInstance());

    public BetragMitVorzeichen(Bezeichner name, int length, int start) {
        this(name, length, start, Config.getInstance());
    }

    public BetragMitVorzeichen(Bezeichner name, int length, int start, Config config) {
        super(name, start, StringUtils.repeat('0', length - 1) + "+", config);
        this.setVorzeichen('+');
    }

    private BetragMitVorzeichen(BetragMitVorzeichen other, Config config) {
        this(other.getBezeichner(), other.getAnzahlBytes(), other.getByteAdresse(), config);
    }

    public BetragMitVorzeichen(Feld other) {
        super(other);
    }

    @Override
    public BetragMitVorzeichen mitConfig(Config c) {
        return new BetragMitVorzeichen(this, c);
    }

    public void setVorzeichen(char c) {
        this.setInhalt(c, this.getAnzahlBytes() - 1);
    }

    public char getVorzeichen() {
        String s = this.getInhalt();
        return s.charAt(s.length() - 1);
    }

    public Betrag getBetrag() {
        String name = this.getBezeichnung();
        name = name.endsWith("mit Vorzeichen") ? name.substring(0, name.length() - 15).trim() : name + " ohne Vorzeichen";
        Betrag betrag = new Betrag(Bezeichner.of(name), this.getAnzahlBytes() - 1, this.getByteAdresse());
        betrag.setInhalt(this.getInhalt().substring(0, betrag.getAnzahlBytes()));
        return betrag;
    }

    @Override
    public void setInhalt(double x) {
        long n = Math.round(x * 100.0);
        this.setInhalt(n);
    }

    @Override
    public void setInhalt(BigDecimal x) {
        int n = this.getNachkommastellen();
        this.setInhalt(x.setScale(n, RoundingMode.HALF_UP).doubleValue());
    }

    @Override
    public void setInhalt(long n) {
        String pattern = StringUtils.repeat("0", this.getAnzahlBytes() - 1);
        DecimalFormat format = new DecimalFormat(pattern);
        String formatted = format.format(Math.abs(n));
        if (n >= 0L) {
            this.setInhalt(formatted + '+');
        } else {
            this.setInhalt(formatted + '-');
        }
    }

    @Override
    public void setInhalt(String value) {
        if (value == null) {
            throw new IllegalArgumentException(this + " darf nicht mit null belegt werden");
        }
        char firstChar = (value + " ").charAt(0);
        String s = firstChar == '+' || firstChar == '-' ? value.substring(1) + firstChar : value;
        char lastChar = StringUtils.reverse(" " + s).charAt(0);
        if (lastChar != '+' && lastChar != '-') {
            super.setInhalt(s + "+");
        } else {
            super.setInhalt(s);
        }
    }

    @Override
    protected String truncate(String s) {
        if (s.length() <= this.getAnzahlBytes()) {
            return s;
        }
        String number = super.truncate(s).substring(0, this.getAnzahlBytes() - 1);
        return number + s.charAt(s.length() - 1);
    }

    @Override
    public double toDouble() {
        return this.toBigDecimal().doubleValue();
    }

    @Override
    public BigDecimal toBigDecimal() {
        String s = this.getInhalt();
        String n = s.substring(0, s.length() - 1);
        if (StringUtils.isBlank(n)) {
            return BigDecimal.ZERO;
        }
        BigDecimal x = new BigDecimal(Long.parseLong(n)).movePointLeft(this.getNachkommastellen());
        return this.getVorzeichen() == '-' ? x.negate() : x;
    }

    @Override
    public int toInt() {
        String s = this.getInhalt();
        int x = Integer.parseInt(s.substring(0, s.length() - 1)) / 100;
        return this.getVorzeichen() == '-' ? -x : x;
    }

    @Override
    public long toLong() {
        String s = this.getInhalt();
        long x = Long.parseLong(s.substring(0, s.length() - 1)) / 100L;
        return this.getVorzeichen() == '-' ? -x : x;
    }

    @Override
    public void resetInhalt() {
        super.resetInhalt();
        this.setVorzeichen('+');
    }

    @Override
    public Object clone() {
        return new BetragMitVorzeichen(this);
    }

    public static BetragMitVorzeichen of(NumFeld betrag, AlphaNumFeld vorzeichen) {
        if (betrag.getEndAdresse() + 1 != vorzeichen.getByteAdresse()) {
            throw new IllegalArgumentException("gap between " + betrag + " and " + vorzeichen + " (cannot merge)");
        }
        BetragMitVorzeichen bmv = new BetragMitVorzeichen(Bezeichner.of(betrag.getBezeichnung() + " mit Vorzeichen"), betrag.getAnzahlBytes() + 1, betrag.getByteAdresse());
        bmv.setInhalt(betrag.getInhalt() + vorzeichen.getInhalt());
        return bmv;
    }

    public static class Validator
    extends NumFeld.Validator {
        public Validator() {
        }

        public Validator(Config config) {
            super(config);
        }

        @Override
        protected String validateLax(String nummer) {
            LOG.debug("{} wird als Betrag mit Vorzeichen validiert.", (Object)nummer);
            if (StringUtils.isNotBlank(nummer)) {
                char vorzeichen = nummer.charAt(nummer.length() - 1);
                if (vorzeichen != '+' && vorzeichen != '-') {
                    throw new ValidationException(String.format("'%s' hat falsches Vorzeichen ('%c')", nummer, Character.valueOf(vorzeichen)));
                }
                super.validateLax(nummer.substring(0, nummer.length() - 1));
            }
            return nummer;
        }

        @Override
        protected String validateStrict(String value) {
            if (value.startsWith("+")) {
                return super.validateStrict(value.substring(1));
            }
            return super.validateStrict(value);
        }
    }
}

