/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import de.jfachwert.Fachwert;
import de.jfachwert.SimpleValidator;
import de.jfachwert.pruefung.exception.InvalidValueException;
import java.io.Serializable;
import org.apache.commons.lang3.Range;

public class ByteAdresse
extends Number
implements Fachwert {
    private static final Validator VALIDATOR = new Validator();
    final byte adresse;
    public static final ByteAdresse VU_NUMMER = ByteAdresse.of(5);
    public static final ByteAdresse VERSICHERUNGSSCHEINNUMMER = ByteAdresse.of(14);

    private ByteAdresse(int adresse) {
        this.adresse = (byte)(VALIDATOR.verify(adresse) - 129);
    }

    public static ByteAdresse of(int n) {
        return new ByteAdresse(n);
    }

    public static ByteAdresse of(byte n) {
        return new ByteAdresse(129 + n);
    }

    @Override
    public byte byteValue() {
        return this.adresse;
    }

    @Override
    public int intValue() {
        return 129 + this.adresse;
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    public String toString() {
        return Integer.toString(this.intValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteAdresse that = (ByteAdresse)o;
        return this.adresse == that.adresse;
    }

    public int hashCode() {
        return this.adresse;
    }

    public static class Validator
    implements SimpleValidator<Integer> {
        @Override
        public Integer validate(Integer n) {
            if (n < 1 || n > 256) {
                throw new InvalidValueException((Serializable)n, "Adresse", Range.between(1, 256));
            }
            return n;
        }
    }
}

