/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Betrag;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Datum;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.feld.VUNummer;
import gdv.xport.feld.Zeichen;
import gdv.xport.util.ShitHappenedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum Datentyp {
    VUNUMMER(VUNummer.class),
    ZEICHEN(Zeichen.class),
    ALPHANUMERISCH(AlphaNumFeld.class),
    DATUM(Datum.class),
    BETRAG(Betrag.class),
    FLIESSKOMMA(NumFeld.class),
    NUMERISCH(NumFeld.class),
    UHRZEIT(NumFeld.class),
    UNBEKANNT(Feld.class);

    private static final Logger LOG;
    private final Class<? extends Feld> feldClass;

    private Datentyp(Class<? extends Feld> clazz) {
        this.feldClass = clazz;
    }

    public Class<? extends Feld> asClass() {
        return this.feldClass;
    }

    public Feld asFeld(Bezeichner bezeichner, int anzahlBytes, int byteAddress) {
        Class<? extends Feld> clazz = this.asClass();
        try {
            Constructor<? extends Feld> ctor = this.getConstructor(clazz);
            return ctor.newInstance(bezeichner, anzahlBytes, byteAddress);
        }
        catch (SecurityException ex) {
            throw new ShitHappenedException("cannot instantiate " + clazz, ex);
        }
        catch (InstantiationException ex) {
            throw new ShitHappenedException("cannot instantiate " + clazz, ex);
        }
        catch (IllegalAccessException ex) {
            throw new ShitHappenedException("cannot access constructor of " + clazz, ex);
        }
        catch (InvocationTargetException ex) {
            throw new ShitHappenedException("cannot invoke " + clazz, ex);
        }
    }

    private Constructor<? extends Feld> getConstructor(Class<? extends Feld> clazz) {
        try {
            Constructor<? extends Feld> ctor = clazz.getConstructor(Bezeichner.class, Integer.TYPE, Integer.TYPE);
            return ctor;
        }
        catch (NoSuchMethodException ex) {
            LOG.debug("{} hat keinen public Constructor ({}).", (Object)clazz, (Object)ex.getMessage());
            LOG.trace("Details:", (Throwable)ex);
            for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
                Class<?>[] types = ctor.getParameterTypes();
                if (types.length != 3 || !types[0].isAssignableFrom(Bezeichner.class) || !types[1].isAssignableFrom(Integer.TYPE) || !types[2].isAssignableFrom(Integer.TYPE)) continue;
                ctor.setAccessible(true);
                return ctor;
            }
            throw new ShitHappenedException("cannot find needed constructor of " + clazz, ex);
        }
    }

    public String capitalize() {
        return WordUtils.capitalize(this.toString().toLowerCase());
    }

    public static Datentyp asValue(String name) {
        return Datentyp.valueOf(name.toUpperCase());
    }

    public static String asString(Feld feld) {
        if (feld instanceof NumFeld && !(feld instanceof Betrag) && !(feld instanceof Datum)) {
            NumFeld n = (NumFeld)feld;
            if (n.getNachkommastellen() > 0) {
                return FLIESSKOMMA.capitalize();
            }
            return NUMERISCH.capitalize();
        }
        return Datentyp.asString(feld.getClass());
    }

    public static String asString(Class<? extends Feld> clazz) {
        for (Datentyp t : Datentyp.values()) {
            if (!t.feldClass.isAssignableFrom(clazz)) continue;
            return WordUtils.capitalize(t.toString().toLowerCase());
        }
        throw new IllegalArgumentException("no presentation available for " + clazz);
    }

    static {
        LOG = LogManager.getLogger();
    }
}

