/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import gdv.xport.config.Config;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.util.SimpleConstraintViolation;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import net.sf.oval.ConstraintViolation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Datum
extends NumFeld {
    private static final Logger LOG = LogManager.getLogger(Feld.class);
    private static final Feld.Validator DEFAULT_VALIDATOR = new Validator(Config.getInstance());
    private final SimpleDateFormat dateFormat;

    public Datum(Feld other) {
        this(other, other.config);
    }

    private Datum(Feld other, Config cfg) {
        super(other, cfg);
        this.dateFormat = Datum.getDateFormat(other.getAnzahlBytes());
    }

    public Datum(Bezeichner bezeichner, int start) {
        this(bezeichner, 8, start);
    }

    public Datum(String name, int start) {
        this(Bezeichner.of(name), 8, start);
    }

    public Datum(String name, String inhalt) {
        this(name, inhalt.length(), 1, inhalt);
    }

    public Datum(Bezeichner bezeichner, int length, int start) {
        super(bezeichner, length, start);
        this.dateFormat = Datum.getDateFormat(length);
    }

    public Datum(String name, int length, int start, String inhalt) {
        this(Bezeichner.of(name), length, start);
        this.setInhalt(inhalt);
    }

    private Datum() {
        this(Bezeichner.of("Datum"), 8, 1);
    }

    public Datum(Datum other) {
        super(other);
        this.dateFormat = other.dateFormat;
    }

    @Override
    public Datum mitConfig(Config c) {
        return new Datum(this, c);
    }

    private static SimpleDateFormat getDateFormat(int length) {
        return Datum.getDateFormat(length, "");
    }

    private static SimpleDateFormat getDateFormat(int length, String separator) {
        switch (length) {
            case 2: {
                return new SimpleDateFormat("dd");
            }
            case 4: {
                return new SimpleDateFormat("MM" + separator + "yy");
            }
            case 6: {
                return new SimpleDateFormat("MM" + separator + "yyyy");
            }
            case 8: {
                return new SimpleDateFormat("dd" + separator + "MM" + separator + "yyyy");
            }
        }
        throw new IllegalArgumentException("length=" + length + " not allowed - only 2, 4, 6 or 8");
    }

    public void setInhalt(Datum d) {
        this.setInhalt(d.getInhalt());
    }

    public void setInhalt(Date d) {
        this.setInhalt(this.dateFormat.format(d));
    }

    @Override
    public void setInhalt(String neuerInhalt) {
        if (!Datum.isEmpty(neuerInhalt)) {
            Validator validator = (Validator)this.getValidator();
            String string = validator.verifyFormat(this.dateFormat, neuerInhalt);
        }
        super.setInhalt(neuerInhalt);
    }

    public void setInhalt(LocalDate localDate) {
        this.setInhalt(Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
    }

    @Override
    public BigDecimal add(BigDecimal anzahlTage) {
        LocalDate d = this.toLocalDate();
        d = d.plusDays(anzahlTage.intValue());
        this.setInhalt(d);
        return this.toBigDecimal();
    }

    public Date toDate() {
        try {
            return this.dateFormat.parse(this.getInhalt());
        }
        catch (ParseException e) {
            throw new IllegalStateException(this + " has an invalid date (\"" + this.getInhalt() + "\")");
        }
    }

    public LocalDate toLocalDate() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.dateFormat.toPattern());
        return LocalDate.parse(this.getInhalt(), formatter);
    }

    public static Datum heute() {
        Datum d = new Datum();
        d.setInhalt(new Date());
        return d;
    }

    @Override
    public boolean isEmpty() {
        if (super.isEmpty()) {
            return true;
        }
        return Datum.isEmpty(this.getInhalt());
    }

    private static boolean isEmpty(String value) {
        try {
            int n = Integer.parseInt(value);
            return n == 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isValid() {
        if (this.isEmpty()) {
            return true;
        }
        return this.hasValidDate();
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid();
    }

    private boolean hasValidDate() {
        Validator validator = (Validator)this.getValidator();
        try {
            validator.validateFormat(this.dateFormat, this.getInhalt());
            return true;
        }
        catch (ValidationException e) {
            LOG.info(e + " -> mapped to false");
            return false;
        }
    }

    @Override
    public List<ConstraintViolation> validate() {
        List<ConstraintViolation> violations = super.validate();
        if (!this.isEmpty() && !this.hasValidDate()) {
            SimpleConstraintViolation cv = new SimpleConstraintViolation("'" + this.getInhalt() + "' is not a valid date", this);
            violations.add(cv);
        }
        return violations;
    }

    @Override
    public String format() {
        SimpleDateFormat df = Datum.getDateFormat(this.getAnzahlBytes(), ".");
        return df.format(this.toDate());
    }

    public String getFormat() {
        return this.dateFormat.toPattern().replace('y', 'J').replace('d', 'T');
    }

    @Override
    public Object clone() {
        return new Datum(this);
    }

    public static class Validator
    extends NumFeld.Validator {
        public Validator() {
        }

        public Validator(Config config) {
            super(config);
        }

        protected String verifyFormat(DateFormat format, String value) {
            if (this.getConfig().getValidateMode() == Config.ValidateMode.STRICT && format != null) {
                try {
                    return this.validateFormat(format, value);
                }
                catch (ValidationException ex) {
                    throw new IllegalArgumentException("kein Datum: " + value, ex);
                }
            }
            return value;
        }

        protected String validateFormat(DateFormat format, String value) {
            try {
                Date date = format.parse(value);
                String converted = format.format(date);
                if (!value.equals(converted)) {
                    throw new ValidationException(String.format("'%s' ist kein korrektes Datum - ist vielleicht '%s' gemeint?", value, converted));
                }
            }
            catch (ParseException ex) {
                throw new ValidationException(String.format("'%s' ist kein Datum", value), ex);
            }
            return value;
        }
    }
}

