/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.jfachwert.SimpleValidator;
import de.jfachwert.Text;
import gdv.xport.config.Config;
import gdv.xport.feld.Align;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.ByteAdresse;
import gdv.xport.util.SimpleConstraintViolation;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ValidationException;
import net.sf.oval.ConstraintViolation;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Feld
implements Comparable<Feld>,
Cloneable,
Serializable {
    private static final Logger LOG = LogManager.getLogger(Feld.class);
    private static final Validator DEFAULT_VALIDATOR = new Validator(Config.getInstance());
    public static final Feld NULL_FELD = new Feld();
    private final Bezeichner bezeichner;
    protected String inhalt;
    private final byte byteAdresse;
    private final byte length;
    private byte ausrichtung;
    protected final Config config;

    public Feld() {
        this(Bezeichner.UNBEKANNT, 213, 43, Align.LEFT);
    }

    public Feld(String name, String s, Align alignment) {
        this(Bezeichner.of(name), 1, s, alignment);
    }

    public Feld mitConfig(Config c) {
        return new Feld(this, c);
    }

    public Feld(Bezeichner name, int start, String s, Align alignment) {
        this.bezeichner = name;
        this.inhalt = s;
        this.length = Feld.toByteLength(s.length());
        this.byteAdresse = ByteAdresse.of(start).byteValue();
        this.ausrichtung = alignment.getCode();
        this.config = Config.getInstance();
    }

    private static byte toByteLength(int n) {
        if (n > 0) {
            return ByteAdresse.of(n).byteValue();
        }
        return ByteAdresse.of(1).byteValue();
    }

    public Feld(Bezeichner bezeichner, int length, int start, Align alignment) {
        this(bezeichner, length, start, alignment, Config.getInstance());
    }

    protected Feld(Bezeichner bezeichner, int length, int start, Align alignment, Config config) {
        this.bezeichner = bezeichner;
        this.inhalt = StringUtils.repeat(" ", length);
        this.length = Feld.toByteLength(length);
        this.byteAdresse = ByteAdresse.of(start).byteValue();
        this.ausrichtung = alignment.getCode();
        this.config = config;
    }

    public Feld(String name, int length, int start, char c, Align alignment) {
        this(Bezeichner.of(name), length, start, alignment);
        this.setInhalt(c);
    }

    public Feld(String name, int length, int start, String s, Align alignment) {
        this(Bezeichner.of(name), length, start, alignment);
        this.setInhalt(s);
    }

    public Feld(String name, int start, char c) {
        this(name, 1, start, c, Align.LEFT);
    }

    public Feld(int start, String s, Align alignment) {
        this.inhalt = s;
        this.length = Feld.toByteLength(s.length());
        this.byteAdresse = ByteAdresse.of(start).byteValue();
        this.ausrichtung = alignment.getCode();
        this.bezeichner = this.createBezeichner();
        this.config = Config.getInstance();
    }

    @Deprecated
    public Feld(int length, Align alignment) {
        this(length, 1, alignment);
    }

    @Deprecated
    public Feld(int length, int start, Align alignment) {
        this.inhalt = StringUtils.repeat(" ", length);
        this.length = Feld.toByteLength(length);
        this.byteAdresse = ByteAdresse.of(start).byteValue();
        this.ausrichtung = alignment.getCode();
        this.bezeichner = this.createBezeichner();
        this.config = Config.getInstance();
    }

    public Feld(Feld other) {
        this(other.getBezeichner(), other.getAnzahlBytes(), other.getByteAdresse(), other.getAusrichtung(), other.config);
        this.setInhalt(other.getInhalt());
    }

    protected Feld(Feld other, Config cfg) {
        this(other.getBezeichner(), other.getAnzahlBytes(), other.getByteAdresse(), other.getAusrichtung(), cfg);
        this.setInhalt(other.getInhalt());
    }

    public Align getAusrichtung() {
        return Align.of(this.ausrichtung);
    }

    @Deprecated
    protected Align getDefaultAlignment() {
        return Align.LEFT;
    }

    public void setAusrichtung(Align alignment) {
        this.ausrichtung = alignment.getCode();
    }

    private Bezeichner createBezeichner() {
        return Bezeichner.of(this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()));
    }

    public String getBezeichnung() {
        return this.bezeichner.getName();
    }

    public Bezeichner getBezeichner() {
        return this.bezeichner;
    }

    public void setInhalt(String neuerInhalt) {
        int anzahlBytes = this.getAnzahlBytes();
        String s = this.getValidator().verify(neuerInhalt, this);
        String string = s = this.config.getBool("gdv.feld.truncate") ? this.truncate(s) : s;
        if (s.length() > anzahlBytes) {
            throw new IllegalArgumentException("Feld " + this.getBezeichner() + ": Parameter \"" + s + "\" ist laenger als " + anzahlBytes + " Zeichen!");
        }
        if (s.length() != anzahlBytes) {
            this.resetInhalt();
        }
        this.inhalt = this.pack(s);
    }

    protected String pack(String s) {
        if (this.getAusrichtung() == Align.LEFT) {
            return StringUtils.stripEnd(s, " ");
        }
        return StringUtils.stripStart(s, " ");
    }

    protected String truncate(String s) {
        if (s.length() <= this.getAnzahlBytes()) {
            return s;
        }
        return s.substring(0, this.getAnzahlBytes());
    }

    public void setInhalt(BigInteger n) {
        this.setInhalt(n.toString());
    }

    public void setInhalt(BigDecimal n) {
        this.setInhalt(n.toString());
    }

    public void setInhalt(long n) {
        this.setInhalt(Long.toString(n));
    }

    @JsonIgnore
    public void setInhalt(char c) {
        this.resetInhalt();
        this.setInhalt(c, 0);
    }

    public void setInhalt(char c, int i) {
        StringBuilder sb = new StringBuilder(this.getInhalt());
        sb.setCharAt(i, c);
        this.inhalt = sb.toString();
    }

    public String getInhalt() {
        String blanks = StringUtils.repeat(' ', this.getAnzahlBytes() - this.inhalt.length());
        if (this.getAusrichtung() == Align.LEFT) {
            return this.inhalt + blanks;
        }
        return blanks + this.inhalt;
    }

    public Feld withInhalt(String inhalt) {
        this.setInhalt(inhalt);
        return this;
    }

    public void resetInhalt() {
        int anzahlBytes = this.getAnzahlBytes();
        this.inhalt = StringUtils.repeat(" ", anzahlBytes);
    }

    @Deprecated
    public void setAnzahlBytes(int n) {
        this.inhalt = this.inhalt + StringUtils.repeat(" ", n - this.inhalt.length());
    }

    public final int getAnzahlBytes() {
        return ByteAdresse.of(this.length).intValue();
    }

    public final int getByteAdresse() {
        return ByteAdresse.of(this.byteAdresse).intValue();
    }

    public final int getEndAdresse() {
        return this.getByteAdresse() + this.getAnzahlBytes() - 1;
    }

    public final boolean overlapsWith(Feld other) {
        if (this.byteAdresse == other.byteAdresse) {
            return false;
        }
        if (this.byteAdresse < other.byteAdresse) {
            return this.getEndAdresse() >= other.getByteAdresse();
        }
        return other.getEndAdresse() >= this.getByteAdresse();
    }

    public final void write(Writer writer) throws IOException {
        writer.write(this.inhalt);
    }

    public boolean isEmpty() {
        return StringUtils.isBlank(this.getInhalt());
    }

    public boolean hasValue() {
        String value = this.getInhalt();
        return StringUtils.isNotBlank(this.getAusrichtung().compareTo(Align.RIGHT) == 0 ? StringUtils.replaceChars(value, '0', ' ') : value);
    }

    public boolean isValid() {
        if (this.getByteAdresse() < 1) {
            return false;
        }
        if (this.getEndAdresse() > 256) {
            return false;
        }
        if (this.getAusrichtung() == Align.UNKNOWN) {
            return false;
        }
        return this.validate().isEmpty();
    }

    public boolean isInvalid() {
        return !this.isValid();
    }

    public List<ConstraintViolation> validate() {
        return this.validate(Config.LAX);
    }

    public List<ConstraintViolation> validate(Config validationConfig) {
        List<ConstraintViolation> violations = this.validateInvariants();
        if (this.getEndAdresse() > 256) {
            SimpleConstraintViolation cv = new SimpleConstraintViolation(this + ": Endadresse ueberschritten", this, this.getEndAdresse());
            violations.add(cv);
        }
        try {
            this.getValidator().validate(this.getInhalt(), validationConfig);
        }
        catch (ValidationException ex) {
            SimpleConstraintViolation cv = new SimpleConstraintViolation(this, ex);
            violations.add(cv);
        }
        return violations;
    }

    private List<ConstraintViolation> validateInvariants() {
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        if (this.getAusrichtung() == Align.UNKNOWN) {
            violations.add(new SimpleConstraintViolation("Ausrichtung darf nicht UNKNOWN sein", this, this.ausrichtung));
        }
        return violations;
    }

    public String format() {
        return this.getInhalt();
    }

    public String toString() {
        return this.toShortString() + ": \"" + this.getInhalt() + "\"";
    }

    public String toShortString() {
        return this.getClass().getSimpleName() + " " + this.getBezeichner() + " (" + this.getByteAdresse() + "-" + this.getEndAdresse() + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Feld)) {
            return false;
        }
        Feld other = (Feld)obj;
        return this.bezeichner.equals(other.bezeichner) && this.getInhalt().equals(other.getInhalt()) && this.byteAdresse == other.byteAdresse;
    }

    public int hashCode() {
        return this.byteAdresse + this.getInhalt().hashCode();
    }

    @Override
    public final int compareTo(Feld other) {
        return this.byteAdresse - other.byteAdresse;
    }

    @JsonIgnore
    public Validator getValidator() {
        return this.config.getValidatorFor(this.getClass());
    }

    public Object clone() {
        return new Feld(this);
    }

    public static class Validator
    implements SimpleValidator<String> {
        private final Config config;

        public Validator() {
            this(Config.LAX);
        }

        public Validator(Config config) {
            this.config = config;
        }

        protected Config getConfig() {
            return this.config;
        }

        public String verify(String value, Feld validatedFeld) {
            try {
                return this.validate(value);
            }
            catch (ValidationException ex) {
                throw new IllegalArgumentException(String.format("%s: Wert '%s' ist nicht erlaubt (%s)", validatedFeld.toShortString(), value, ex.getMessage()), ex);
            }
        }

        @Override
        public String validate(String value) {
            return this.validate(value, this.config);
        }

        public String validate(String value, Config validationConfig) {
            if (value == null) {
                throw new ValidationException("null-Werte sind nicht erlaubt");
            }
            switch (validationConfig.getValidateMode()) {
                case LAX: {
                    return this.validateLax(value);
                }
                case STRICT: {
                    return this.validateStrict(value);
                }
            }
            return value;
        }

        protected String validateLax(String value) {
            LOG.debug("Inhalt von '{}' wird validiert.", (Object)value);
            for (char c : value.toCharArray()) {
                this.validateChar(value, c);
            }
            return value;
        }

        private void validateChar(String value, char c) {
            if (!Text.of(Character.toString(c)).isPrintable()) {
                throw new ValidationException(String.format("Text '%s' enthaelt ungueltige Zeichen '%c'", value, Character.valueOf(c)));
            }
        }

        protected String validateStrict(String value) {
            return this.validateLax(value);
        }
    }
}

