/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import de.jfachwert.pruefung.exception.ValidationException;
import gdv.xport.config.Config;
import gdv.xport.feld.Align;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.NumberFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NumFeld
extends Feld {
    private static final Logger LOG = LogManager.getLogger(NumFeld.class);
    private static final Feld.Validator DEFAULT_VALIDATOR = new Validator(Config.getInstance());
    private final int nachkommastellen;

    public NumFeld(String name, String s) {
        this(Bezeichner.of(name), s.length(), 1, 0, Config.getInstance());
        this.setInhalt(s);
    }

    public NumFeld(Bezeichner bezeichner, int length, int start) {
        this(bezeichner, length, start, 0, Config.getInstance());
    }

    public NumFeld(Bezeichner bezeichner, int length, int start, int value) {
        this(bezeichner, length, start);
        this.setInhalt(value);
    }

    public NumFeld(String name, int start, String value) {
        this(Bezeichner.of(name), value.length(), start);
        this.setInhalt(value);
    }

    public NumFeld(String name, String s, int nachkommastellen) {
        this(Bezeichner.of(name), s.length(), 1, nachkommastellen, Config.getInstance());
        this.setInhalt(s);
    }

    public NumFeld(Bezeichner name, int start, String value, int nachkommastellen) {
        this(name, value.length(), start, nachkommastellen, Config.getInstance());
        this.setInhalt(value);
    }

    public NumFeld(Bezeichner name, int length, int start, int value, int nachkommastellen) {
        this(name, length, start, nachkommastellen, Config.getInstance());
        this.setInhalt(value);
    }

    protected NumFeld(Bezeichner name, int length, int start, int nachkommastellen, Config config) {
        super(name, length, start, Align.RIGHT, config);
        this.nachkommastellen = nachkommastellen;
        this.setInhalt(0L);
    }

    public NumFeld(Feld other) {
        this(other, other.config);
    }

    protected NumFeld(Feld other, Config config) {
        super(other, config);
        this.nachkommastellen = other instanceof NumFeld ? ((NumFeld)other).nachkommastellen : 0;
    }

    public NumFeld mitNachkommastellen(int n) {
        if (n > this.getAnzahlBytes()) {
            throw new IllegalArgumentException(n + " Nachkommastellen sind zuviel (max. " + this.getAnzahlBytes() + " moeglich)");
        }
        return new NumFeld(this.getBezeichner(), this.getByteAdresse(), this.getInhalt(), n);
    }

    @Override
    public NumFeld mitConfig(Config c) {
        return new NumFeld(this, c);
    }

    public int getNachkommastellen() {
        return this.nachkommastellen;
    }

    @Override
    public void setInhalt(char c) {
        this.setInhalt(Character.digit(c, 10));
    }

    @Override
    public void setInhalt(long n) {
        if (LOG.isDebugEnabled() && this.getNachkommastellen() > 0) {
            LOG.debug("Ab v5.1 wird hier Zahl {} mit {} 0en gesetzt.", (Object)n, (Object)this.getNachkommastellen());
        }
        this.setInhalt(new BigDecimal(n));
    }

    @Override
    public void setInhalt(BigInteger n) {
        this.setInhalt(new BigDecimal(n.toString()));
    }

    @Override
    public void setInhalt(BigDecimal n) {
        this.setInhalt(n.movePointRight(this.nachkommastellen).setScale(0, RoundingMode.HALF_UP).toString());
    }

    public void setInhalt(double x) {
        this.setInhalt(BigDecimal.valueOf(x));
    }

    @Override
    protected String pack(String s) {
        return StringUtils.stripStart(s, "0");
    }

    @Override
    public String getInhalt() {
        String zeroes = StringUtils.repeat('0', this.getAnzahlBytes() - this.inhalt.length());
        return zeroes + this.inhalt;
    }

    @Override
    public void resetInhalt() {
        int anzahlBytes = this.getAnzahlBytes();
        for (int i = 0; i < anzahlBytes; ++i) {
            this.setInhalt('0', i);
        }
    }

    @Override
    protected String truncate(String s) {
        if (s.startsWith("0") && s.length() > 1) {
            return this.truncate(s.substring(1));
        }
        if (s.length() > this.getAnzahlBytes()) {
            LOG.info("NumFeld {} wird auf {} Ziffern gekuerzt", (Object)this.getBezeichner(), (Object)this.getAnzahlBytes());
            return StringUtils.repeat('9', this.getAnzahlBytes());
        }
        return s;
    }

    public int toInt() {
        return this.toBigDecimal().intValue();
    }

    public long toLong() {
        return this.toBigDecimal().longValue();
    }

    public double toDouble() {
        return this.toBigDecimal().doubleValue();
    }

    public BigInteger toBigInteger() {
        return this.toBigDecimal().toBigInteger();
    }

    public BigDecimal toBigDecimal() {
        BigDecimal d = new BigDecimal(this.getInhalt().trim());
        return d.movePointLeft(this.nachkommastellen);
    }

    public BigDecimal add(BigDecimal summand) {
        BigDecimal summe = this.toBigDecimal().add(summand);
        this.setInhalt(summe);
        return summe.setScale(this.nachkommastellen, RoundingMode.UP);
    }

    @Override
    public boolean hasValue() {
        try {
            return super.hasValue() && !BigDecimal.ZERO.equals(this.toBigDecimal());
        }
        catch (NumberFormatException ex) {
            LOG.debug("{} hat ungueltigen Wert:", (Object)this, (Object)ex);
            return false;
        }
    }

    @Override
    public String format() {
        NumberFormat nf = NumberFormat.getInstance();
        if (this.nachkommastellen == 0) {
            return nf.format(this.toLong());
        }
        nf.setMinimumFractionDigits(this.nachkommastellen);
        nf.setMaximumFractionDigits(this.nachkommastellen);
        return nf.format(this.toDouble());
    }

    @Override
    public Object clone() {
        return new NumFeld(this);
    }

    public static class Validator
    extends Feld.Validator {
        public Validator() {
        }

        public Validator(Config config) {
            super(config);
        }

        @Override
        protected String validateLax(String value) {
            String nummer = value.trim();
            LOG.debug("{} wird als Zahl validiert.", (Object)nummer);
            if (StringUtils.isNotBlank(nummer)) {
                try {
                    BigInteger n = new BigInteger(nummer);
                    if (n.compareTo(BigInteger.ZERO) < 0) {
                        throw new ValidationException(String.format("'%s' darf nicht negativ sein", nummer));
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ValidationException(String.format("'%s' ist keine Zahl", nummer), nfe);
                }
            }
            return nummer;
        }

        @Override
        protected String validateStrict(String value) {
            if (!StringUtils.trim(value).equals(value) || StringUtils.isBlank(value)) {
                throw new ValidationException("Zahl muss vorhanden sein und darf keine Leerzeichen enthalten");
            }
            return this.validateLax(value);
        }
    }
}

