/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.feld;

import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.feld.Zeichen;
import gdv.xport.io.Importer;
import gdv.xport.io.PushbackLineNumberReader;
import gdv.xport.satz.Teildatensatz;
import gdv.xport.util.SimpleConstraintViolation;
import java.io.EOFException;
import java.io.IOException;
import java.io.PushbackReader;
import java.util.List;
import net.sf.oval.ConstraintViolation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Satznummer
extends Zeichen {
    private static final Logger LOG = LogManager.getLogger();

    public Satznummer() {
        this(256);
    }

    public Satznummer(int start) {
        this(new Zeichen(Bezeichner.SATZNUMMER, start));
    }

    public Satznummer(Feld feld) {
        super(feld);
    }

    public static Satznummer readSatznummer(PushbackLineNumberReader reader) throws IOException {
        Satznummer satznr = new Satznummer();
        int satzart = Importer.of(reader).readSatzart();
        switch (satzart) {
            case 210: 
            case 211: {
                satznr = Satznummer.getSatznummer21x(reader);
                break;
            }
            case 220: 
            case 221: {
                satznr = Satznummer.getSatznummer22x(reader);
                break;
            }
            case 250: 
            case 251: 
            case 450: {
                satznr = new Satznummer(51);
                break;
            }
            case 270: 
            case 280: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: {
                satznr = new Satznummer(43);
                break;
            }
            case 500: {
                satznr.read(reader);
                if (satznr.toChar() == '2') {
                    return satznr;
                }
                satznr = new Satznummer(66);
                break;
            }
            case 550: {
                satznr = new Satznummer(66);
            }
        }
        satznr.read(reader);
        return satznr;
    }

    private static Satznummer getSatznummer21x(PushbackLineNumberReader reader) throws IOException {
        char[] satz = Satznummer.readRecord(reader, 14);
        int sparte = Integer.parseInt(String.valueOf(satz, 10, 3));
        switch (sparte) {
            case 0: 
            case 80: 
            case 170: 
            case 190: 
            case 550: 
            case 560: 
            case 570: 
            case 580: {
                return new Satznummer(43);
            }
            case 130: {
                return new Satznummer(251);
            }
        }
        return new Satznummer(256);
    }

    private static Satznummer getSatznummer22x(PushbackLineNumberReader reader) throws IOException {
        char[] satz = Satznummer.readRecord(reader, 256);
        int sparte = Integer.parseInt(String.valueOf(satz, 10, 3));
        switch (sparte) {
            case 0: {
                return new Satznummer(47);
            }
            case 30: {
                if (satz[48] == '2' && satz[255] == 'X' || satz[48] == '1' || satz[48] == '4') {
                    return new Satznummer(49);
                }
                if (satz[59] == '9') {
                    return new Satznummer(60);
                }
                if (satz[42] == '3') {
                    return new Satznummer(43);
                }
                return new Satznummer(60);
            }
            case 40: 
            case 140: {
                return new Satznummer(51);
            }
            case 70: {
                return new Satznummer(53);
            }
            case 80: 
            case 190: {
                return new Satznummer(49);
            }
            case 170: {
                return new Satznummer(50);
            }
            case 550: 
            case 560: 
            case 570: 
            case 580: {
                return new Satznummer(43);
            }
        }
        return new Satznummer(256);
    }

    private void read(PushbackReader reader) throws IOException {
        char[] cbuf = Satznummer.readRecord(reader, this.getByteAdresse());
        String teildatenSatz = new String(cbuf).substring(cbuf.length - 1, cbuf.length);
        this.setInhalt(teildatenSatz);
    }

    private static char[] readRecord(PushbackReader reader, int size) throws IOException {
        char[] cbuf = new char[size];
        if (reader.read(cbuf) < 0) {
            throw new EOFException("can't read " + size + " bytes from " + reader);
        }
        reader.unread(cbuf);
        return cbuf;
    }

    public static Satznummer readSatznummer(PushbackReader reader, Teildatensatz teildatensatz) throws IOException {
        Satznummer nr = new Satznummer(teildatensatz.getSatznummer());
        return Satznummer.readSatznummer(reader, nr, teildatensatz);
    }

    private static Satznummer readSatznummer(PushbackReader reader, Satznummer nr, Teildatensatz teildatensatz) throws IOException {
        List<Zeichen> satzIdents = teildatensatz.getSatzIdent();
        for (Zeichen ident : satzIdents) {
            Zeichen inhalt = Satznummer.readZeichen(reader, new Zeichen(ident));
            if (inhalt.toChar() == ident.toChar()) continue;
            LOG.debug("{} passt nicht, {} wird zurueckgesetzt.", (Object)ident, (Object)nr);
            nr.resetInhalt();
            break;
        }
        return nr;
    }

    private static Zeichen readZeichen(PushbackReader reader, Zeichen nr) throws IOException {
        int position = nr.getByteAdresse();
        char[] cbuf = new char[position];
        if (reader.read(cbuf) == -1) {
            throw new EOFException("can't read 1 bytes (" + new String(cbuf) + ") from " + reader);
        }
        reader.unread(cbuf);
        nr.setInhalt(cbuf[position - 1]);
        return nr;
    }

    @Override
    public List<ConstraintViolation> validate() {
        List<ConstraintViolation> violations = super.validate();
        char c = this.toChar();
        if (c == '0') {
            violations.add(new SimpleConstraintViolation("'0' is not allowed as Satznummer", this, Character.valueOf(c)));
        } else if (!Character.isDigit(c)) {
            violations.add(new SimpleConstraintViolation("only digits are allowed as Satznummer", this, Character.valueOf(c)));
        }
        return violations;
    }

    @Override
    public Object clone() {
        return new Satznummer(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Satznummer)) {
            return false;
        }
        Satznummer other = (Satznummer)obj;
        return this.getByteAdresse() == other.getByteAdresse() && this.getInhalt().equals(other.getInhalt());
    }
}

