/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.io;

import gdv.xport.feld.Satznummer;
import gdv.xport.io.ImportException;
import gdv.xport.io.PushbackLineNumberReader;
import gdv.xport.satz.feld.common.WagnisartLeben;
import gdv.xport.util.SatzTyp;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class Importer {
    private final PushbackLineNumberReader reader;

    private Importer(PushbackLineNumberReader reader) {
        this.reader = reader;
    }

    public static Importer of(PushbackLineNumberReader reader) {
        return new Importer(reader);
    }

    public static Importer of(Reader reader) {
        if (reader instanceof PushbackLineNumberReader) {
            return Importer.of((PushbackLineNumberReader)reader);
        }
        return Importer.of(new PushbackLineNumberReader(reader));
    }

    public int readSatzart() throws IOException {
        this.reader.skipWhitespace();
        char[] cbuf = new char[4];
        this.importFrom(cbuf);
        this.reader.unread(cbuf);
        return Integer.parseInt(new String(cbuf).trim());
    }

    private void importFrom(char[] cbuf) throws IOException {
        if (this.reader.read(cbuf) == -1) {
            String s = new String(cbuf).trim();
            throw new EOFException("can't read " + cbuf.length + " bytes from " + this.reader + ", only \"" + s + "\" (" + s.length() + " bytes)");
        }
    }

    public SatzTyp readSatzTyp(int satzart) throws IOException {
        if (satzart == 1 || satzart == 9999) {
            return SatzTyp.of(satzart);
        }
        int sparte = this.readSparte();
        SatzTyp satzTyp = SatzTyp.of(satzart, sparte);
        if (satzart >= 210 && satzart < 300) {
            if (sparte == 10 && (satzart == 220 || satzart == 221)) {
                WagnisartLeben wagnisart = this.readWagnisart();
                if (wagnisart.getCode() > 0) {
                    int satznr = Satznummer.readSatznummer(this.reader).toInt();
                    satzTyp = SatzTyp.of(satzart, sparte, wagnisart.getCode(), satznr > 5 ? satznr : 1);
                } else {
                    satzTyp = SatzTyp.of(satzart, sparte, wagnisart.getCode());
                }
            } else if (sparte == 20 && satzart == 220) {
                int krankenFolgeNr = this.readKrankenFolgeNr();
                satzTyp = SatzTyp.of(satzart, sparte, krankenFolgeNr);
            } else if (sparte == 580 && satzart == 220) {
                int bausparArt = this.readBausparenArt();
                satzTyp = SatzTyp.of(satzart, sparte, bausparArt);
            }
        }
        return satzTyp;
    }

    public int readSparte() throws IOException {
        char[] cbuf = new char[14];
        if (this.reader.read(cbuf) == -1) {
            throw new IOException("can't read 14 bytes (" + new String(cbuf) + ") from " + this.reader);
        }
        this.reader.unread(cbuf);
        String intro = new String(cbuf);
        try {
            return Integer.parseInt(intro.substring(10, 13));
        }
        catch (NumberFormatException ex) {
            throw new ImportException("cannot read sparte from first 14 bytes (\"" + intro + "\")");
        }
    }

    public WagnisartLeben readWagnisart() throws IOException {
        char[] cbuf = new char[60];
        if (this.reader.read(cbuf) == -1) {
            throw new IOException("can't read 1 bytes (" + new String(cbuf) + ") from " + this.reader);
        }
        this.reader.unread(cbuf);
        String wagnisart = new String(cbuf).substring(59, 60);
        return WagnisartLeben.isIn(wagnisart);
    }

    public int readKrankenFolgeNr() throws IOException {
        int satzart = Importer.of(this.reader).readSatzart();
        if (satzart != 220) {
            throw new IllegalArgumentException("can't read Kranken Folge-Nr., wrong satzart " + satzart + ", must be 220");
        }
        int sparte = this.readSparte();
        if (sparte != 20) {
            throw new IllegalArgumentException("can't read Kranken Folge-Nr., wrong sparte " + sparte + ", must be 20");
        }
        char[] cbuf = new char[49];
        if (this.reader.read(cbuf) == -1) {
            throw new IOException("can't read 49 bytes (" + new String(cbuf) + ") from " + this.reader);
        }
        this.reader.unread(cbuf);
        String first10Fields = new String(cbuf);
        try {
            return Integer.parseInt(first10Fields.substring(47, 48));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public int readBausparenArt() throws IOException {
        int satzart = this.readSatzart();
        if (satzart != 220) {
            throw new IllegalArgumentException("can't read Bauspar-Art, wrong satzart " + satzart + ", must be 220");
        }
        int sparte = this.readSparte();
        if (sparte != 580) {
            throw new IllegalArgumentException("can't read Bauspar-Art, wrong sparte " + sparte + ", must be 580");
        }
        char[] cbuf = new char[45];
        if (this.reader.read(cbuf) == -1) {
            throw new IOException("can't read 45 bytes (" + new String(cbuf) + ") from " + this.reader);
        }
        this.reader.unread(cbuf);
        String first10Fields = new String(cbuf);
        return Integer.parseInt(first10Fields.substring(43, 44));
    }
}

