/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.WeakHashMap;

public class RecyclingInputStreamReader
extends Reader {
    private static final Map<InputStream, Reader> cachedReaders = new WeakHashMap<InputStream, Reader>();
    private final Reader reader;

    public RecyclingInputStreamReader(InputStream in) {
        this(in, Charset.defaultCharset());
    }

    public RecyclingInputStreamReader(InputStream in, String charsetName) throws UnsupportedEncodingException {
        this.reader = RecyclingInputStreamReader.getReaderFor(in, Charset.forName(charsetName));
    }

    public RecyclingInputStreamReader(InputStream in, Charset cs) {
        this.reader = RecyclingInputStreamReader.getReaderFor(in, cs);
    }

    private static Reader getReaderFor(InputStream in, Charset cs) {
        Reader r = cachedReaders.get(in);
        if (r == null) {
            r = new InputStreamReader(in, cs);
            cachedReaders.put(in, r);
        }
        return r;
    }

    private synchronized void removeReader(Reader r) {
        for (Map.Entry<InputStream, Reader> entry : cachedReaders.entrySet()) {
            if (!r.equals(entry.getValue())) continue;
            cachedReaders.remove(entry.getKey());
            break;
        }
    }

    @Override
    public void close() throws IOException {
        this.removeReader(this.reader);
        if (cachedReaders.isEmpty()) {
            this.reader.close();
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.reader.read(cbuf, off, len);
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.reader.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this.reader.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.reader.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.reader.read(cbuf);
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this.reader.read(target);
    }

    @Override
    public boolean ready() throws IOException {
        return this.reader.ready();
    }

    @Override
    public void reset() throws IOException {
        this.reader.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.reader.skip(n);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with " + this.reader;
    }
}

