/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gdv.xport.config.Config;
import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.feld.Satznummer;
import gdv.xport.feld.Zeichen;
import gdv.xport.io.Importer;
import gdv.xport.io.PushbackLineNumberReader;
import gdv.xport.satz.Satz;
import gdv.xport.satz.Teildatensatz;
import gdv.xport.satz.feld.common.Kopffelder1bis7;
import gdv.xport.satz.feld.common.TeildatensatzNummer;
import gdv.xport.satz.feld.common.WagnisartLeben;
import gdv.xport.util.SatzTyp;
import java.io.IOException;
import java.io.PushbackReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Datensatz
extends Satz {
    private static final Logger LOG = LogManager.getLogger(Datensatz.class);
    private final NumFeld sparte = new NumFeld(Kopffelder1bis7.SPARTE);

    public Datensatz() {
        this(SatzTyp.of(0));
    }

    public Datensatz(int satzart) {
        this(SatzTyp.of(satzart));
    }

    public Datensatz(SatzTyp satzTyp) {
        this(satzTyp, Config.getInstance());
    }

    protected Datensatz(SatzTyp satzTyp, Config cfg) {
        this(satzTyp, 1, cfg);
    }

    public Datensatz(SatzTyp satzTyp, int n) {
        this(satzTyp, n, Config.getInstance());
    }

    protected Datensatz(SatzTyp satzTyp, int n, Config cfg) {
        super(satzTyp, n, cfg);
        this.init(satzTyp);
        this.setUpTeildatensaetze();
    }

    public Datensatz(Datensatz other) {
        super((Satz)other, other.cloneTeildatensaetze());
        this.sparte.setInhalt(other.sparte.getInhalt());
    }

    protected void setUpTeildatensaetze() {
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            this.setUpTeildatensatz(tds);
        }
    }

    protected void setUpTeildatensatz(Teildatensatz tds) {
        Datensatz.setUpTeildatensatz(tds, this.sparte);
    }

    protected static void setUpTeildatensatz(Teildatensatz tds, NumFeld sparte) {
        if (!tds.hasFeld(Kopffelder1bis7.VU_NUMMER.getBezeichner()) && !tds.getFeldInhalt(Kopffelder1bis7.SATZART.getBezeichner()).equals("9999")) {
            Datensatz.setUp(tds, Kopffelder1bis7.VU_NUMMER.getBezeichner(), Config.getInstance().getVUNr());
            Datensatz.setUp(tds, Kopffelder1bis7.BUENDELUNGSKENNZEICHEN.getBezeichner(), new AlphaNumFeld(Kopffelder1bis7.BUENDELUNGSKENNZEICHEN));
            Datensatz.setUp(tds, Kopffelder1bis7.SPARTE.getBezeichner(), sparte);
            Datensatz.setUp(tds, Kopffelder1bis7.VERSICHERUNGSSCHEINNUMMER.getBezeichner(), new AlphaNumFeld(Kopffelder1bis7.VERSICHERUNGSSCHEINNUMMER));
            Datensatz.setUp(tds, Kopffelder1bis7.FOLGENUMMER.getBezeichner(), new NumFeld(Kopffelder1bis7.FOLGENUMMER));
            Datensatz.setUp(tds, Kopffelder1bis7.VERMITTLER.getBezeichner(), new AlphaNumFeld(Kopffelder1bis7.VERMITTLER));
            if (!tds.hasFeld(Bezeichner.SATZNUMMER)) {
                Datensatz.setUp(tds, Bezeichner.SATZNUMMER, new Satznummer(tds.getSatznummer()));
            }
            LOG.trace("{} is set up.", (Object)tds);
        } else if (tds.hasFeld(Kopffelder1bis7.SPARTE)) {
            tds.getFeld(Kopffelder1bis7.SPARTE.getBezeichner()).setInhalt(sparte.getInhalt());
        }
    }

    private static void setUp(Teildatensatz tds, Bezeichner bezeichner, Feld value) {
        if (!tds.hasFeld(bezeichner)) {
            LOG.trace("{} initialized with value {}.", (Object)tds, (Object)value);
            tds.add(value);
        }
    }

    protected final void completeTeildatensaetze() {
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            this.setUpTeildatensatz(tds);
        }
    }

    @Override
    public void addFiller() {
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            tds.add(new AlphaNumFeld(Bezeichner.LEERSTELLEN, 213, 43));
        }
    }

    public void init(SatzTyp satztyp) {
        if (satztyp.hasSparte()) {
            this.setSparte(satztyp.getSparte());
        }
        if (satztyp.hasWagnisart()) {
            this.initWagnisart(satztyp.getWagnisart());
        }
        if (satztyp.hasBausparenArt()) {
            this.initBausparenart(satztyp.getBausparenArt());
        }
    }

    private void initWagnisart(int art) {
        if (!this.hasWagnisart()) {
            this.addAll(new AlphaNumFeld(Bezeichner.WAGNISART, 1, 60));
        }
        this.setFeld(Bezeichner.WAGNISART, Integer.toString(art).substring(0, 1));
    }

    private void initBausparenart(int art) {
        if (!this.hasBausparenArt()) {
            this.addAll(new AlphaNumFeld(Bezeichner.ART1, 1, 44));
        }
        this.setFeld(Bezeichner.ART1, art);
    }

    public void setSparte(int x) {
        this.sparte.setInhalt(x);
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            if (tds.getFelder().size() <= 3) continue;
            tds.getFeld(4).setInhalt(x);
        }
    }

    public void setSparte(String x) {
        String[] parts = x.split("\\.");
        this.setSparte(Integer.parseInt(parts[0]));
        if (parts.length > 1 && this.getGdvSatzartName().isEmpty()) {
            this.setGdvSatzartName(String.format("%04d.%s", this.getSatzart(), x));
        }
    }

    @Override
    public int getSparte() {
        return this.sparte.toInt();
    }

    @JsonIgnore
    public int getArt() {
        return this.getSatzTyp().getArt();
    }

    public boolean hasArt() {
        return this.getSatzTyp().hasArt();
    }

    @Override
    public boolean hasSparte() {
        return this.sparte != null && !this.sparte.isEmpty() && this.getSparte() > 0;
    }

    public NumFeld getSparteFeld() {
        return this.sparte;
    }

    public boolean hasSatzartNummer() {
        return !this.getGdvSatzartNummer().isEmpty();
    }

    public void setVuNummer(String s) {
        this.setFeld(Bezeichner.VU_NUMMER, s);
    }

    @JsonIgnore
    public String getVuNummer() {
        return this.getFeld(Bezeichner.VU_NUMMER).getInhalt().trim();
    }

    @JsonIgnore
    public boolean hasVuNummer() {
        return this.hasFeld(Bezeichner.VU_NUMMER);
    }

    public void setVersicherungsscheinNummer(String nr) {
        this.setFeld(Kopffelder1bis7.VERSICHERUNGSSCHEINNUMMER.getBezeichner(), nr);
    }

    @JsonIgnore
    public String getVersicherungsscheinNummer() {
        return this.getFeld(Kopffelder1bis7.VERSICHERUNGSSCHEINNUMMER.getBezeichner()).getInhalt().trim();
    }

    @Deprecated
    public void setSatznummer(Zeichen satznummer) {
        this.remove(Bezeichner.SATZNUMMER);
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            tds.setSatznummer(satznummer);
        }
    }

    public void setFolgenummer(int nr) {
        this.setFeld(Kopffelder1bis7.FOLGENUMMER.getBezeichner(), nr);
    }

    public int getFolgenummer() {
        NumFeld folgenummer = (NumFeld)this.getFeld(Kopffelder1bis7.FOLGENUMMER.getBezeichner());
        return folgenummer.toInt();
    }

    protected static int readSparte(PushbackReader reader) throws IOException {
        return Importer.of(reader).readSparte();
    }

    @Deprecated
    public static int readKrankenFolgeNr(PushbackLineNumberReader reader) throws IOException {
        return Importer.of(reader).readKrankenFolgeNr();
    }

    @Deprecated
    public static int readBausparenArt(PushbackLineNumberReader reader) throws IOException {
        return Importer.of(reader).readBausparenArt();
    }

    @Deprecated
    public static WagnisartLeben readWagnisart(PushbackReader reader) throws IOException {
        return Importer.of(reader).readWagnisart();
    }

    @Override
    protected boolean matchesNextTeildatensatz(PushbackLineNumberReader reader, char[] lastFeld1To7, Character satznummer) throws IOException {
        if (super.matchesNextTeildatensatz(reader, lastFeld1To7, satznummer)) {
            int i;
            if (lastFeld1To7 == null) {
                return true;
            }
            char[] newLine = new char[256];
            int res = reader.read(newLine);
            if (res < 256) {
                return false;
            }
            reader.unread(newLine);
            for (i = 0; i < 4; ++i) {
                if (lastFeld1To7[i] == newLine[i]) continue;
                return false;
            }
            for (i = 10; i < 13; ++i) {
                if (lastFeld1To7[i] == newLine[i]) continue;
                return false;
            }
            for (i = 30; i < 42; ++i) {
                if (lastFeld1To7[i] == newLine[i]) continue;
                return false;
            }
            if (!Datensatz.matchesLastFeld(satznummer, reader)) {
                return false;
            }
            return this.matchesNextSatztyp(reader);
        }
        return false;
    }

    private static boolean matchesLastFeld(Character satznummer, PushbackLineNumberReader reader) throws IOException {
        char newSatznummer = Satznummer.readSatznummer(reader).toChar();
        return !Character.isDigit(newSatznummer) || !Character.isDigit(satznummer.charValue()) || newSatznummer > satznummer.charValue();
    }

    private boolean matchesNextSatztyp(PushbackLineNumberReader reader) {
        try {
            int satzart = Importer.of(reader).readSatzart();
            SatzTyp satztyp = Importer.of(reader).readSatzTyp(satzart);
            return satztyp != null && satztyp.equals(this.getSatzTyp());
        }
        catch (IOException ex) {
            LOG.info("No next satztyp found ({}).", (Object)ex.getLocalizedMessage());
            LOG.debug("Details:", (Throwable)ex);
            return false;
        }
    }

    @Deprecated
    public static TeildatensatzNummer readTeildatensatzNummer(PushbackReader reader) throws IOException {
        Satznummer satznr = Satznummer.readSatznummer(new PushbackLineNumberReader(reader));
        return TeildatensatzNummer.of(satznr.toInt());
    }
}

