/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz;

import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Betrag;
import gdv.xport.feld.BetragMitVorzeichen;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.NumFeld;
import gdv.xport.satz.Satz;
import gdv.xport.util.SatzRegistry;
import gdv.xport.util.SatzTyp;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Nachsatz
extends Satz {
    public static final SatzTyp SATZART = SatzTyp.of("9999");
    private static final Logger LOG = LogManager.getLogger(Nachsatz.class);

    public Nachsatz() {
        this(SatzRegistry.getInstance());
    }

    public Nachsatz(SatzRegistry factory) {
        this(factory.getSatz(SATZART));
    }

    private Nachsatz(Satz vorlage) {
        super(vorlage, vorlage.cloneTeildatensaetze());
    }

    public static Nachsatz of(String content) {
        Nachsatz nachsatz = new Nachsatz();
        try {
            nachsatz.importFrom(content);
            LOG.debug("{} created from \"{}\"", (Object)nachsatz, (Object)content);
            return nachsatz;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("argument too short", ioe);
        }
    }

    public Nachsatz(Nachsatz other) {
        super((Satz)other, other.cloneTeildatensaetze());
    }

    public void setAnzahlSaetze(int n) {
        this.setFeld(Bezeichner.ANZAHL_SAETZE, n);
    }

    public int getAnzahlSaetze() {
        return Integer.parseInt(this.getFeld(Bezeichner.ANZAHL_SAETZE).getInhalt().trim());
    }

    public void increaseAnzahlSaetze() {
        this.setAnzahlSaetze(this.getAnzahlSaetze() + 1);
    }

    public void setGesamtBeitrag(String beitrag) {
        this.setFeld(Bezeichner.GESAMTBEITRAG, beitrag);
    }

    @Deprecated
    public void setGesamtBeitrag(double beitrag) {
        this.setGesamtBeitrag(BigDecimal.valueOf(beitrag));
    }

    public void setGesamtBeitrag(BigDecimal beitrag) {
        this.setFeld(Bezeichner.GESAMTBEITRAG, beitrag.movePointRight(2).toString());
    }

    public BigDecimal addGesamtBeitrag(BigDecimal beitrag) {
        BigDecimal summe = this.getGesamtBeitrag().add(beitrag);
        this.setGesamtBeitrag(summe);
        return summe;
    }

    public Betrag getGesamtBeitrag() {
        return Betrag.of(this.getFeld(Bezeichner.GESAMTBEITRAG));
    }

    public void setGesamtBeitragBruttoMitVorzeichen(BigDecimal beitrag) {
        BetragMitVorzeichen bmv = this.getGesamtBeitragBruttoMitVorzeichen();
        bmv.setInhalt(beitrag);
        this.setGesamtBeitragBrutto(bmv.getBetrag().getInhalt());
        this.setVorzeichenGesamtbeitragBrutto(Character.toString(bmv.getVorzeichen()));
    }

    public void setGesamtBeitragBrutto(String strBeitrag) {
        this.getTeildatensatz(1).getFeld(5).setInhalt(strBeitrag);
    }

    public BigDecimal addGesamtBeitragBrutto(BigDecimal beitrag) {
        BigDecimal summe = this.getGesamtBeitragBruttoMitVorzeichen().add(beitrag);
        this.setGesamtBeitragBruttoMitVorzeichen(summe);
        return summe;
    }

    public BetragMitVorzeichen getGesamtBeitragBruttoMitVorzeichen() {
        NumFeld brutto = (NumFeld)this.getFeld(Bezeichner.GESAMTBEITRAG_BRUTTO);
        AlphaNumFeld vorzeichen = (AlphaNumFeld)this.getFeld(Bezeichner.VORZEICHEN);
        return BetragMitVorzeichen.of(brutto, vorzeichen);
    }

    public void setVorzeichenGesamtbeitragBrutto(String strVorzeichen) {
        if (!"+".equalsIgnoreCase(strVorzeichen) && !"-".equalsIgnoreCase(strVorzeichen)) {
            throw new IllegalArgumentException(strVorzeichen + ": kein Vorzeichen");
        }
        this.getTeildatensatz(1).getFeld(6).setInhalt(strVorzeichen);
    }

    public void setGesamtProvisionsBetrag(String strBeitrag) {
        this.getTeildatensatz(1).getFeld(7).setInhalt(strBeitrag);
    }

    public void setGesamtProvisionsBetragMitVorzeichen(BigDecimal betrag) {
        BetragMitVorzeichen bmv = this.getGesamtProvisionsBetragMitVorzeichen();
        bmv.setInhalt(betrag);
        this.setGesamtProvisionsBetrag(bmv.getBetrag().getInhalt());
        this.setVorzeichenGesamtProvisionsBetrag(Character.toString(bmv.getVorzeichen()));
    }

    public BigDecimal addGesamtProvisionsBetrag(BigDecimal betrag) {
        BigDecimal summe = this.getGesamtProvisionsBetragMitVorzeichen().add(betrag);
        this.setGesamtProvisionsBetragMitVorzeichen(summe);
        return summe;
    }

    public BetragMitVorzeichen getGesamtProvisionsBetragMitVorzeichen() {
        NumFeld brutto = this.getFeld(Bezeichner.GESAMTPROVISIONSBETRAG, NumFeld.class);
        AlphaNumFeld vorzeichen = this.getFeld(Bezeichner.VORZEICHEN2, AlphaNumFeld.class);
        return BetragMitVorzeichen.of(brutto, vorzeichen);
    }

    public void setVorzeichenGesamtProvisionsBetrag(String strVorzeichen) {
        if (!"+".equalsIgnoreCase(strVorzeichen) && !"-".equalsIgnoreCase(strVorzeichen)) {
            throw new IllegalArgumentException(strVorzeichen + ": kein Vorzeichen");
        }
        this.getTeildatensatz(1).getFeld(8).setInhalt(strVorzeichen);
    }

    public void setVersicherungsLeistungenMitVorzeichen(BigDecimal betrag) {
        BetragMitVorzeichen bmv = this.getVersicherungsLeistungenMitVorzeichen();
        bmv.setInhalt(betrag);
        this.setVersicherungsLeistungen(bmv.getBetrag().getInhalt());
        this.setVorzeichenVersicherungsLeistungen(Character.toString(bmv.getVorzeichen()));
    }

    public void setVersicherungsLeistungen(String strBeitrag) {
        this.getTeildatensatz(1).getFeld(9).setInhalt(strBeitrag);
    }

    public BigDecimal addVersicherungsLeistungen(BigDecimal betrag) {
        BigDecimal summe = this.getVersicherungsLeistungenMitVorzeichen().add(betrag);
        this.setVersicherungsLeistungenMitVorzeichen(summe);
        return summe;
    }

    public BetragMitVorzeichen getVersicherungsLeistungenMitVorzeichen() {
        NumFeld brutto = (NumFeld)this.getFeld(Bezeichner.VERSICHERUNGSLEISTUNGEN);
        AlphaNumFeld vorzeichen = (AlphaNumFeld)this.getFeld(Bezeichner.VORZEICHEN3);
        return BetragMitVorzeichen.of(brutto, vorzeichen);
    }

    public void setVorzeichenVersicherungsLeistungen(String strVorzeichen) {
        if (!"+".equalsIgnoreCase(strVorzeichen) && !"-".equalsIgnoreCase(strVorzeichen)) {
            throw new IllegalArgumentException(strVorzeichen + ": kein Vorzeichen");
        }
        this.getTeildatensatz(1).getFeld(10).setInhalt(strVorzeichen);
    }

    public void setSchadenbearbeitungskostenMitVorzeichen(BigDecimal beitrag) {
        BetragMitVorzeichen bmv = this.getSchadenbearbeitungskostenMitVorzeichen();
        bmv.setInhalt(beitrag);
        this.setSchadenbearbeitungskosten(bmv.getBetrag().getInhalt());
        this.setVorzeichenSchadenbearbeitungskosten(Character.toString(bmv.getVorzeichen()));
    }

    public void setSchadenbearbeitungskosten(String strBeitrag) {
        this.getTeildatensatz(1).getFeld(11).setInhalt(strBeitrag);
    }

    public BigDecimal addSchadenbearbeitungskosten(BigDecimal betrag) {
        BigDecimal summe = this.getSchadenbearbeitungskostenMitVorzeichen().add(betrag);
        this.setSchadenbearbeitungskostenMitVorzeichen(summe);
        return summe;
    }

    public BetragMitVorzeichen getSchadenbearbeitungskostenMitVorzeichen() {
        NumFeld betrag = (NumFeld)this.getFeld(Bezeichner.SCHADENBEARBEITUNGSKOSTEN);
        AlphaNumFeld vorzeichen = (AlphaNumFeld)this.getFeld(Bezeichner.VORZEICHEN4);
        return BetragMitVorzeichen.of(betrag, vorzeichen);
    }

    public void setVorzeichenSchadenbearbeitungskosten(String strVorzeichen) {
        if (!"+".equalsIgnoreCase(strVorzeichen) && !"-".equalsIgnoreCase(strVorzeichen)) {
            throw new IllegalArgumentException(strVorzeichen + ": kein Vorzeichen");
        }
        this.getTeildatensatz(1).getFeld(12).setInhalt(strVorzeichen);
    }
}

