/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gdv.xport.config.Config;
import gdv.xport.feld.Align;
import gdv.xport.feld.AlphaNumFeld;
import gdv.xport.feld.Betrag;
import gdv.xport.feld.BetragMitVorzeichen;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.ByteAdresse;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.feld.Satznummer;
import gdv.xport.feld.Zeichen;
import gdv.xport.io.ImportException;
import gdv.xport.io.Importer;
import gdv.xport.io.PushbackLineNumberReader;
import gdv.xport.satz.Teildatensatz;
import gdv.xport.satz.feld.common.Kopffelder1bis7;
import gdv.xport.util.SatzRegistry;
import gdv.xport.util.SatzTyp;
import gdv.xport.util.SimpleConstraintViolation;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.Validator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Satz
implements Cloneable {
    private static final Logger LOG = LogManager.getLogger(Satz.class);
    private Teildatensatz[] teildatensatz = new Teildatensatz[0];
    private final Config config;
    private String gdvSatzartNummer = "";
    private String gdvSatzartName = "";
    private final AlphaNumFeld satzVersion = new AlphaNumFeld(Bezeichner.of("Version"), 3, 1, Align.LEFT);

    public Satz(SatzTyp art, int n) {
        this(art, n, Config.getInstance());
    }

    protected Satz(SatzTyp art, int n, Config cfg) {
        this.config = cfg;
        this.createTeildatensaetze(art, n);
    }

    protected Satz() {
        this.config = Config.getInstance();
    }

    public Satz(Satz satz, int n) {
        this.config = satz.config;
        this.createTeildatensaetze(satz.getSatzTyp(), n);
        this.gdvSatzartName = satz.getGdvSatzartName();
        this.gdvSatzartNummer = satz.getGdvSatzartNummer();
        this.setSatzversion(satz.getSatzversion().getInhalt());
    }

    public Satz(SatzTyp art, List<? extends Teildatensatz> tdsList) {
        this.config = Config.getInstance();
        this.createTeildatensaetze(tdsList);
    }

    protected Satz(Satz satz, List<? extends Teildatensatz> tdsList) {
        this.config = satz.config;
        this.createTeildatensaetze(tdsList);
        this.getSatzartFeld().setInhalt(satz.getSatzart());
        this.satzVersion.setInhalt(satz.getSatzversion().getInhalt());
        this.gdvSatzartName = satz.getGdvSatzartName();
        this.gdvSatzartNummer = satz.getGdvSatzartNummer();
    }

    private void createTeildatensaetze(SatzTyp art, int n) {
        this.teildatensatz = new Teildatensatz[n];
        for (int i = 0; i < n; ++i) {
            this.teildatensatz[i] = new Teildatensatz(art, i + 1);
        }
        this.getSatzartFeld().setInhalt(art.getSatzart());
    }

    private void createTeildatensaetze(List<? extends Teildatensatz> tdsList) {
        this.teildatensatz = new Teildatensatz[tdsList.size()];
        for (int i = 0; i < tdsList.size(); ++i) {
            this.teildatensatz[i] = new Teildatensatz(tdsList.get(i));
        }
    }

    public final Config getConfig() {
        return this.config;
    }

    public final List<Teildatensatz> getTeildatensaetze() {
        return Arrays.asList(this.teildatensatz);
    }

    protected final List<Teildatensatz> cloneTeildatensaetze() {
        ArrayList<Teildatensatz> cloned = new ArrayList<Teildatensatz>(this.teildatensatz.length);
        for (Teildatensatz tds : this.teildatensatz) {
            cloned.add(new Teildatensatz(tds));
        }
        return cloned;
    }

    public final int getNumberOfTeildatensaetze() {
        return this.teildatensatz.length;
    }

    public final Teildatensatz getTeildatensatz(int n) {
        return this.teildatensatz[n - 1];
    }

    public final Teildatensatz getTeildatensatzBySatzNr(int n) {
        for (Teildatensatz tds : this.teildatensatz) {
            if (Integer.parseInt(tds.getSatznummer().getInhalt()) != n) continue;
            return tds;
        }
        throw new IllegalArgumentException("Satznummer " + n + " nicht vorhanden.");
    }

    public final void removeAllTeildatensaetze() {
        this.teildatensatz = new Teildatensatz[0];
    }

    public final void removeTeildatensatz(int n) {
        if (n < 1 || n > this.teildatensatz.length) {
            throw new IllegalArgumentException(n + " liegt nicht zwischen 1 und " + this.teildatensatz.length);
        }
        this.teildatensatz = ArrayUtils.remove(this.teildatensatz, n - 1);
    }

    public final void removeTeildatensatzBySatzNr(int n) {
        boolean treffer = false;
        int index = 0;
        for (Teildatensatz tds : this.teildatensatz) {
            if (Integer.parseInt(tds.getSatznummer().getInhalt()) == n) {
                treffer = true;
                break;
            }
            ++index;
        }
        if (!treffer) {
            throw new IllegalArgumentException("Teildatensatz " + n + " existiert nicht.");
        }
        this.teildatensatz = ArrayUtils.remove(this.teildatensatz, index);
    }

    public final void add(Teildatensatz tds) {
        this.teildatensatz = ArrayUtils.add(this.teildatensatz, tds);
    }

    public void add(Feld feld) {
        this.add(feld, 1);
    }

    public void addAll(Feld feld) {
        for (int n = 1; n <= this.getNumberOfTeildatensaetze(); ++n) {
            this.add(feld, n);
        }
    }

    public void add(Feld feld, int teildatensatzNr) {
        if (feld.getByteAdresse() > 256) {
            throw new IllegalArgumentException(feld + " ueberschreitet Teildatensatz-Grenze");
        }
        if (teildatensatzNr < 1 || teildatensatzNr > this.teildatensatz.length) {
            throw new IllegalArgumentException("Teildatensatz-Nr. " + teildatensatzNr + " fuer " + feld + " liegt nicht zwischen 1 und " + this.teildatensatz.length);
        }
        this.teildatensatz[teildatensatzNr - 1].add(feld);
    }

    public void addFiller() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void remove(String name) {
        this.remove(Bezeichner.of(name));
    }

    public void remove(Bezeichner bezeichner) {
        for (Teildatensatz tds : this.teildatensatz) {
            tds.remove(bezeichner);
        }
    }

    @Deprecated
    public void set(String name, String value) {
        this.setFeld(Bezeichner.of(name), value);
    }

    public void setFeld(String name, String value) {
        this.setFeld(Bezeichner.of(name), value);
    }

    @Deprecated
    public void set(Bezeichner name, Integer value) {
        this.setFeld(name, Integer.toString(value));
    }

    public void setFeld(Bezeichner name, Integer value) {
        this.setFeld(name, Integer.toString(value));
    }

    @Deprecated
    public void set(Bezeichner name, String value) {
        this.setFeld(name, value);
    }

    public void setFeld(Bezeichner name, String value) {
        boolean found = false;
        for (Teildatensatz tds : this.teildatensatz) {
            if (!tds.hasFeld(name)) continue;
            tds.setFeld(name, value);
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Feld \"" + name + "\" not found");
        }
    }

    public void setFeld(ByteAdresse adresse, String value) {
        for (Teildatensatz tds : this.teildatensatz) {
            tds.setFeld(adresse, value);
        }
    }

    public final void setVermittler(String vermittler) {
        this.setFeld(Bezeichner.VERMITTLER, vermittler);
    }

    public final String getVermittler() {
        return this.getFeld(Bezeichner.VERMITTLER).getInhalt().trim();
    }

    protected void setGdvSatzartNummer(String x) {
        this.gdvSatzartNummer = x;
    }

    public String getGdvSatzartNummer() {
        return this.gdvSatzartNummer;
    }

    public String getGdvSatzartName() {
        return this.gdvSatzartName;
    }

    protected void setGdvSatzartName(String string) {
        StringBuilder buf = new StringBuilder();
        if (this.gdvSatzartName.isEmpty()) {
            buf.append(string);
        } else {
            buf.append(this.gdvSatzartName).append(".").append(string);
        }
        this.gdvSatzartName = buf.toString();
    }

    public void resetGdvSatzartName() {
        this.gdvSatzartName = "";
    }

    private void setSatzversion(String version) {
        this.satzVersion.setInhalt(version);
    }

    public final AlphaNumFeld getSatzversion() {
        return this.satzVersion;
    }

    public final String getVersion() {
        return this.satzVersion.getInhalt();
    }

    @Deprecated
    public final String get(String name) {
        return this.get(new Bezeichner(name));
    }

    @Deprecated
    public String get(Bezeichner bezeichner) {
        Feld f = this.getFeld(bezeichner);
        if (f == Feld.NULL_FELD) {
            return "";
        }
        return f.getInhalt();
    }

    public Feld getFeld(String name) throws IllegalArgumentException {
        return this.getFeld(Bezeichner.of(name));
    }

    public boolean hasFeld(Bezeichner bezeichner) {
        for (Teildatensatz tds : this.teildatensatz) {
            if (!tds.hasFeld(bezeichner)) continue;
            return true;
        }
        return false;
    }

    public Feld getFeld(Bezeichner bezeichner) throws IllegalArgumentException {
        for (Teildatensatz tds : this.teildatensatz) {
            for (Feld f : tds.getFelder()) {
                if (!bezeichner.equals(f.getBezeichner())) continue;
                return f;
            }
        }
        return this.findFeld(bezeichner);
    }

    public Feld getFeld(ByteAdresse adresse) {
        return this.getTeildatensatz(1).getFeld(adresse);
    }

    private Feld findFeld(Bezeichner bezeichner) throws IllegalArgumentException {
        for (Teildatensatz tds : this.teildatensatz) {
            if (!tds.hasFeld(bezeichner)) continue;
            return tds.getFeld(bezeichner);
        }
        throw new IllegalArgumentException("Feld \"" + bezeichner + "\" nicht in " + this.toShortString() + " vorhanden!");
    }

    public <T extends Feld> T getFeld(Bezeichner bezeichner, Class<T> clazz) {
        if (clazz.equals(BetragMitVorzeichen.class)) {
            return (T)this.getBetragMitVorzeichen(bezeichner);
        }
        Feld feld = this.getFeld(bezeichner);
        if (clazz.isAssignableFrom(feld.getClass())) {
            return (T)feld;
        }
        try {
            Constructor<T> ctor = clazz.getConstructor(Feld.class);
            return (T)((Feld)ctor.newInstance(feld));
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException("cannot instantiate " + clazz, ex);
        }
    }

    private BetragMitVorzeichen getBetragMitVorzeichen(Bezeichner bezeichner) {
        Betrag betrag = this.getFeld(bezeichner, Betrag.class);
        Feld vorzeichen = this.getVorzeichenOf(bezeichner);
        BetragMitVorzeichen bmv = new BetragMitVorzeichen(Bezeichner.of(bezeichner.getName() + " mit Vorzeichen"), betrag.getAnzahlBytes() + 1, betrag.getByteAdresse());
        bmv.setInhalt(betrag.getInhalt() + vorzeichen.getInhalt());
        return bmv;
    }

    private Feld getVorzeichenOf(Bezeichner bezeichner) {
        for (int n = 1; n <= this.getNumberOfTeildatensaetze(); ++n) {
            Teildatensatz tds = this.getTeildatensatz(n);
            if (!tds.hasFeld(bezeichner)) continue;
            Feld beforeVorzeichen = tds.getFeld(bezeichner);
            return tds.getFeld(ByteAdresse.of(beforeVorzeichen.getEndAdresse() + 1));
        }
        throw new IllegalArgumentException(bezeichner + " does not exist");
    }

    public final String getFeldInhalt(Bezeichner bezeichner) throws IllegalArgumentException {
        return this.getFeld(bezeichner).getInhalt().trim();
    }

    public final Feld getFeld(Bezeichner bezeichner, int nr) throws IllegalArgumentException {
        return this.getFeld(bezeichner.getName(), nr);
    }

    public final Feld getFeld(String name, int nr) {
        assert (0 < nr && nr <= this.teildatensatz.length) : nr + " liegt ausserhalb des Bereichs";
        return this.teildatensatz[nr - 1].getFeld(name);
    }

    public final String getFeldInhalt(String name, int nr) {
        return this.getFeld(name, nr).getInhalt().trim();
    }

    public NumFeld getSatzartFeld() {
        if (this.teildatensatz.length > 0) {
            return this.teildatensatz[0].getSatzartFeld();
        }
        return new NumFeld(Bezeichner.SATZART, 4, 1);
    }

    public int getSatzart() {
        return this.getSatzartFeld().toInt();
    }

    @JsonIgnore
    public SatzTyp getSatzTyp() {
        if (StringUtils.isNotEmpty(this.gdvSatzartName)) {
            return SatzTyp.of(this.gdvSatzartName);
        }
        if (this.hasSparte()) {
            if (this.hasWagnisart() && this.getWagnisart().matches("\\d")) {
                return SatzTyp.of(this.getSatzart(), this.getSparte(), Integer.parseInt(this.getWagnisart()));
            }
            if (this.hasKrankenFolgeNr() && this.getKrankenFolgeNr().matches("\\d")) {
                return SatzTyp.of(this.getSatzart(), this.getSparte(), Integer.parseInt(this.getKrankenFolgeNr()));
            }
            if (this.hasBausparenArt() && this.getBausparenArt().matches("\\d")) {
                return SatzTyp.of(this.getSatzart(), this.getSparte(), Integer.parseInt(this.getBausparenArt()));
            }
            return SatzTyp.of(this.getSatzart(), this.getSparte());
        }
        return SatzTyp.of(this.getSatzart());
    }

    public boolean hasSparte() {
        return this.hasFeld(Bezeichner.of(Kopffelder1bis7.SPARTE.getBezeichnung()));
    }

    public boolean hasWagnisart() {
        return this.hasFeld(Bezeichner.WAGNISART);
    }

    public boolean hasKrankenFolgeNr() {
        return this.getSatzart() == 220 && this.getSparte() == 20 && (this.hasFeld(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_LAUFENDE_NR_TARIF) || this.hasFeld(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_BZW_LAUFENDEN_NR_TARIF));
    }

    public boolean hasBausparenArt() {
        return this.getSatzart() == 220 && this.getSparte() == 580 && this.hasFeld(Bezeichner.ART_580);
    }

    @JsonIgnore
    public int getSparte() {
        NumFeld sparte = (NumFeld)this.getFeld(Kopffelder1bis7.SPARTE.getBezeichner());
        return sparte.toInt();
    }

    @JsonIgnore
    public final String getWagnisart() {
        Feld wagnisart = this.getFeld(Bezeichner.WAGNISART);
        return wagnisart.getInhalt();
    }

    @JsonIgnore
    public final String getKrankenFolgeNr() {
        if (this.hasFeld(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_LAUFENDE_NR_TARIF)) {
            return this.get(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_LAUFENDE_NR_TARIF);
        }
        return this.get(Bezeichner.FOLGE_NR_ZUR_LAUFENDEN_PERSONEN_NR_UNTER_NR_BZW_LAUFENDEN_NR_TARIF);
    }

    @JsonIgnore
    public final String getBausparenArt() {
        Feld art = this.getFeld(Bezeichner.ART_580);
        return art.getInhalt();
    }

    public void export(Writer writer) throws IOException {
        for (Teildatensatz tds : this.teildatensatz) {
            tds.export(writer);
        }
    }

    public void export(File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            this.export(writer);
        }
    }

    public void export(Writer writer, String eod) throws IOException {
        for (Teildatensatz tds : this.teildatensatz) {
            tds.export(writer, eod);
        }
    }

    public void export(OutputStream ostream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(ostream);
        this.export(writer);
        ((Writer)writer).flush();
        ostream.flush();
    }

    public Satz importFrom(String s) throws IOException {
        return this.importFrom(new PushbackLineNumberReader(new StringReader(s), 256));
    }

    protected void removeUnusedTeildatensaetze(SortedSet<Integer> usedIndexes) {
        Teildatensatz[] usedTeildatensaetze = new Teildatensatz[usedIndexes.size()];
        int i = 0;
        Iterator iterator2 = usedIndexes.iterator();
        while (iterator2.hasNext()) {
            int teilsatzIndex = (Integer)iterator2.next();
            usedTeildatensaetze[i] = this.teildatensatz[teilsatzIndex];
            ++i;
        }
        this.teildatensatz = usedTeildatensaetze;
    }

    public Satz importFrom(File file) throws IOException {
        try (FileReader reader = new FileReader(file);){
            Satz satz = this.importFrom(reader);
            return satz;
        }
    }

    protected final int getSatzlength(String s) {
        int satzlength = 256;
        try {
            char c257;
            char c256 = s.charAt(256);
            if (c256 == '\n' || c256 == '\r') {
                satzlength = 257;
            }
            if (s.length() > satzlength && ((c257 = s.charAt(257)) == '\n' || c257 == '\r')) {
                satzlength = 258;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.trace("end of string \"" + s + "\" reached", (Throwable)e);
        }
        return satzlength;
    }

    public final Satz importFrom(InputStream istream) throws IOException {
        return this.importFrom(new InputStreamReader(istream, Config.DEFAULT_ENCODING));
    }

    public final Satz importFrom(Reader reader) throws IOException {
        PushbackLineNumberReader lnr = new PushbackLineNumberReader(reader, 256);
        try {
            return this.importFrom(lnr);
        }
        catch (IOException ioe) {
            throw new ImportException(lnr, "read error", ioe);
        }
        catch (NumberFormatException nfe) {
            throw new ImportException(lnr, "number expected", nfe);
        }
    }

    public final Satz importFrom(PushbackLineNumberReader reader) throws IOException {
        TreeSet<Integer> used = new TreeSet<Integer>();
        char[] feld1to7 = null;
        char satznummer = '0';
        for (int i = 0; i < this.teildatensatz.length; ++i) {
            reader.skipNewline();
            if (!this.matchesNextTeildatensatz(reader, feld1to7, Character.valueOf(satznummer))) {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Zeile {}: mehr Teildatensaetze erwartet fuer {}.", (Object)reader.getLineNumber(), (Object)this);
                break;
            }
            boolean teildatensatzGefunden = false;
            for (int j = i; j < this.teildatensatz.length; ++j) {
                char nr = Satznummer.readSatznummer(reader, this.teildatensatz[j]).toChar();
                if (Character.isDigit(nr) && this.teildatensatz[j].getSatznummer().toChar() == nr) {
                    i = j;
                    teildatensatzGefunden = true;
                    satznummer = nr;
                    break;
                }
                LOG.debug("Zeile {}: {} erwartet statt {} - ueberspringe Teildatensatz {}.", (Object)reader.getLineNumber(), (Object)this.teildatensatz[j].getSatznummer(), (Object)Character.valueOf(nr), (Object)(j + 1));
            }
            if (!teildatensatzGefunden && i > 0) break;
            used.add(i);
            char[] cbuf = new char[257];
            Satz.importFrom(reader, cbuf);
            this.teildatensatz[i].importFrom(new String(cbuf));
            feld1to7 = Arrays.copyOfRange(cbuf, 0, 42);
        }
        this.removeUnusedTeildatensaetze(used);
        return this;
    }

    protected boolean matchesNextTeildatensatz(PushbackLineNumberReader reader, char[] lastFeld1To7, Character satznummer) throws IOException {
        try {
            int art = Importer.of(reader).readSatzart();
            return art == this.getSatzart();
        }
        catch (EOFException ex) {
            LOG.info("No next teildatensatz found ({}).", (Object)ex.getLocalizedMessage());
            LOG.debug("Details:", (Throwable)ex);
            return false;
        }
    }

    private static void importFrom(Reader reader, char[] cbuf) throws IOException {
        if (reader.read(cbuf, 0, 256) == -1) {
            throw new EOFException("can't read 256 bytes from " + reader);
        }
    }

    @Deprecated
    public static int readSatzart(PushbackLineNumberReader reader) throws IOException {
        return Importer.of(reader).readSatzart();
    }

    public boolean isValid() {
        if (!this.getSatzartFeld().isValid() || this.getSatzart() < 1) {
            return false;
        }
        if (this.teildatensatz != null) {
            for (int i = 0; i < this.teildatensatz.length; ++i) {
                if (this.teildatensatz[i].isValid()) continue;
                LOG.info("Teildatensatz " + (i + 1) + " is invalid");
                return false;
            }
        }
        return true;
    }

    public boolean isComplete() {
        Satz reference = SatzRegistry.getInstance().getSatz(this.getSatzTyp());
        return this.getNumberOfTeildatensaetze() == reference.getNumberOfTeildatensaetze();
    }

    public void mergeWith(Satz other) {
        if (this.canBeMergedWith(other)) {
            LOG.info("{} wird mit {} zusammengefasst.", (Object)this, (Object)other);
            for (Teildatensatz otherTds : other.teildatensatz) {
                this.add(otherTds);
            }
            other.removeUnusedTeildatensaetze(new TreeSet<Integer>());
        }
    }

    private boolean canBeMergedWith(Satz other) {
        ByteAdresse vsNrAdresse = ByteAdresse.of(14);
        for (Teildatensatz otherTds : other.teildatensatz) {
            Zeichen satznr = otherTds.getSatznummer();
            Feld versicherungscheinnr = otherTds.getFeld(ByteAdresse.VERSICHERUNGSSCHEINNUMMER);
            Feld folgenummer = otherTds.getFeld(Bezeichner.FOLGENUMMER);
            for (Teildatensatz thisTds : this.teildatensatz) {
                if (satznr.equals(thisTds.getSatznummer())) {
                    return false;
                }
                if (versicherungscheinnr.equals(thisTds.getFeld(ByteAdresse.VERSICHERUNGSSCHEINNUMMER)) || folgenummer.equals(thisTds.getFeld(Bezeichner.FOLGENUMMER))) continue;
                return false;
            }
        }
        return true;
    }

    public List<ConstraintViolation> validate() {
        return this.validate(this.config);
    }

    public List<ConstraintViolation> validate(Config validationConfig) {
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        if (validationConfig.getValidateMode() == Config.ValidateMode.STRICT) {
            Validator validator = new Validator();
            violations.addAll(validator.validate(this));
        }
        if (!this.getSatzartFeld().isValid() || this.getSatzart() < 1) {
            SimpleConstraintViolation cv = new SimpleConstraintViolation("invalid Satzart " + this.getSatzartFeld().getInhalt(), this, this.getSatzartFeld());
            violations.add(cv);
        }
        if (this.teildatensatz != null) {
            for (Teildatensatz tds : this.teildatensatz) {
                List<ConstraintViolation> tdsViolations = tds.validate(validationConfig);
                if (tdsViolations.isEmpty()) continue;
                violations.add(new SimpleConstraintViolation(tds, tdsViolations));
            }
        }
        violations.addAll(this.validateUniqueEntries());
        return violations;
    }

    private List<ConstraintViolation> validateUniqueEntries() {
        Bezeichner[] bezeichner;
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        for (Bezeichner b : bezeichner = new Bezeichner[]{Bezeichner.VU_NR, Bezeichner.VS_NR, Bezeichner.VERMITTLER}) {
            if (!this.hasFeld(b)) continue;
            String inhalt = this.getFeldInhalt(b);
            for (Teildatensatz tds : this.teildatensatz) {
                if (!tds.hasFeld(b) || inhalt.equals(tds.getFeldInhalt(b))) continue;
                SimpleConstraintViolation cv = new SimpleConstraintViolation("has different values: " + this.getFeld(b), this, tds.getFeld(b));
                violations.add(cv);
            }
        }
        return violations;
    }

    public final String toString() {
        try {
            return this.toShortString() + " (" + StringUtils.abbreviate(this.toLongString(), 47) + ")";
        }
        catch (RuntimeException shouldNeverHappen) {
            LOG.error("shit happens in toString()", (Throwable)shouldNeverHappen);
            return super.toString();
        }
    }

    public String toShortString() {
        return "Satzart " + this.getSatzTyp();
    }

    public String toLongString() {
        StringWriter swriter = new StringWriter();
        try {
            this.export(swriter, System.lineSeparator());
        }
        catch (IOException canthappen) {
            LOG.warn(canthappen + " ignored", (Throwable)canthappen);
            swriter.write(canthappen.getLocalizedMessage());
        }
        return swriter.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Satz)) {
            return false;
        }
        Satz other = (Satz)obj;
        return this.toLongString().equals(other.toLongString());
    }

    public int hashCode() {
        return this.getSatzart() * 1000000 + this.teildatensatz.length;
    }

    public Collection<Feld> getFelder() {
        ArrayList<Feld> felder = new ArrayList<Feld>();
        for (Teildatensatz tds : this.getTeildatensaetze()) {
            for (Feld feld : tds.getFelder()) {
                if (Satz.contains(feld.getBezeichner(), felder)) continue;
                felder.add(feld);
            }
        }
        return felder;
    }

    private static boolean contains(Bezeichner bezeichner, List<Feld> felder) {
        for (Feld feld : felder) {
            if (!bezeichner.equals(feld.getBezeichner())) continue;
            return true;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Satz cloned = (Satz)super.clone();
        cloned.teildatensatz = new Teildatensatz[this.teildatensatz.length];
        for (int i = 0; i < this.teildatensatz.length; ++i) {
            cloned.teildatensatz[i] = new Teildatensatz(this.teildatensatz[i]);
        }
        return cloned;
    }
}

