/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz;

import gdv.xport.config.Config;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.ByteAdresse;
import gdv.xport.feld.Feld;
import gdv.xport.feld.NumFeld;
import gdv.xport.feld.Satznummer;
import gdv.xport.feld.Zeichen;
import gdv.xport.io.ImportException;
import gdv.xport.satz.Satz;
import gdv.xport.util.NotUniqueException;
import gdv.xport.util.SatzTyp;
import gdv.xport.util.SimpleConstraintViolation;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import net.sf.oval.ConstraintViolation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Teildatensatz
extends Satz {
    private static final Logger LOG = LogManager.getLogger(Teildatensatz.class);
    private final Collection<Feld> datenfelder = Config.getInstance().isDebug() ? new TreeSet() : new ArrayList();
    protected Satznummer satznummer = new Satznummer();

    public Teildatensatz(SatzTyp satzTyp) {
        this.initDatenfelder(satzTyp);
    }

    public Teildatensatz(SatzTyp satzTyp, int nr) {
        this(satzTyp);
        this.initSatznummer(satzTyp, nr);
        this.setGdvSatzartName(satzTyp.toString());
        if (satzTyp.hasGdvSatzartNummer()) {
            this.setGdvSatzartNummer(String.valueOf(satzTyp.getGdvSatzartNummer()));
        }
    }

    public Teildatensatz(Satz satz, int nr) {
        super(satz, 0);
        this.initSatznummer(satz.getSatzTyp(), nr);
    }

    public Teildatensatz(Teildatensatz other) {
        super((Satz)other, 0);
        this.satznummer = other.satznummer;
        for (Feld f : other.datenfelder) {
            Feld copy = (Feld)f.clone();
            this.datenfelder.add(copy);
        }
    }

    private void initSatznummer(SatzTyp satzTyp, int nr) {
        if (nr < 1 || nr > 9) {
            throw new IllegalArgumentException("Satznummer (" + nr + ") muss zwischen 1 und 9 liegen");
        }
        this.satznummer.setInhalt(Character.forDigit(nr, 10));
        this.initDatenfelder(satzTyp);
    }

    private void initDatenfelder(SatzTyp satzTyp) {
        NumFeld satzart = new NumFeld(Bezeichner.SATZART, 4, 1).mitConfig(this.getConfig());
        satzart.setInhalt(satzTyp.getSatzart());
        this.add(satzart);
    }

    @Override
    public NumFeld getSatzartFeld() {
        Optional<Feld> satzart = this.findFeld(Bezeichner.SATZART);
        return satzart.map(feld -> (NumFeld)feld).orElseGet(() -> new NumFeld(Bezeichner.SATZART, 4, 1));
    }

    public Zeichen getSatznummer() {
        if (this.satznummer.getByteAdresse() == 256 && this.hasFeld(Bezeichner.SATZNUMMER)) {
            Satznummer nr = this.getFeld(Bezeichner.SATZNUMMER, Satznummer.class);
            if (nr.isEmpty() || nr.isInvalid()) {
                nr.setInhalt(this.satznummer.getInhalt());
            }
            this.satznummer = nr;
        }
        return new Zeichen(this.satznummer);
    }

    @Deprecated
    public void setSatznummer(Zeichen satznummer) {
        String nr = this.satznummer.getInhalt();
        this.remove(Bezeichner.SATZNUMMER);
        this.satznummer = new Satznummer(satznummer);
        this.satznummer.setInhalt(nr);
        this.add(this.satznummer);
    }

    @Override
    public void add(Feld feld) {
        for (Feld f : this.getFelder()) {
            if (LOG.isDebugEnabled() && f.getBezeichnung().startsWith("Satznummer") && feld.getBezeichnung().startsWith("Satznummer")) {
                LOG.debug(f.getBezeichnung() + "(" + f.getBezeichner().getTechnischerName() + ") gefunden in " + this + this.getSatznummer());
            }
            if (!feld.equals(f) && feld.overlapsWith(f)) {
                throw new IllegalArgumentException("conflict: " + feld + " overlaps with " + f);
            }
            if (feld.compareTo(f) != 0) continue;
            this.remove(f);
            LOG.debug("{} wird durch {} ersetzt.", (Object)f, (Object)feld);
        }
        this.setUpFeld(feld);
        this.datenfelder.add(feld);
    }

    private void setUpFeld(Feld feld) {
        if (feld.getBezeichnung().startsWith("Satznummernwiederholung")) {
            feld.setInhalt(this.satznummer.getInhalt());
        } else if (feld.getBezeichnung().startsWith("Satznummer")) {
            LOG.debug("{}({}) einfuegen in {} +", (Object)feld.getBezeichnung(), (Object)feld.getBezeichner().getTechnischerName(), (Object)this);
            feld.setInhalt(this.satznummer.getInhalt());
            if (this.getSatznummer().getByteAdresse() >= feld.getByteAdresse()) {
                this.satznummer = new Satznummer(feld);
            }
        } else if (feld.getBezeichner().equals(Bezeichner.ZUSAETZLICHE_SATZKENNUNG)) {
            feld.setInhalt("X");
        } else if (feld.getBezeichnung().startsWith("Vorzeichen")) {
            LOG.debug("{}({}) einfuegen in {} +", (Object)feld.getBezeichnung(), (Object)feld.getBezeichner().getTechnischerName(), (Object)this);
            feld.setInhalt("+");
        } else if (this.getSatzart() == 1 && feld.getBezeichner().getTechnischerName().equals("Satzart0001")) {
            LOG.debug("{}({}) einfuegen in {} {}}", (Object)feld.getBezeichnung(), (Object)feld.getBezeichner().getTechnischerName(), (Object)this, (Object)this.getSatzversion());
            feld.setInhalt(this.getSatzversion().getInhalt());
        } else if (this.getGdvSatzartName().startsWith("0220.020") && feld.getBezeichner().getTechnischerName().startsWith("FolgeNrZurLaufendenPersonenNrUnterNr")) {
            LOG.debug("{}({}) einfuegen in {} +", (Object)feld.getBezeichnung(), (Object)feld.getBezeichner().getTechnischerName(), (Object)this);
            feld.setInhalt(this.getSatzTyp().getKrankenFolgeNr());
        }
    }

    public void remove(Feld feld) {
        this.datenfelder.remove(feld);
    }

    @Override
    public void remove(Bezeichner bezeichner) {
        if (this.hasFeld(bezeichner)) {
            this.datenfelder.remove(this.getFeld(bezeichner));
            LOG.debug("{} was removed from {}.", (Object)bezeichner, (Object)this);
        }
    }

    @Override
    public void setFeld(Bezeichner name, String value) {
        List<Feld> felder = this.getAllFelder(name);
        if (felder.isEmpty()) {
            throw new IllegalArgumentException("Feld \"" + name + "\" not found");
        }
        if (felder.size() > 1) {
            LOG.info("Mit Bezeichner {} werden mehrere Felder in '{}' mit '{}' belegt: {}", (Object)name, (Object)this, (Object)value, (Object)felder);
        }
        for (Feld x : felder) {
            this.setFeld(x, value);
        }
    }

    @Deprecated
    public void set(ByteAdresse adresse, String value) {
        Feld x = this.getFeld(adresse);
        x.setInhalt(value);
    }

    @Override
    public void setFeld(ByteAdresse adresse, String value) {
        Feld x = this.getFeld(adresse);
        this.setFeld(x, value);
    }

    private void setFeld(Feld x, String value) {
        try {
            LOG.debug("{} in '{}' wird mit '{}' belegt.", (Object)x, (Object)this, (Object)value);
            x.setInhalt(value);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(String.format("%s: illegal value '%s' for %s", this.toShortString(), value, x), iae);
        }
    }

    @Override
    public Feld getFeld(Bezeichner bezeichner) {
        List<Feld> found = this.getAllFelder(bezeichner);
        if (found.isEmpty()) {
            Optional<Feld> feld = this.findFeld(bezeichner);
            if (feld.isPresent()) {
                return feld.get();
            }
            throw new IllegalArgumentException("Feld \"" + bezeichner + "\" nicht in " + this.toShortString() + " nicht vorhanden!");
        }
        if (found.size() > 1) {
            Teildatensatz.checkUniqueness(found);
        }
        return found.get(0);
    }

    private static void checkUniqueness(List<Feld> felder) {
        Feld f1 = felder.get(0);
        for (int i = 1; i < felder.size(); ++i) {
            Feld fn = felder.get(i);
            if (f1.getInhalt().equals(fn.getInhalt())) continue;
            throw new NotUniqueException(String.format("same Bezeichner, different values: '%s', '%s'", f1, fn));
        }
        LOG.debug("{} hat gleichen Wert wie gleichlautende Felder.", (Object)f1);
    }

    private List<Feld> getAllFelder(Bezeichner bezeichner) {
        ArrayList<Feld> found = new ArrayList<Feld>();
        for (Bezeichner b : bezeichner.getVariants()) {
            for (Feld feld : this.datenfelder) {
                if (!b.equals(feld.getBezeichner())) continue;
                found.add(feld);
            }
        }
        return found;
    }

    private Optional<Feld> findFeld(Bezeichner bezeichner) {
        if (this.datenfelder == null) {
            return Optional.empty();
        }
        for (Feld f : this.datenfelder) {
            if (!f.getBezeichner().getName().equals(bezeichner.getName())) continue;
            return Optional.of(f);
        }
        return Optional.empty();
    }

    public Feld getFeld(int nr) {
        int myNr = nr;
        switch (this.getGdvSatzartName()) {
            case "0100": {
                if (!"1".equals(this.getSatznummer().getInhalt()) || myNr != 27) break;
                --myNr;
                break;
            }
            case "0210.050": {
                if (!"1".equals(this.getSatznummer().getInhalt()) || myNr != 35) break;
                --myNr;
                break;
            }
            case "0220.010.13.1": {
                if (!"1".equals(this.getSatznummer().getInhalt()) || myNr != 46) break;
                --myNr;
                break;
            }
            case "0600": {
                if ("2".equals(this.getSatznummer().getInhalt()) && myNr == 13) {
                    --myNr;
                    break;
                }
                if (!"3".equals(this.getSatznummer().getInhalt()) || myNr != 14) break;
                --myNr;
                break;
            }
            case "9950": 
            case "9951": {
                if (!"1".equals(this.getSatznummer().getInhalt()) || myNr != 11) break;
                --myNr;
                break;
            }
        }
        return (Feld)this.getFelder().toArray()[myNr - 1];
    }

    @Override
    public Feld getFeld(ByteAdresse adresse) {
        for (Feld f : this.datenfelder) {
            if (adresse.intValue() != f.getByteAdresse()) continue;
            return f;
        }
        throw new IllegalArgumentException(String.format("Adresse %s existiert nicht in %s", adresse, this.toShortString()));
    }

    @Override
    public boolean hasFeld(Bezeichner bezeichner) {
        for (Bezeichner b : bezeichner.getVariants()) {
            for (Feld f : this.datenfelder) {
                if (!b.equals(f.getBezeichner())) continue;
                return true;
            }
            if (!this.findFeld(b).isPresent()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFeld(Feld feld) {
        for (Feld f : this.datenfelder) {
            if (!feld.getBezeichner().equals(f.getBezeichner())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Collection<Feld> getFelder() {
        return new TreeSet<Feld>(this.datenfelder);
    }

    public List<Zeichen> getSatzIdent() {
        String[] identBezeichner = new String[]{"FolgeNrZurLaufendenPersonenNrUnterNrBzwLaufendenNrTarif", "FolgeNrZurLaufendenPersonenNrUnterNrLaufendeNrTarif", "SatzNr", "SatzNr1", "SatzNr2", "SatzNr3", "SatzNr4", "SatzNr9", "SatzNrnwiederholung", "SatzNrnwiederholung1", "SatzNrnwiederholung2", "SatzNrnwiederholung3", "Satznummer", "ZusaetzlicheSatzkennung"};
        ArrayList<Zeichen> satzIdent = new ArrayList<Zeichen>();
        for (String s : identBezeichner) {
            Bezeichner b = Bezeichner.of(s);
            if (!this.hasFeld(b)) continue;
            satzIdent.add(this.getFeld(b, Zeichen.class));
        }
        return satzIdent;
    }

    @Override
    public void export(Writer writer) throws IOException {
        String eod = this.getConfig().getProperty("gdv.eod", System.lineSeparator());
        this.export(writer, eod);
    }

    @Override
    public void export(Writer writer, String eod) throws IOException {
        StringBuilder data = new StringBuilder(256);
        for (int i = 0; i < 256; ++i) {
            data.append(' ');
        }
        for (Feld feld : this.datenfelder) {
            int start = feld.getByteAdresse() - 1;
            int end = start + feld.getAnzahlBytes();
            data.replace(start, end, feld.getInhalt());
        }
        assert (data.length() == 256) : "Teildatensatz ist " + data.length() + " und nicht 256 Bytes lang";
        writer.write(data.toString());
        writer.write(eod);
    }

    @Override
    public Teildatensatz importFrom(String content) throws IOException {
        for (Feld feld : this.datenfelder) {
            int begin = (feld.getByteAdresse() - 1) % 256;
            int end = begin + feld.getAnzahlBytes();
            if (end > content.length()) {
                throw new ImportException("input string is too short (" + (end - content.length()) + " bytes missing): " + content);
            }
            String s = content.substring(begin, end);
            feld.setInhalt(s);
        }
        return this;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        for (Feld feld : this.datenfelder) {
            if (feld.isValid()) continue;
            LOG.info(feld + " is not valid");
            return false;
        }
        return true;
    }

    @Override
    public List<ConstraintViolation> validate(Config validationConfig) {
        List<ConstraintViolation> violations = this.validateSatznummern(validationConfig);
        for (Feld feld : this.datenfelder) {
            violations.addAll(feld.validate(validationConfig));
        }
        return violations;
    }

    private List<ConstraintViolation> validateSatznummern(Config validationConfig) {
        ArrayList<ConstraintViolation> violations = new ArrayList<ConstraintViolation>();
        if (validationConfig.getValidateMode() != Config.ValidateMode.OFF) {
            LOG.debug("Satznummern werden validiert in {}.", (Object)this);
            Zeichen satznr = this.getSatznummer();
            for (Feld feld : this.datenfelder) {
                if (!feld.getBezeichner().isVariantOf(Bezeichner.SATZNUMMER) || satznr.getInhalt().equals(feld.getInhalt())) continue;
                SimpleConstraintViolation cv = new SimpleConstraintViolation("different Satznummern: " + satznr, this, feld);
                violations.add(cv);
            }
        }
        return violations;
    }

    @Override
    public String toShortString() {
        if (this.datenfelder.size() < 4) {
            return String.format("Teildatensatz Satzart %04d", this.getSatzart());
        }
        return String.format("Teildatensatz %c Satzart %s", Character.valueOf(this.getSatznummer().toChar()), this.getSatzTyp());
    }

    @Override
    public Object clone() {
        return new Teildatensatz(this);
    }
}

