/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gdv.xport.config.Config;
import gdv.xport.feld.Bezeichner;
import gdv.xport.feld.ByteAdresse;
import gdv.xport.feld.Datum;
import gdv.xport.feld.Feld;
import gdv.xport.feld.Version;
import gdv.xport.satz.Satz;
import gdv.xport.util.SatzRegistry;
import gdv.xport.util.SatzTyp;
import gdv.xport.util.VersionHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Vorsatz
extends Satz {
    public static final SatzTyp SATZART = SatzTyp.of("0001");
    private static final Logger LOG = LogManager.getLogger(Vorsatz.class);
    private final VersionHandler versionHandler;

    public Vorsatz() {
        this(SatzRegistry.getInstance());
    }

    public Vorsatz(SatzRegistry factory) {
        this(factory.getSatz(SATZART), factory);
    }

    private Vorsatz(Satz vorlage, VersionHandler versionHandler) {
        super(vorlage, vorlage.cloneTeildatensaetze());
        this.versionHandler = versionHandler;
        this.setVuNummer(Config.getInstance().getVUNr().getInhalt());
    }

    public Vorsatz(String content) {
        this();
        try {
            this.importFrom(content);
            LOG.debug(this + " created from \"" + content + '\"');
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("argument too short", ioe);
        }
    }

    public Vorsatz(Vorsatz other) {
        this((Satz)other, other.versionHandler);
    }

    private static Bezeichner getVersionBezeichner(int art) {
        try (Formatter formatter = new Formatter();){
            String bezeichnung = formatter.format("Version Satzart %04d", art).toString();
            Bezeichner bezeichner = Bezeichner.of(bezeichnung);
            return bezeichner;
        }
    }

    private static Bezeichner getVersionBezeichner(int art, int sparte) {
        try (Formatter formatter = new Formatter();){
            String bezeichnung = formatter.format("Version Satzart %04d %03d", art, sparte).toString();
            Bezeichner bezeichner = Bezeichner.of(bezeichnung);
            return bezeichner;
        }
    }

    public void setVuNummer(String s) {
        assert (s.length() <= 5) : s + " darf nur max. 5 Zeichen lang sein";
        this.setFeld(ByteAdresse.VU_NUMMER, s);
    }

    public String getVuNummer() {
        return this.getFeld(ByteAdresse.VU_NUMMER).getInhalt().trim();
    }

    public void setAbsender(String name) {
        this.setFeld(Bezeichner.ABSENDER, name);
    }

    public String getAbsender() {
        return this.getFeld(Bezeichner.ABSENDER).getInhalt().trim();
    }

    public void setAdressat(String name) {
        this.setFeld(Bezeichner.ADRESSAT, name);
    }

    public String getAdressat() {
        return this.getFeld(Bezeichner.ADRESSAT).getInhalt().trim();
    }

    public void setErstellungsZeitraum(String startDatum, String endDatum) {
        Datum von = new Datum(Bezeichner.ERSTELLUNGSDAT_ZEITRAUM_VOM, 70);
        Datum bis = new Datum(Bezeichner.ERSTELLUNGSDAT_ZEITRAUM_BIS, 78);
        von.setInhalt(startDatum);
        bis.setInhalt(endDatum);
        this.setFeld(Bezeichner.ERSTELLUNGS_DAT_ZEITRAUM_VOM_ZEITRAUM_BIS, von.getInhalt().concat(bis.getInhalt()));
    }

    public void setErstellungsZeitraum(Datum startDatum, Datum endDatum) {
        this.setFeld(Bezeichner.ERSTELLUNGS_DAT_ZEITRAUM_VOM_ZEITRAUM_BIS, startDatum.getInhalt().concat(endDatum.getInhalt()));
    }

    public String getErstellungsZeitraum() {
        return this.getFeld(Bezeichner.ERSTELLUNGS_DAT_ZEITRAUM_VOM_ZEITRAUM_BIS).getInhalt().trim();
    }

    public void setErstellungsZeitraumVon(Datum von) {
        this.setErstellungsZeitraum(von, this.getErstellungsZeitraumBis());
    }

    public Datum getErstellungsZeitraumVon() {
        Feld vonBis = super.getFeld(Bezeichner.ERSTELLUNGS_DAT_ZEITRAUM_VOM_ZEITRAUM_BIS);
        Datum von = new Datum(Bezeichner.ERSTELLUNGSDAT_ZEITRAUM_VOM, 8, vonBis.getByteAdresse());
        von.setInhalt(vonBis.getInhalt().substring(0, 8));
        return von;
    }

    public void setErstellungsZeitraumBis(Datum bis) {
        this.setErstellungsZeitraum(this.getErstellungsZeitraumVon(), bis);
    }

    public Datum getErstellungsZeitraumBis() {
        Feld vonBis = super.getFeld(Bezeichner.ERSTELLUNGS_DAT_ZEITRAUM_VOM_ZEITRAUM_BIS);
        Datum bis = new Datum(Bezeichner.ERSTELLUNGSDAT_ZEITRAUM_BIS, 8, vonBis.getByteAdresse() + 8);
        bis.setInhalt(vonBis.getInhalt().substring(8));
        return bis;
    }

    public String getVersion(Satz satz) {
        return this.getVersion(satz.getSatzTyp());
    }

    public String getVersion(Bezeichner bezeichner) {
        return this.getFeld(bezeichner).getInhalt();
    }

    public String getVersion(String bezeichner) {
        return this.getFeld(bezeichner).getInhalt();
    }

    public String getVersion(int art) {
        return this.getVersion(Vorsatz.getVersionBezeichner(art));
    }

    public String getVersion(int art, int sparte) {
        return this.getVersion(Vorsatz.getVersionBezeichner(art, sparte));
    }

    public String getVersion(SatzTyp satzTyp) {
        Bezeichner bezeichner = Bezeichner.of("Version Satzart " + satzTyp);
        return this.getVersion(bezeichner);
    }

    @JsonIgnore
    public void setVersion(Satz satz) {
        Bezeichner bezeichner;
        StringBuilder buf = new StringBuilder();
        String[] parts = StringUtils.split(satz.getSatzTyp().toString(), '.');
        buf.append("Satzart");
        buf.append(parts[0]);
        if (parts.length > 1) {
            buf.append(parts[1]);
        }
        if (this.hasFeld(bezeichner = Bezeichner.of(buf.toString()))) {
            this.setFeld(bezeichner, satz.getSatzversion().getInhalt());
        } else {
            LOG.warn("Version Satzart {} ist im Vorsatz unbekannt.", (Object)satz.getSatzTyp());
        }
    }

    public void setVersion(SatzTyp satzTyp) {
        Bezeichner bezeichner;
        StringBuilder buf = new StringBuilder();
        String[] parts = StringUtils.split(satzTyp.toString(), '.');
        buf.append("Satzart");
        buf.append(parts[0]);
        if (parts.length > 1) {
            buf.append(parts[1]);
        }
        if (!this.hasFeld(bezeichner = Bezeichner.of(buf.toString()))) {
            throw new IllegalArgumentException("Version Satzart " + bezeichner + " unbekannt");
        }
        this.setFeld(bezeichner, this.versionHandler.getVersionOf(satzTyp));
    }

    public void setVersion(Bezeichner bezeichner, String version) {
        this.getFeld(bezeichner).setInhalt(version);
    }

    @Deprecated
    public void setVersion(int art, String version) {
        this.setVersion(Vorsatz.getVersionBezeichner(art), version);
    }

    public void setVersion(int art, int sparte, String version) {
        this.setVersion(Vorsatz.getVersionBezeichner(art, sparte), version);
    }

    public Map<SatzTyp, Version> getSatzartVersionen() {
        HashMap<SatzTyp, Version> versionen = new HashMap<SatzTyp, Version>();
        block12: for (Feld f : this.getFelder()) {
            if (f.isEmpty() || !f.getBezeichner().getTechnischerName().startsWith("Satzart") || f.getBezeichner().equals(Bezeichner.SATZART)) continue;
            Version v = new Version(f);
            switch (f.getBezeichner().getTechnischerName()) {
                case "Satzart0220020": {
                    versionen.put(SatzTyp.of("0220.020.1"), v);
                    versionen.put(SatzTyp.of("0220.020.2"), v);
                    versionen.put(SatzTyp.of("0220.020.3"), v);
                    continue block12;
                }
                case "Satzart0220580": {
                    versionen.put(SatzTyp.of("0220.580.01"), v);
                    versionen.put(SatzTyp.of("0220.580.2"), v);
                    continue block12;
                }
                case "Satzart0220010": {
                    versionen.put(SatzTyp.of("0220.010.0"), v);
                    versionen.put(SatzTyp.of("0220.010.13.1"), v);
                    versionen.put(SatzTyp.of("0220.010.13.6"), v);
                    versionen.put(SatzTyp.of("0220.010.13.7"), v);
                    versionen.put(SatzTyp.of("0220.010.13.8"), v);
                    versionen.put(SatzTyp.of("0220.010.13.9"), v);
                    versionen.put(SatzTyp.of("0220.010.2.1"), v);
                    versionen.put(SatzTyp.of("0220.010.2.6"), v);
                    versionen.put(SatzTyp.of("0220.010.2.7"), v);
                    versionen.put(SatzTyp.of("0220.010.2.8"), v);
                    versionen.put(SatzTyp.of("0220.010.2.9"), v);
                    versionen.put(SatzTyp.of("0220.010.48.1"), v);
                    versionen.put(SatzTyp.of("0220.010.48.6"), v);
                    versionen.put(SatzTyp.of("0220.010.48.8"), v);
                    versionen.put(SatzTyp.of("0220.010.48.9"), v);
                    versionen.put(SatzTyp.of("0220.010.5.1"), v);
                    versionen.put(SatzTyp.of("0220.010.5.6"), v);
                    versionen.put(SatzTyp.of("0220.010.5.8"), v);
                    versionen.put(SatzTyp.of("0220.010.5.9"), v);
                    versionen.put(SatzTyp.of("0220.010.6.1"), v);
                    versionen.put(SatzTyp.of("0220.010.6.6"), v);
                    versionen.put(SatzTyp.of("0220.010.6.8"), v);
                    versionen.put(SatzTyp.of("0220.010.6.9"), v);
                    versionen.put(SatzTyp.of("0220.010.7.1"), v);
                    versionen.put(SatzTyp.of("0220.010.7.6"), v);
                    versionen.put(SatzTyp.of("0220.010.7.8"), v);
                    versionen.put(SatzTyp.of("0220.010.7.9"), v);
                    versionen.put(SatzTyp.of("0220.010.9.1"), v);
                    versionen.put(SatzTyp.of("0220.010.9.6"), v);
                    versionen.put(SatzTyp.of("0220.010.9.7"), v);
                    versionen.put(SatzTyp.of("0220.010.9.8"), v);
                    versionen.put(SatzTyp.of("0220.010.9.9"), v);
                    continue block12;
                }
                case "Satzart0221010": {
                    versionen.put(SatzTyp.of("0221.010.13.1"), v);
                    versionen.put(SatzTyp.of("0221.010.13.7"), v);
                    versionen.put(SatzTyp.of("0221.010.13.8"), v);
                    versionen.put(SatzTyp.of("0221.010.2.1"), v);
                    versionen.put(SatzTyp.of("0221.010.2.7"), v);
                    versionen.put(SatzTyp.of("0221.010.2.8"), v);
                    versionen.put(SatzTyp.of("0221.010.48.1"), v);
                    versionen.put(SatzTyp.of("0221.010.5.1"), v);
                    versionen.put(SatzTyp.of("0221.010.5.8"), v);
                    versionen.put(SatzTyp.of("0221.010.6.1"), v);
                    versionen.put(SatzTyp.of("0221.010.6.8"), v);
                    versionen.put(SatzTyp.of("0221.010.7.1"), v);
                    versionen.put(SatzTyp.of("0221.010.7.8"), v);
                    continue block12;
                }
            }
            versionen.put(v.getSatzTyp(), v);
        }
        return versionen;
    }

    @Override
    public Feld getFeld(Bezeichner bezeichner) throws IllegalArgumentException {
        if (bezeichner.equals(Bezeichner.ERSTELLUNGSDAT_ZEITRAUM_BIS)) {
            return this.getErstellungsZeitraumBis();
        }
        if (bezeichner.equals(Bezeichner.ERSTELLUNGSDAT_ZEITRAUM_VOM)) {
            return this.getErstellungsZeitraumVon();
        }
        return super.getFeld(bezeichner);
    }

    @Override
    public Collection<Feld> getFelder() {
        ArrayList<Feld> felder = new ArrayList<Feld>();
        for (Feld f : super.getFelder()) {
            if (f.getBezeichner().equals(Bezeichner.ERSTELLUNGS_DAT_ZEITRAUM_VOM_ZEITRAUM_BIS)) {
                felder.add(this.getErstellungsZeitraumVon());
                felder.add(this.getErstellungsZeitraumBis());
                continue;
            }
            felder.add(f);
        }
        return felder;
    }
}

