/*
 * Decompiled with CFR 0.152.
 */
package gdv.xport.satz.feld.common;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum WagnisartLeben {
    NULL(-1),
    ANGABEN_VERSICHERTE_PERSON(0),
    KAPITALLEBENSVERSICHERUNG(1),
    RISIKOVERSICHERUNG(3),
    RENTENVERSICHERUNG(2),
    BU(4),
    BU_SELBSTSTAENDIGE(8),
    RISIKOZUSATZ(5),
    UNFALL(6),
    KAPITAL_ODER_FONDGEBUNDENE_LEBENSVERSICHERUNG(7),
    FONDSGEBUNDENE_RENTENVERSICHERUNG(9);

    private static final Logger LOG;
    private final int code;

    private WagnisartLeben(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static WagnisartLeben isIn(String code) {
        for (WagnisartLeben existing : WagnisartLeben.values()) {
            if (!code.equals(Integer.toString(existing.getCode()))) continue;
            return existing;
        }
        LOG.warn("Unbekannte Wagnisart '{}' wird auf 'NULL' abgebildet", (Object)code);
        return NULL;
    }

    static {
        LOG = LogManager.getLogger(WagnisartLeben.class);
    }
}

